/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.io;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.PortMapperClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.jms.JMSException;

public class TlqRemoteConnectionHandler
implements ConnectionHandler {
    static Logger logger = LoggerFactory.getLogger(TlqRemoteConnectionHandler.class);
    private static int connectionCount = 0;
    private int counter = 0;
    private Socket socket = null;
    private String host = null;
    private int baseport = 0;
    private int directport = 0;
    private int port = 0;
    private String qcuName = null;
    private MQAddress mqAddress;

    public String getQcuName() {
        return this.qcuName;
    }

    TlqRemoteConnectionHandler(Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl)conn;
        this.directport = 0;
        this.host = connection.getProperty("tmqiBrokerHostName");
        this.baseport = Integer.parseInt(connection.getProperty("tmqiBrokerHostPort"));
        this.directport = Integer.parseInt(connection.getProperty("tmqiBrokerServicePort"));
        String namedservice = connection.getProperty("tmqiBrokerServiceName");
        this.port = this.baseport;
        ConnectionImpl.checkHostPort(this.host, this.port);
        try {
            connection.setLastContactedBrokerAddress(this.getBrokerAddress());
            this.socket = this.makeSocket(this.host, this.port);
            this.counter = ++connectionCount;
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
    }

    TlqRemoteConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        String namedservice;
        ConnectionImpl connection = conn;
        this.port = 0;
        this.host = addr.getHostName();
        this.directport = 0;
        if (addr.isServicePortFinal()) {
            this.directport = addr.getPort();
        }
        this.qcuName = namedservice = addr.getServiceName();
        if (this.directport == 0) {
            PortMapperClient pmc = new PortMapperClient(addr, connection);
            this.baseport = pmc.getHostPort();
            this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tcp", namedservice) : pmc.getPortForProtocol("tcp");
        } else {
            this.port = this.directport;
        }
        conn.setLastContactedBrokerAddress(this.getBrokerAddress());
        ConnectionImpl.checkHostPort(this.host, this.port);
        try {
            this.socket = this.makeSocket(this.host, this.port);
            this.counter = ++connectionCount;
            connection.setLocalIP(this.socket.getLocalAddress().getHostAddress());
            connection.setLocalPort(this.socket.getLocalPort());
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
        this.mqAddress = addr;
    }

    private Socket makeSocket(String host, int port) throws Exception {
        logger.trace("in TCPConnectionHandler.makeSocket()");
        boolean tcpNoDelay = true;
        String prop = System.getProperty("imqTcpNoDelay", "true");
        if (prop.equals("false")) {
            tcpNoDelay = false;
        }
        Socket socket = new Socket(host, port);
        socket.setTcpNoDelay(tcpNoDelay);
        return socket;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    @Override
    public void close() throws JMSException {
        try {
            logger.trace("close a remote Socket {}", this.socket);
            this.socket.close();
        }
        catch (IOException e) {
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public String getBrokerHostName() {
        return this.host;
    }

    @Override
    public String getBrokerAddress() {
        if (this.directport == 0) {
            return this.host + ":" + this.baseport + "(" + this.port + ")";
        }
        return this.host + ":" + this.directport;
    }

    public String toString() {
        String info = null;
        try {
            info = "TCPConnectionHandler: " + this.counter + "-" + this.getLocalPort();
        }
        catch (Exception e) {
            logger.warn("", e);
        }
        return info;
    }

    public Object getTlqWrapper() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTcpNodelay(boolean nodelay) throws SocketException {
        this.socket.setTcpNoDelay(nodelay);
    }

    public MQAddress getMqAddress() {
        return this.mqAddress;
    }
}

