/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.io;

import com.tongtech.tmqi.io.MQAddress;
import java.net.MalformedURLException;
import java.util.Properties;

public class TlqRemoteMQAddress
implements MQAddress {
    protected static final String DEFAULT_SCHEME_NAME = "tlq";
    protected static final String DEFAULT_HOSTNAME = "localhost";
    protected static final int DEFAULT_PORTMAPPER_PORT = 7676;
    protected static final String DEFAULT_SERVICENAME = "jms";
    private String addr = null;
    protected String schemeName = null;
    protected String addrHost = null;
    protected int port = -1;
    protected String serviceName = "qcu1";
    protected boolean isHTTP = false;
    protected Properties props = new Properties();
    protected transient String tostring = null;
    protected transient boolean isSSLHostTrustedSet = false;

    @Override
    public void initialize(String addr) throws MalformedURLException {
        this.addr = addr;
        this.init();
        this.parseAndValidate();
    }

    private void init() {
        this.props.setProperty("isHostTrusted", "false");
    }

    protected void parseAndValidate() throws MalformedURLException {
        String tmp = this.addr;
        this.schemeName = DEFAULT_SCHEME_NAME;
        int i = tmp.indexOf("://");
        if (i > 0) {
            this.schemeName = tmp.substring(0, i);
            tmp = tmp.substring(i + 3);
        }
        if (this.schemeName.equalsIgnoreCase(DEFAULT_SCHEME_NAME) || this.schemeName.equalsIgnoreCase("tlkq")) {
            i = tmp.indexOf(63);
            if (i >= 0) {
                String qs = tmp.substring(i + 1);
                this.parseQueryString(qs);
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.indexOf(47)) >= 0) {
                this.serviceName = tmp.substring(i + 1);
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.lastIndexOf(58)) >= 0) {
                this.port = Integer.parseInt(tmp.substring(i + 1));
                tmp = tmp.substring(0, i);
            }
            this.addrHost = tmp;
            if (this.addrHost == null || this.addrHost.equals("")) {
                this.addrHost = DEFAULT_HOSTNAME;
            }
            if (this.port == -1) {
                this.port = 7676;
            }
            if (this.serviceName == null || this.serviceName.equals("")) {
                this.serviceName = this.getDefaultServiceName();
            }
        } else if (this.schemeName.equalsIgnoreCase("mqssl") || this.schemeName.equalsIgnoreCase("mqtcp")) {
            i = tmp.indexOf(63);
            if (i >= 0) {
                String qs = tmp.substring(i + 1);
                this.parseQueryString(qs);
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.indexOf(47)) >= 0) {
                this.serviceName = tmp.substring(i + 1);
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.indexOf(58)) >= 0) {
                this.port = Integer.parseInt(tmp.substring(i + 1));
                tmp = tmp.substring(0, i);
            }
            this.addrHost = tmp;
            if (this.addrHost == null || this.addrHost.equals("")) {
                throw new MalformedURLException("Illegal address. Hostname missing : " + this.addr);
            }
            if (this.port == -1) {
                throw new MalformedURLException("Illegal address. Port missing : " + this.addr);
            }
        } else {
            if (this.schemeName.equalsIgnoreCase("http") || this.schemeName.equalsIgnoreCase("https")) {
                this.isHTTP = true;
                return;
            }
            if (this.schemeName.equalsIgnoreCase("tlqlocal")) {
                i = tmp.indexOf(63);
                if (i >= 0) {
                    String qs = tmp.substring(i + 1);
                    this.parseQueryString(qs);
                    tmp = tmp.substring(0, i);
                }
                if ((i = tmp.indexOf(47)) >= 0) {
                    this.serviceName = tmp.substring(i + 1);
                    tmp = tmp.substring(0, i);
                }
                if ((i = tmp.indexOf(58)) >= 0) {
                    this.port = Integer.parseInt(tmp.substring(i + 1));
                    tmp = tmp.substring(0, i);
                }
                this.addrHost = tmp;
            } else {
                throw new MalformedURLException("Illegal address. Unknown address scheme : " + this.addr);
            }
        }
    }

    protected void parseQueryString(String qs) throws MalformedURLException {
        String tmp = qs;
        while (tmp.length() > 0) {
            String pair = tmp;
            int i = tmp.indexOf(38);
            if (i >= 0) {
                pair = tmp.substring(0, i);
                tmp = tmp.substring(i + 1);
            } else {
                tmp = "";
            }
            int n = pair.indexOf(61);
            if (n <= 0) {
                throw new MalformedURLException("Illegal address. Bad query string : " + this.addr);
            }
            String name = pair.substring(0, n);
            String value = pair.substring(n + 1);
            this.props.setProperty(name, value);
            if (!"isHostTrusted".equals(name)) continue;
            this.isSSLHostTrustedSet = true;
        }
    }

    @Override
    public boolean isServicePortFinal() {
        return true;
    }

    @Override
    public String getProperty(String pname) {
        return this.props.getProperty(pname);
    }

    @Override
    public boolean getIsSSLHostTrustedSet() {
        return this.isSSLHostTrustedSet;
    }

    @Override
    public String getSchemeName() {
        return this.schemeName;
    }

    @Override
    public String getHostName() {
        return this.addrHost;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public boolean getIsHTTP() {
        return this.isHTTP;
    }

    @Override
    public String getURL() {
        return this.addr;
    }

    @Override
    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        if (this.isHTTP) {
            this.tostring = this.addr;
            return this.addr;
        }
        this.tostring = "tlqlocal".equals(this.schemeName) ? this.schemeName + "://" + this.addrHost + "/" + this.serviceName : this.schemeName + "://" + this.addrHost + ":" + this.port + "/";
        return this.tostring;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MQAddress)) {
            return false;
        }
        return this.toString().equals(((MQAddress)obj).toString());
    }

    @Override
    public String getDefaultServiceName() {
        return DEFAULT_SERVICENAME;
    }

    public static MQAddress getMQAddress(String addr) throws MalformedURLException {
        TlqRemoteMQAddress ret = new TlqRemoteMQAddress();
        ret.initialize(addr);
        return ret;
    }

    @Override
    public int getProtocolType() {
        if (this.isHTTP) {
            return 3;
        }
        if (this.getSchemeName().equals("tlqlocal")) {
            return 1;
        }
        return 2;
    }
}

