/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.ssl;

import com.tongtech.jms.protocol.ssl.SSLConnectionHandler;
import com.tongtech.tmqi.PropertyOwner;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.StreamHandler;
import javax.jms.JMSException;

public class SSLStreamHandler
implements StreamHandler,
PropertyOwner {
    @Override
    public String[] getPropertyNames() {
        String[] propnames = new String[]{"tmqiBrokerHostName", "tmqiBrokerHostPort", "tmqiBrokerServicePort", "tmqiBrokerServiceName", "tmqiSSLProviderClassname", "tmqiSSLIsHostTrusted"};
        return propnames;
    }

    @Override
    public String getPropertyType(String propname) {
        if ("tmqiBrokerHostName".equals(propname) || "tmqiBrokerServiceName".equals(propname) || "tmqiSSLProviderClassname".equals(propname)) {
            return "java.lang.String";
        }
        if ("tmqiBrokerHostPort".equals(propname)) {
            return "java.lang.Integer";
        }
        if ("tmqiSSLIsHostTrusted".equals(propname)) {
            return "java.lang.Boolean";
        }
        return null;
    }

    @Override
    public String getPropertyLabel(String propname) {
        if ("tmqiBrokerHostName".equals(propname)) {
            return "L0502";
        }
        if ("tmqiBrokerHostPort".equals(propname)) {
            return "L0503";
        }
        if ("tmqiSSLProviderClassname".equals(propname)) {
            return "L0504";
        }
        if ("tmqiSSLIsHostTrusted".equals(propname)) {
            return "L0505";
        }
        if ("tmqiBrokerServicePort".equals(propname)) {
            return "L0529";
        }
        if ("tmqiBrokerServiceName".equals(propname)) {
            return "L0528";
        }
        return null;
    }

    @Override
    public String getPropertyDefault(String propname) {
        if ("tmqiBrokerHostName".equals(propname)) {
            return "localhost";
        }
        if ("tmqiBrokerHostPort".equals(propname)) {
            return "7676";
        }
        if ("tmqiSSLProviderClassname".equals(propname)) {
            return "com.sun.net.ssl.internal.ssl.Provider";
        }
        if ("tmqiSSLIsHostTrusted".equals(propname)) {
            return "false";
        }
        if ("tmqiBrokerServicePort".equals(propname)) {
            return "0";
        }
        if ("tmqiBrokerServiceName".equals(propname)) {
            return "";
        }
        return null;
    }

    @Override
    public ConnectionHandler openConnection(Object connection) throws JMSException {
        return new SSLConnectionHandler(connection);
    }

    @Override
    public ConnectionHandler openConnection(MQAddress addr, ConnectionImpl connection) throws JMSException {
        return new SSLConnectionHandler(addr, connection);
    }
}

