/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.ActivationBase;
import com.tongtech.jms.ra.core.ActivationMBean;
import com.tongtech.jms.ra.core.Delivery;
import com.tongtech.jms.ra.core.DeliveryStats;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.RedeliveryHandler;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import com.tongtech.jms.ra.util.Utility;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class Activation
extends ActivationBase {
    private static Logger sLog = Logger.getLogger(Activation.class);
    private RAJMSResourceAdapter mRA;
    private MessageEndpointFactory mEndpointFactory;
    private RAJMSActivationSpec mSpec;
    private Method mOnMessageMethod;
    private DeliveryStats mStats;
    private Delivery mDelivery;
    private boolean mIsCMT;
    private boolean mIsXAEmulated;
    private boolean mIsTopic;
    private boolean mIsDurable;
    private boolean mMinimalReconnectLogging;
    private boolean mMinimalReconnectLoggingDurSub;
    private ActivationMBean mActivationMBean;
    private ObjectName mServerMgtMBeanName;
    private int mDeliveryMode;
    private static final Localizer LOCALE = Localizer.get();
    private static final String[] STATES = new String[]{"Disconnected", "Connecting", "Connected", "Disconnecting"};
    public static final int DISCONNECTED = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int DISCONNECTING = 3;
    private Object mLock = new Object();
    private int mState = 0;
    private boolean mXConnectingInterruptRequest;
    private boolean mRedeliveryRedirect;
    private boolean mWrapAlways;
    private RAJMSObjectFactory mObjFactory;
    private String mURL;
    private boolean mStopByConnectorInProgress;

    public Activation(RAJMSResourceAdapter ra, MessageEndpointFactory epf, RAJMSActivationSpec spec) {
        super(ra, epf, spec);
        this.mRA = ra;
        this.mEndpointFactory = epf;
        this.mSpec = spec;
        String url = spec.getConnectionURL();
        if (url == null || url.length() == 0) {
            url = ra.getConnectionURL();
        }
        this.mURL = url;
        this.mObjFactory = ra.createObjectFactory(url);
    }

    public int getDeliveryMode() {
        return this.mDeliveryMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleepAndMonitorStatus(long sleepInMilliseconds) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mState != 2) {
                    return;
                }
                this.mLock.wait(sleepInMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public RAJMSObjectFactory getObjectFactory() {
        return this.mObjFactory;
    }

    @Override
    public void activate() throws Exception {
        try {
            try {
                Class<MessageListener> msgListenerClass = MessageListener.class;
                Class[] paramTypes = new Class[]{Message.class};
                this.mOnMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
            }
            catch (NoSuchMethodException ex) {
                LocalizedString msg = LOCALE.x("E008: {0}: could not locate onMessage() function: {1}", this.getName(), ex);
                sLog.fatal(msg, ex);
                throw new RuntimeException(msg.toString(), ex);
            }
            this.mIsCMT = this.mEndpointFactory.isDeliveryTransacted(this.mOnMessageMethod);
            Properties p = new Properties();
            this.getObjectFactory().getProperties(p, this.getRA(), this.getActivationSpec(), null, null);
            if (this.mIsCMT) {
                boolean forceBMT = Utility.isTrue(p.getProperty("JMSJCA.ForceBMT"), false);
                this.mIsCMT = !(forceBMT = Utility.getSystemProperty("JMSJCA.ForceBMT", forceBMT));
            }
            this.mIsXAEmulated = Utility.getSystemProperty("JMSJCA.NoXA", Utility.isTrue(p.getProperty("JMSJCA.NoXA"), false));
            this.mRedeliveryRedirect = Utility.isTrue(p.getProperty("JMSJCA.redeliveryredirect"), false);
            this.mWrapAlways = "1".equals(p.getProperty("JMSJCA.messagewrapping", "1"));
            String redeliveryHandling = p.getProperty("JMSJCA.redeliveryhandling", this.mSpec.getRedeliveryHandling());
            RedeliveryHandler.parse(redeliveryHandling, this.mSpec.getDestination(), this.mSpec.getDestinationType());
            this.mSpec.setRedeliveryHandling(redeliveryHandling);
            this.mMinimalReconnectLogging = "1".equals(p.getProperty("JMSJCA.minimalreconnectlogging", "0"));
            this.mMinimalReconnectLoggingDurSub = "1".equals(p.getProperty("JMSJCA.minimalreconnectloggingds", "0"));
            this.mIsTopic = "javax.jms.Topic".equals(this.mSpec.getDestinationType());
            this.mIsDurable = "Durable".equals(this.mSpec.getSubscriptionDurability());
            if (sLog.isDebugEnabled()) {
                sLog.debug("CMT: " + this.mIsCMT + "; isTopic: " + this.mIsTopic + "; isDurable: " + this.mIsDurable + "; isXAEmulation: " + this.mIsXAEmulated);
            }
            if (this.getActivationSpec().getMBeanName() != null && this.getActivationSpec().getMBeanName().length() != 0) {
                ObjectName mbeanName = new ObjectName(this.getActivationSpec().getMBeanName());
                MBeanServer mbeanServer = this.getRA().getMBeanServer();
                this.mActivationMBean = this.getObjectFactory().createActivationMBean(this);
                mbeanServer.registerMBean(this.mActivationMBean, mbeanName);
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Registered MBean [" + this.mActivationMBean + "] in server [" + mbeanServer.getDefaultDomain() + "] using name [" + mbeanName + "]");
                }
                Object serverMgtMBean = this.getObjectFactory().getServerMgtMBean(this.getRA(), this.getActivationSpec());
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Server mgt mbean=" + serverMgtMBean);
                }
                if (serverMgtMBean != null) {
                    if (serverMgtMBean instanceof String) {
                        this.mActivationMBean.setJmsServerMBean((String)serverMgtMBean);
                    } else {
                        String name = this.getActivationSpec().getMBeanName() + ",servermgt=true";
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Registering server mgt mbean with name " + name);
                        }
                        ObjectName mgtmbeanName = new ObjectName(name);
                        mbeanServer.registerMBean(serverMgtMBean, mgtmbeanName);
                        this.mServerMgtMBeanName = mgtmbeanName;
                        this.mActivationMBean.setJmsServerMBean(name);
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Registered server mgt mbean with name " + name);
                        }
                    }
                }
            }
            this.mStats = new DeliveryStats();
            String overridemode = p.getProperty("JMSJCA.concurrencymode", null);
            if (overridemode != null) {
                this.mSpec.setConcurrencyMode(overridemode);
            }
            this.mDeliveryMode = this.mSpec.getDeliveryConcurrencyMode();
            this.mDeliveryMode = this.getObjectFactory().adjustDeliveryMode(this.mDeliveryMode, this.mIsCMT && !this.mIsXAEmulated);
            this.internalStart();
        }
        catch (Exception e) {
            this.killMBean();
            throw e;
        }
    }

    public DeliveryStats getStats() {
        return this.mStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        Object object = this.mLock;
        synchronized (object) {
            this.mState = state;
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStart() throws Exception {
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case 0: {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Activation.this.asyncStart();
                        }
                    }, "JMSJCA connect").start();
                    this.mXConnectingInterruptRequest = false;
                    this.setState(1);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    throw new Exception(LOCALE.x("E118: Internal error: Invalid state: cannot call start() when state is DISCONNECTING").toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStop() {
        Object object;
        while (true) {
            object = this.mLock;
            synchronized (object) {
                try {
                    if (this.mState == 0) {
                        return;
                    }
                    if (this.mState == 1) {
                        this.mXConnectingInterruptRequest = true;
                        this.mLock.wait();
                    } else {
                        if (this.mState == 2) {
                            this.setState(3);
                            break;
                        }
                        if (this.mState == 3) {
                            this.mLock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    sLog.warn(LOCALE.x("E011: [{0}]: stop() operation was interrupted; state is now {1}", this.getName(), STATES[this.mState]));
                    return;
                }
            }
        }
        this.mDelivery.deactivate();
        this.mDelivery = null;
        object = this.mLock;
        synchronized (object) {
            this.setState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDistress(Exception ex) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == 0) {
                sLog.warn(LOCALE.x("E012: [{0}]: inconsistency error: the following exception was encountered while the connector is in DISCONNECTED mode: {1}", this.getName(), ex), ex);
                return;
            }
            if (this.mState == 1) {
                sLog.warn(LOCALE.x("E013: [{0}]: the following exception was encountered while initiating or during message delivery: [{1}]; adapter is already in reconnect mode.", this.getName(), ex), ex);
                return;
            }
            if (this.mState == 2) {
                sLog.warn(LOCALE.x("E014: [{0}]: the following exception was encountered while initiating or during message delivery: [{1}]; attempts will be made to (re-)start message delivery (auto reconnect mode).", this.getName(), ex), ex);
                this.setState(3);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Activation.this.asyncStart();
                    }
                }, "JMSJCA reconnect").start();
                return;
            }
            if (this.mState == 3) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnectorByMDB(String msg) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStopByConnectorInProgress) {
                return;
            }
            this.mStopByConnectorInProgress = true;
        }
        try {
            sLog.warn(LOCALE.x("E114: [{0}]: the MDB requested a shutdown of the connector. No messages will be delivered until message delivery is restarted. The reason for the shutdown is: {1}", this.getName(), msg));
            Thread t = new Thread("JMSJCA shutdown by MDB"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Starting deactivation by MDB");
                        }
                        Activation.this.stop();
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Deactivation by MDB finished");
                        }
                    }
                    finally {
                        Object object = Activation.this.mLock;
                        synchronized (object) {
                            Activation.this.mStopByConnectorInProgress = false;
                        }
                    }
                }
            };
            t.start();
        }
        catch (RuntimeException e) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mStopByConnectorInProgress = false;
            }
            throw e;
        }
    }

    protected Delivery createDelivery() throws Exception {
        return this.getObjectFactory().createDelivery(this.mDeliveryMode, this, this.mStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncStart() {
        int state;
        Object object = this.mLock;
        synchronized (object) {
            state = this.mState;
        }
        if (state == 3) {
            this.mDelivery.deactivate();
            this.mDelivery = null;
            this.setState(1);
        }
        int[] dts = new int[]{1, 2, 5, 5, 10};
        int attempt = 0;
        long tryAgainAt = 0L;
        while (true) {
            Object object2 = this.mLock;
            synchronized (object2) {
                if (this.mXConnectingInterruptRequest) {
                    this.mXConnectingInterruptRequest = false;
                    this.setState(0);
                    return;
                }
            }
            if (System.currentTimeMillis() > tryAgainAt) {
                try {
                    this.mDelivery = this.createDelivery();
                    this.mDelivery.start();
                    sLog.info(LOCALE.x("E015: [{0}]: message delivery initiation was successful.", this.getName()));
                    this.setState(2);
                    break;
                }
                catch (Exception e) {
                    this.mDelivery.deactivate();
                    this.mDelivery = null;
                    int dt = attempt < dts.length ? dts[attempt] : dts[dts.length - 1];
                    this.logDeliveryInitiationException(attempt + 1, dt, e);
                    tryAgainAt = System.currentTimeMillis() + (long)(dt * 1000);
                    ++attempt;
                    sLog.errorNoloc("hava some error!!", e);
                }
            }
            Object e = this.mLock;
            synchronized (e) {
                if (this.mXConnectingInterruptRequest) {
                    this.mXConnectingInterruptRequest = false;
                    this.setState(0);
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                sLog.info(LOCALE.x("E017: [{0}]: message delivery initiation attempt was interrupted", this.getName()));
                break;
            }
        }
    }

    protected void logDeliveryInitiationException(int attemptPlusOne, int dt, Exception e) {
        if (!this.mMinimalReconnectLogging && !this.mMinimalReconnectLoggingDurSub) {
            sLog.warn(LOCALE.x("E016: [{0}]: message delivery initiation failed (attempt #{1}); will retry in {2} seconds. The error was: {3}", this.getName(), Integer.toString(attemptPlusOne), Integer.toString(dt), e), e);
        } else if (attemptPlusOne <= 1) {
            Throwable ex;
            Throwable throwable = ex = e instanceof Exc.ConsumerCreationException ? e.getCause() : e;
            if (e instanceof Exc.ConsumerCreationException && this.mMinimalReconnectLoggingDurSub) {
                sLog.info(LOCALE.x("E204: [{0}]: message delivery could not be initiated due to a failure to create the subscriber. Assuming that this deployment is on a node in a cluster, there is likely another cluster node already receiving messages from this subscriber. The subscriber creation attempt will be retried periodically to detect when the active subscriber disconnects. Subsequent unsuccessful attempts to subscribe will not be logged. The subscriber could not created because of the following error: {3}", this.getName(), Integer.toString(attemptPlusOne), Integer.toString(dt), ex), ex);
            } else {
                sLog.error(LOCALE.x("E205: [{0}]: message delivery could not be initiated but will be retried periodically. Subsequent unsuccessful attempts will not be logged. The error was: {3}", this.getName(), Integer.toString(attemptPlusOne), Integer.toString(dt), ex), ex);
            }
        }
    }

    public void stop() {
        Delivery d = this.mDelivery;
        if (d != null && d.isThisCalledFromOnMessage()) {
            this.stopConnectorByMDB("<unspecified>");
        } else {
            this.internalStop();
        }
    }

    public void start() throws Exception {
        this.internalStart();
    }

    @Override
    public void deactivate() {
        try {
            this.internalStop();
        }
        catch (RuntimeException e) {
            sLog.warn(LOCALE.x("E018: Unexpected exception in endpoint deactivation: {0}", e), e);
        }
        try {
            this.killMBean();
        }
        catch (RuntimeException e) {
            sLog.warn(LOCALE.x("E019: Unexpected exception in undeploying MBean during endpoint deactivation: {0}", e), e);
        }
    }

    public void distress(Exception ex) {
        this.internalDistress(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopping() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState == 0 || this.mState == 3;
        }
    }

    public Method getOnMessageMethod() {
        return this.mOnMessageMethod;
    }

    public boolean isCMT() {
        return this.mIsCMT;
    }

    public boolean isXAEmulated() {
        return this.mIsXAEmulated;
    }

    public boolean isTopic() {
        return this.mIsTopic;
    }

    public boolean isDurable() {
        return this.mIsDurable;
    }

    private void killMBean() {
        if (this.mServerMgtMBeanName != null) {
            try {
                this.getRA().getMBeanServer().unregisterMBean(this.mServerMgtMBeanName);
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E020: [{0}]: exception on unregistering server MBean [{1}]: {2}", this.getName(), this.mServerMgtMBeanName, e), e);
            }
            this.mServerMgtMBeanName = null;
        }
        if (this.mActivationMBean != null) {
            this.mActivationMBean.destroy();
            this.mActivationMBean = null;
        }
    }

    @Override
    public RAJMSResourceAdapter getRA() {
        return this.mRA;
    }

    @Override
    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.mEndpointFactory;
    }

    @Override
    public RAJMSActivationSpec getActivationSpec() {
        return this.mSpec;
    }

    @Override
    public boolean is(MessageEndpointFactory epf, RAJMSActivationSpec spec) {
        return this.mEndpointFactory.equals(epf) && this.mSpec.equals(spec);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUserName() {
        String ret = this.mRA.getUserName();
        if (!Str.empty(this.mSpec.getUserName())) {
            ret = this.mSpec.getUserName();
        }
        return ret;
    }

    public String getPassword() {
        String ret = this.mRA.getClearTextPassword();
        if (!Str.empty(this.mSpec.getUserName())) {
            ret = this.mSpec.getClearTextPassword();
        }
        return ret;
    }

    public int dumpNumberConfiguredEndpoints() {
        Delivery d = this.mDelivery;
        if (d != null) {
            return d.getConfiguredEndpoints();
        }
        return -1;
    }

    public String dumpDelivery() {
        Delivery d = this.mDelivery;
        if (d != null) {
            return d.toString();
        }
        return "No delivery object";
    }

    @Override
    public String getName() {
        String consumertype = Queue.class.getName().equals(this.mSpec.getDestinationType()) ? "QueueReceiver" : ("Durable".equals(this.mSpec.getSubscriptionDurability()) ? "Durable TopicSubscriber(" + this.mSpec.getSubscriptionName() + ")" : "NonDurable TopicSubscriber");
        String deliveryType = Integer.toString(this.mDeliveryMode);
        if (this.mDeliveryMode >= 0 && this.mDeliveryMode < RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS.length) {
            deliveryType = RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS[this.mDeliveryMode];
        }
        String selector = "";
        try {
            selector = this.getObjectFactory().getMessageSelector(this.getRA(), this.mSpec);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        selector = !Str.empty(selector) ? "(" + selector + ")" : "";
        return deliveryType + "-" + consumertype + "(" + this.mSpec.getDestination() + ")" + selector + " @ [" + this.mURL + "]";
    }

    public boolean shouldRedirectRatherThanForward() {
        return this.mRedeliveryRedirect;
    }

    public boolean shouldWrapAlways() {
        return this.mWrapAlways;
    }

    public String getmURL() {
        return this.mURL;
    }

    public void setmURL(String mURL) {
        this.mURL = mURL;
    }
}

