/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public abstract class ActivationBase {
    private RAJMSResourceAdapter mRA;
    private MessageEndpointFactory mEndpointFactory;
    private RAJMSActivationSpec mSpec;
    private String mName;
    public static final String[] STATES = new String[]{"Disconnected", "Connecting", "Connected", "Disconnecting"};
    public static final int DISCONNECTED = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int DISCONNECTING = 3;
    private RAJMSObjectFactory mObjFactory;

    public ActivationBase(RAJMSResourceAdapter ra, MessageEndpointFactory epf, RAJMSActivationSpec spec) {
        this.mRA = ra;
        this.mEndpointFactory = epf;
        this.mSpec = spec;
        String url = spec.getConnectionURL();
        if (url == null || url.length() == 0) {
            url = ra.getConnectionURL();
        }
        this.mObjFactory = ra.createObjectFactory(url);
        this.mName = spec.getDestinationType() + " [" + spec.getDestination() + "] on [" + url + "]";
    }

    public RAJMSObjectFactory getObjectFactory() {
        return this.mObjFactory;
    }

    public abstract void activate() throws Exception;

    public abstract void deactivate();

    public RAJMSResourceAdapter getRA() {
        return this.mRA;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.mEndpointFactory;
    }

    public RAJMSActivationSpec getActivationSpec() {
        return this.mSpec;
    }

    public boolean is(MessageEndpointFactory epf, RAJMSActivationSpec spec) {
        return this.mEndpointFactory.equals(epf) && this.mSpec.equals(spec);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.mName;
    }
}

