/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.Activation;
import com.tongtech.jms.ra.core.Delivery;
import com.tongtech.jms.ra.core.DeliveryStats;
import com.tongtech.jms.ra.core.PseudoXAResource;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.WorkContainer;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Latch;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Semaphore;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class CCDelivery
extends Delivery
implements ServerSessionPool,
ExceptionListener {
    private static Logger sLog = Logger.getLogger(CCDelivery.class);
    private WorkManager mWorkManager;
    private ArrayList mEmptyWorkContainers = new ArrayList();
    private ArrayList mAllWorkContainers = new ArrayList();
    private Object mStateLock = new Object();
    private int mNMaxWorkContainers;
    private Semaphore mEmptyWorkContainerSemaphore = new Semaphore(0L);
    private Latch mServerSessionBlock = new Latch();
    private Connection mConnection;
    private static final Localizer LOCALE = Localizer.get();

    public CCDelivery(Activation a, DeliveryStats stats) throws Exception {
        super(a, stats);
        this.mNMaxWorkContainers = a.getActivationSpec().getEndpointPoolMaxSize();
        this.mWorkManager = a.getRA().getBootstrapCtx().getWorkManager();
    }

    @Override
    public void start() throws Exception {
        RAJMSObjectFactory o = this.mActivation.getObjectFactory();
        int domain = XConnectionRequestInfo.guessDomain(this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic());
        ConnectionFactory fact = o.createConnectionFactory(domain, this.mActivation.getRA(), this.mActivation.getActivationSpec(), null, null);
        String url = this.mActivation.getmURL();
        String[] urls = url.split(",");
        if (urls != null && urls.length > 1) {
            domain = 7;
        }
        this.mConnection = o.createConnection(fact, domain, this.mActivation.getActivationSpec(), this.mActivation.getRA(), this.mActivation.getUserName() == null ? this.mActivation.getRA().getUserName() : this.mActivation.getUserName(), this.mActivation.getPassword() == null ? this.mActivation.getRA().getClearTextPassword() : this.mActivation.getPassword());
        o.setClientID(this.mConnection, this.mActivation.isTopic(), this.mActivation.getActivationSpec(), this.mActivation.getRA());
        Session sess = o.createSession(this.mConnection, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic() ? TopicSession.class : QueueSession.class, this.mActivation.getRA(), this.mActivation.getActivationSpec(), false, 1);
        Destination dest = o.createDestination(sess, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic(), this.mActivation.getActivationSpec(), null, this.mActivation.getRA(), this.mActivation.getActivationSpec().getDestination());
        this.createDLQDest(sess);
        sess.close();
        o.createConnectionConsumer(this.mConnection, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic(), this.mActivation.isDurable(), this.mActivation.getActivationSpec(), this.mActivation.getRA(), dest, this.mActivation.getActivationSpec().getSubscriptionName(), o.getMessageSelector(this.mActivation.getRA(), this.mActivation.getActivationSpec()), this, this.mBatchSize < 1 ? 1 : this.mBatchSize);
        this.mConnection.setExceptionListener((ExceptionListener)this);
        this.mConnection.start();
    }

    public ServerSession getServerSession() throws JMSException {
        if (this.mActivation.isStopping()) {
            try {
                this.mServerSessionBlock.acquire();
            }
            catch (InterruptedException e) {
                throw Exc.jmsExc(LOCALE.x("E039: Shutdown procedure interruped: {0}", e), e);
            }
            throw Exc.jmsExc(LOCALE.x("E041: Shutting down. This exception may appear as part of a normal shutdown operation and may not imply any error condition."));
        }
        WorkContainer ret = null;
        try {
            ret = this.getEmptyWorkContainer();
        }
        catch (Exception ex) {
            LocalizedString msg = LOCALE.x("E001: Unexpected failure to obtain an empty work container to process JMS messages. The exception was: {0}", ex);
            JMSException jex = Exc.jmsExc(msg, ex);
            this.onException(jex);
            throw new RuntimeException(msg.toString(), ex);
        }
        return ret;
    }

    public boolean scheduleWork(Work work) {
        try {
            this.mWorkManager.scheduleWork(work);
            return true;
        }
        catch (WorkException ex) {
            JMSException jex = Exc.jmsExc(LOCALE.x("E072: Unexpected failure scheduling work to process JMS messages. The exception was: {0}", (Object)ex), (Exception)((Object)ex));
            this.onException(jex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEmptyWorkContainer(WorkContainer w) {
        Object object = this.mStateLock;
        synchronized (object) {
            this.mEmptyWorkContainers.add(w);
            this.mEmptyWorkContainerSemaphore.release(1L);
        }
    }

    private static void safeClose(Session s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private void growPoolIfNecessary() throws Exception {
        boolean shouldGrow;
        int nTotalWorkContainers = this.mAllWorkContainers.size();
        boolean bl = shouldGrow = nTotalWorkContainers < this.mNMaxWorkContainers && this.mEmptyWorkContainerSemaphore.peek() == 0L;
        if (shouldGrow) {
            Session s = null;
            try {
                MessageEndpoint m;
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Growing pool; current size=" + nTotalWorkContainers + "; max=" + this.mNMaxWorkContainers);
                }
                s = this.mActivation.getObjectFactory().createSession(this.mConnection, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic() ? TopicSession.class : QueueSession.class, this.mActivation.getRA(), this.mActivation.getActivationSpec(), true, 1);
                XAResource xa = null;
                if (this.mActivation.isCMT()) {
                    xa = !this.mActivation.isXAEmulated() ? this.mActivation.getObjectFactory().getXAResource(true, s) : new PseudoXAResource(s);
                }
                if ((m = this.createMessageEndpoint(xa, s)) == null) {
                    CCDelivery.safeClose(s);
                } else {
                    WorkContainer w = new WorkContainer(this, m, this.mActivation.getOnMessageMethod(), s, this.mConnection, new Delivery.MDB(this, xa));
                    s.setMessageListener(this.mActivation.getObjectFactory().getMessagePreprocessor(w, this.mActivation.isCMT() && !this.mActivation.isXAEmulated()));
                    this.addEmptyWorkContainer(w);
                    this.mAllWorkContainers.add(w);
                }
            }
            catch (Exception ex) {
                CCDelivery.safeClose(s);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkContainer getEmptyWorkContainer() throws Exception {
        WorkContainer ret;
        block8: {
            ret = null;
            this.growPoolIfNecessary();
            while (!this.mEmptyWorkContainerSemaphore.attempt(1000L)) {
                if (this.mActivation.isStopping()) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug("getEmptyWorkContainer(): Stopping waiting for WorkContainer; throwing exception");
                    }
                    throw Exc.exc(LOCALE.x("E115: Cannot create endpoint: connector is shutting down"));
                }
                if (!sLog.isDebugEnabled()) continue;
                sLog.debug("getEmptyWorkContainer(): still waiting");
            }
            Object object = this.mStateLock;
            synchronized (object) {
                ret = (WorkContainer)this.mEmptyWorkContainers.remove(this.mEmptyWorkContainers.size() - 1);
            }
            if (!ret.hasEndpoint()) {
                MessageEndpoint mep = this.createMessageEndpoint(ret.getXAResource(), ret.getSession());
                ret.setEndpoint(mep);
                if (mep == null) {
                    throw Exc.exc(LOCALE.x("E115: Cannot create endpoint: connector is shutting down"));
                }
            }
            if (!sLog.isDebugEnabled()) break block8;
            sLog.debug("getEmptyWorkContainer(): succeeded: " + ret);
        }
        return ret;
    }

    public void workDone(WorkContainer w) {
        this.addEmptyWorkContainer(w);
    }

    private void waitUntilAllWorkContainersAreDestroyed() {
        long tlog = System.currentTimeMillis() + 15000L;
        while (true) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Trying to destroy all WorkContainer-s");
            }
            int nNotDestroyed = 0;
            for (WorkContainer w : this.mAllWorkContainers) {
                if (w.destroy()) continue;
                ++nNotDestroyed;
            }
            if (nNotDestroyed == 0) {
                if (!sLog.isDebugEnabled()) break;
                sLog.debug("All work containers were destroyed successfully");
                break;
            }
            if (System.currentTimeMillis() > tlog) {
                sLog.info(LOCALE.x("E021: Deactivating connector; waiting for work containers finish processing messages; there are {0} containers that are still active; activation={1}", Integer.toString(nNotDestroyed), this.mActivation));
                tlog = System.currentTimeMillis() + 15000L;
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug(nNotDestroyed + " WorkContainer(s) were (was) not destroyed... waiting");
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
    }

    private void closeConnection() {
        try {
            if (this.mConnection != null) {
                this.mConnection.close();
            }
        }
        catch (Exception ex) {
            sLog.warn(LOCALE.x("E055: Unexpected exception closing JMS connection: {0}", ex), ex);
        }
        this.mConnection = null;
    }

    private void deactivateGeneral() {
        this.waitUntilAllWorkContainersAreDestroyed();
        this.mServerSessionBlock.release();
        this.closeConnection();
    }

    @Override
    public void deactivate() {
        if (sLog.isDebugEnabled()) {
            sLog.debug("CCDelivery.deactivate() -- begin");
        }
        this.deactivateGeneral();
        this.mEmptyWorkContainers.clear();
        this.mAllWorkContainers.clear();
        this.mEmptyWorkContainerSemaphore = new Semaphore(0L);
        if (sLog.isDebugEnabled()) {
            sLog.debug("CCDelivery.deactivate() -- complete");
        }
    }

    public void onException(JMSException ex) {
        this.mActivation.distress((Exception)((Object)ex));
    }

    @Override
    public int getConfiguredEndpoints() {
        return this.mNMaxWorkContainers;
    }
}

