/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

public class DeliveryStats {
    private int mNMessages;
    private long mt0;
    private long mt1;
    private long mt2;
    private long mt3;
    private long mt4;
    private int mn0 = 1;
    private int mn1 = 1000;
    private int mn2 = 10000;
    private int mn3 = 20000;
    private int mn4 = 100000;
    private int mNEndpoints;
    private int mNActiveEndpoints;
    private int mNHighestActiveEndpoints;
    private int mRedeliveredMsgs;
    private int mRedeliveries;

    public synchronized void reset() {
        this.mNMessages = 0;
        this.mt0 = 0L;
        this.mt1 = 0L;
        this.mt2 = 0L;
        this.mt3 = 0L;
        this.mt4 = 0L;
        this.mNHighestActiveEndpoints = 0;
    }

    public synchronized void messageDelivered() {
        ++this.mNMessages;
        if (this.mNMessages == this.mn0) {
            this.mt0 = System.currentTimeMillis();
        } else if (this.mNMessages == this.mn1) {
            this.mt1 = System.currentTimeMillis();
        } else if (this.mNMessages == this.mn2) {
            this.mt2 = System.currentTimeMillis();
        } else if (this.mNMessages == this.mn3) {
            this.mt3 = System.currentTimeMillis();
        } else if (this.mNMessages == this.mn4) {
            this.mt4 = System.currentTimeMillis();
        }
        --this.mNActiveEndpoints;
    }

    public synchronized void aboutToDeliverMessage() {
        ++this.mNActiveEndpoints;
        if (this.mNActiveEndpoints > this.mNHighestActiveEndpoints) {
            this.mNHighestActiveEndpoints = this.mNActiveEndpoints;
        }
    }

    public synchronized void addMessageEndpoint() {
        ++this.mNEndpoints;
    }

    public synchronized void removeMessageEndpoint() {
        --this.mNEndpoints;
    }

    public synchronized int getNMessages() {
        return this.mNMessages;
    }

    private String rate(int n, long dt) {
        if (n <= 0 || dt <= 0L) {
            return "n/a";
        }
        return "" + 1000.0f * (float)n / (float)dt;
    }

    public synchronized String toString() {
        long tnow = System.currentTimeMillis();
        return "nMessages=" + this.mNMessages + "; t(" + this.mn0 + ")=" + this.mt0 + "; t(" + this.mn1 + ")=" + this.mt1 + "; t(" + this.mn2 + ")=" + this.mt2 + "; t(" + this.mn3 + ")=" + this.mt3 + "; t(" + this.mn4 + ")=" + this.mt4 + "; t(now)=" + tnow + "; rate(" + this.mn0 + "," + this.mn1 + ")=" + this.rate(this.mn1 - this.mn0, this.mt1 - this.mt0) + "; rate(" + this.mn1 + "," + this.mn2 + ")=" + this.rate(this.mn2 - this.mn1, this.mt2 - this.mt1) + "; rate(" + this.mn2 + "," + this.mn3 + ")=" + this.rate(this.mn3 - this.mn2, this.mt3 - this.mt2) + "; rate(" + this.mn3 + "," + this.mn4 + ")=" + this.rate(this.mn4 - this.mn3, this.mt4 - this.mt3) + "; rate(" + this.mn0 + "," + this.mNMessages + ")=" + this.rate(this.mNMessages - this.mn1, tnow - this.mt0) + "; nEndpoints=" + this.mNEndpoints + "; nRedelivies=" + this.mRedeliveries + "; nRedeliveredMsgs=" + this.mRedeliveredMsgs;
    }

    public synchronized int getNTotalEndpoints() {
        return this.mNEndpoints;
    }

    public int getNActiveEndpoints() {
        return this.mNActiveEndpoints;
    }

    public int getNHighestEndpoints() {
        return this.mNHighestActiveEndpoints;
    }

    public void msgRedelivered() {
        ++this.mRedeliveries;
    }

    public void msgRedeliveredFirstTime() {
        ++this.mRedeliveredMsgs;
    }
}

