/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TxMgr {
    private TxMgrAdapter mTxMgrAdapter;
    private static TransactionManager sUnitTestTxMgr;
    private static final Localizer LOCALE;
    Logger logger = LoggerFactory.getLogger(TxMgr.class);

    public void init(Properties p) {
        this.getTxMgrAdapter();
    }

    public static void safeClose(Context ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public boolean isInTransaction() {
        try {
            TxMgrAdapter txm = this.getTxMgrAdapter();
            if (txm != null) {
                return txm.isInTransaction();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void register(Synchronization sync) {
        try {
            TxMgrAdapter txm = this.getTxMgrAdapter();
            if (txm != null) {
                txm.register(sync);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TransactionManager getTransactionManager() throws Exception {
        TxMgrAdapter txm = this.getTxMgrAdapter();
        if (txm != null) {
            return txm.getTransactionManager();
        }
        throw Exc.exc(LOCALE.x("E152: Could not find transaction manager adapter"));
    }

    private TxMgrAdapter getTxMgrAdapter() {
        if (this.mTxMgrAdapter != null) {
            return this.mTxMgrAdapter;
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new UnitTest().init();
            this.logger.debug("get UnitTest TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new SJSAS().init();
            this.logger.debug("get SJSAS TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new TongWeb().init();
            this.logger.debug("get TongWeb TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new GlobalJNDI("javax.transaction.TransactionManager").init();
            this.logger.debug("get GlobalJNDI TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new LocalJNDI("java:/TransactionManager").init();
            this.logger.debug("get LocalJNDI TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new WL9().init();
            this.logger.debug("get WL9 TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new WAS6a().init();
            this.logger.debug("get WAS6a TransactionManager {} ", this.mTxMgrAdapter);
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new LocalJNDI("java:appserver/TransactionManager").init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new LocalJNDI("java:comp/UserTransaction").init();
            this.logger.debug("get LocalJNDI java:comp/UserTransaction TransactionManager {} ", this.mTxMgrAdapter);
        }
        return this.mTxMgrAdapter;
    }

    public static void setUnitTestTxMgr(TransactionManager txmgr) {
        sUnitTestTxMgr = txmgr;
    }

    public static TransactionManager getUnitTestTxMgr() {
        return sUnitTestTxMgr;
    }

    static {
        LOCALE = Localizer.get();
    }

    private class LocalJNDI
    extends TxMgrAdapter {
        private String mName;

        public LocalJNDI(String name) {
            this.mName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TxMgrAdapter init() {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                TransactionManager mgr = (TransactionManager)ctx.lookup(this.mName);
                TxMgr.this.logger.debug("LocalJNDI  get  TransactionManager object is:" + mgr);
                LocalJNDI localJNDI = mgr == null ? null : this;
                return localJNDI;
            }
            catch (Exception ignore) {
                TxMgr.this.logger.debug("get LocalJNDI TransactionManager fail." + ignore.getMessage() + ", " + this.mName);
            }
            finally {
                TxMgr.safeClose(ctx);
            }
            return null;
        }

        @Override
        public TransactionManager getTransactionManager() throws Exception {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                TransactionManager transactionManager = (TransactionManager)ctx.lookup(this.mName);
                return transactionManager;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                TxMgr.safeClose(ctx);
            }
        }
    }

    private class GlobalJNDI
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;
        private String mName;

        public GlobalJNDI(String name) {
            this.mName = name;
        }

        @Override
        public TxMgrAdapter init() {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                this.mTransactionManager = (TransactionManager)ctx.lookup(this.mName);
                GlobalJNDI globalJNDI = this;
                return globalJNDI;
            }
            catch (Exception ignore) {
                TxMgr.this.logger.debug("get GlobalJNDI TransactionManager fail." + ignore.getMessage());
            }
            finally {
                TxMgr.safeClose(ctx);
            }
            return null;
        }

        @Override
        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class UnitTest
    extends TxMgrAdapter {
        private UnitTest() {
        }

        @Override
        public TxMgrAdapter init() {
            return sUnitTestTxMgr != null ? this : null;
        }

        @Override
        public TransactionManager getTransactionManager() {
            return sUnitTestTxMgr;
        }
    }

    private class WL9
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private WL9() {
        }

        @Override
        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("weblogic.transaction.TransactionHelper");
                Method m1 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m1.invoke(null, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                TxMgr.this.logger.debug("get WL9 TransactionManager {} ", this.mTransactionManager);
                return this;
            }
            catch (Exception ex) {
                TxMgr.this.logger.debug("get WAS6a TransactionManager fail." + ex.getMessage());
                return null;
            }
        }

        @Override
        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class WAS6a
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private WAS6a() {
        }

        @Override
        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
                Method m1 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m1.invoke(null, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                TxMgr.this.logger.debug("get WAS6a TransactionManager {} ", this.mTransactionManager);
                return this;
            }
            catch (Exception ex) {
                TxMgr.this.logger.debug("get WAS6a TransactionManager fail." + ex.getMessage());
                return null;
            }
        }

        @Override
        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class TongWeb
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private TongWeb() {
        }

        @Override
        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("com.tongweb.Switch");
                Method m1 = c1.getMethod("getSwitch", new Class[0]);
                Object theswitch = m1.invoke(null, new Object[0]);
                Method m2 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m2.invoke(theswitch, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                TxMgr.this.logger.debug("get TongWeb TransactionManager {} ", this.mTransactionManager);
                return this;
            }
            catch (Exception ignore) {
                TxMgr.this.logger.debug("get TongWeb TransactionManager fail." + ignore.getMessage());
                return null;
            }
        }

        @Override
        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class SJSAS
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private SJSAS() {
        }

        @Override
        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("com.sun.enterprise.Switch");
                Method m1 = c1.getMethod("getSwitch", new Class[0]);
                Object theswitch = m1.invoke(null, new Object[0]);
                Method m2 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m2.invoke(theswitch, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                TxMgr.this.logger.debug("get SJSAS TransactionManager {} ", this.mTransactionManager);
                return this;
            }
            catch (Exception ignore) {
                TxMgr.this.logger.debug("get SJSAS TransactionManager fail." + ignore.getMessage());
                return null;
            }
        }

        @Override
        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private abstract class TxMgrAdapter {
        private TxMgrAdapter() {
        }

        public abstract TxMgrAdapter init();

        public abstract TransactionManager getTransactionManager() throws Exception;

        public Transaction getTransaction() throws Exception {
            return this.getTransactionManager().getTransaction();
        }

        public final void register(Synchronization sync) throws Exception {
            this.getTransaction().registerSynchronization(sync);
        }

        public final boolean isInTransaction() throws Exception {
            return this.getTransaction() != null;
        }
    }
}

