/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JConnection;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class WConnection
implements Connection {
    private static final Localizer LOCALE = Localizer.get();
    protected JConnection mMgr;

    public WConnection(JConnection mgr) {
        this.mMgr = mgr;
    }

    public void invokeOnClosed() throws IllegalStateException {
        throw Exc.illstate(LOCALE.x("E153: This {0} is closed", "connection"));
    }

    public void setClosed() {
        this.mMgr = null;
    }

    public JConnection getJConnection() {
        return this.mMgr;
    }

    public Session createSession(boolean boolean0, int int1) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        return this.mMgr.createSession(boolean0, int1);
    }

    public String getClientID() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        return this.mMgr.getClientID();
    }

    public void setClientID(String string) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        this.mMgr.setClientID(string);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        return this.mMgr.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        return this.mMgr.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        this.mMgr.setExceptionListener(exceptionListener);
    }

    public void start() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        this.mMgr.start();
    }

    public void stop() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        this.mMgr.stop();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int int3) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        return this.mMgr.createConnectionConsumer(destination, string, serverSessionPool, int3);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int int4) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        return this.createDurableConnectionConsumer(topic, string, string2, serverSessionPool, int4);
    }

    public void close() throws JMSException {
        if (this.mMgr != null) {
            this.mMgr.close();
        }
    }
}

