/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JConsumer;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class WMessageConsumer
implements MessageConsumer {
    private static final Localizer LOCALE = Localizer.get();
    protected JConsumer mMgr;
    private MessageConsumer mDelegate;

    public WMessageConsumer(JConsumer mgr, MessageConsumer mc) {
        this.mMgr = mgr;
        this.mDelegate = mc;
    }

    public void invokeOnClosed() throws IllegalStateException {
        throw Exc.illstate(LOCALE.x("E153: This {0} is closed", "MessageConsumer"));
    }

    public void setClosed() {
        this.mMgr = null;
        this.mDelegate = null;
    }

    public String getMessageSelector() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getMessageSelector();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getMessageListener();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            this.mDelegate.setMessageListener(listener);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Message receive() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mMgr.onReceived(this.mDelegate.receive());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Message receive(long timeout) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mMgr.onReceived(this.mDelegate.receive(timeout));
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Message receiveNoWait() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mMgr.onReceived(this.mDelegate.receiveNoWait());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void close() throws JMSException {
        if (this.mMgr != null) {
            this.mMgr.close();
            this.mMgr = null;
            this.mDelegate = null;
        }
    }
}

