/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AckHandler;
import com.tongtech.jms.ra.core.Activation;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class WMessageIn
implements Message,
Unwrappable {
    private Message mDelegate;
    private boolean mBatchAndHua;
    private AckHandler mAckHandler;
    private int mIBatch;
    private int mBatchSize;
    private boolean mIsRollbackOnly;
    private boolean mIsAckCalled;
    private RedeliveryStateHandler mRedeliveryStateHandler;
    private Activation mActivation;
    private static final Localizer LOCALE = Localizer.get();
    public static final String LEGACY_ISROLLBACKONLY = "JMSJCA.isRollbackOnly";
    public static final String SETROLLBACKONLY = "JMSJCA.setRollbackOnly";
    public static final String IBATCH = "JMSJCA.batchIndex";
    public static final String BATCHSIZE = "JMSJCA.batchSize";

    public WMessageIn(Message delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public Object getWrappedObject() {
        return this.mDelegate;
    }

    public Message getDelegate() {
        return this.mDelegate;
    }

    public void setJMSReplyTo(Destination dest) throws JMSException {
        if (dest instanceof Unwrappable) {
            dest = (Destination)((Unwrappable)dest).getWrappedObject();
        }
        this.mDelegate.setJMSReplyTo(dest);
    }

    public void acknowledge() throws JMSException {
        if (!this.mBatchAndHua) {
            this.mDelegate.acknowledge();
        } else if (this.mAckHandler != null) {
            if (!this.mIsAckCalled) {
                this.mAckHandler.ack(this.mIsRollbackOnly, this);
                this.mIsAckCalled = true;
            }
        } else {
            this.mDelegate.acknowledge();
        }
    }

    public void clearBody() throws JMSException {
        this.mDelegate.clearBody();
    }

    public void clearProperties() throws JMSException {
        this.mDelegate.clearProperties();
    }

    public boolean getBooleanProperty(String arg0) throws JMSException {
        return this.mDelegate.getBooleanProperty(arg0);
    }

    public byte getByteProperty(String arg0) throws JMSException {
        return this.mDelegate.getByteProperty(arg0);
    }

    public double getDoubleProperty(String arg0) throws JMSException {
        return this.mDelegate.getDoubleProperty(arg0);
    }

    public float getFloatProperty(String arg0) throws JMSException {
        return this.mDelegate.getFloatProperty(arg0);
    }

    public int getIntProperty(String arg0) throws JMSException {
        return this.mDelegate.getIntProperty(arg0);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.mDelegate.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.mDelegate.getJMSCorrelationIDAsBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.mDelegate.getJMSDeliveryMode();
    }

    public Destination getJMSDestination() throws JMSException {
        return this.mDelegate.getJMSDestination();
    }

    public long getJMSExpiration() throws JMSException {
        return this.mDelegate.getJMSExpiration();
    }

    public String getJMSMessageID() throws JMSException {
        return this.mDelegate.getJMSMessageID();
    }

    public int getJMSPriority() throws JMSException {
        return this.mDelegate.getJMSPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.mDelegate.getJMSRedelivered();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.mDelegate.getJMSReplyTo();
    }

    public long getJMSTimestamp() throws JMSException {
        return this.mDelegate.getJMSTimestamp();
    }

    public String getJMSType() throws JMSException {
        return this.mDelegate.getJMSType();
    }

    public long getLongProperty(String arg0) throws JMSException {
        return this.mDelegate.getLongProperty(arg0);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (this.mBatchAndHua && IBATCH.equalsIgnoreCase(name)) {
            return new Integer(this.mIBatch);
        }
        if (this.mBatchAndHua && BATCHSIZE.equalsIgnoreCase(name)) {
            return new Integer(this.mBatchSize);
        }
        if (this.mRedeliveryStateHandler != null && "JMS_Sun_JMSJCA_RedeliveryCount".equalsIgnoreCase(name)) {
            return new Integer(this.mRedeliveryStateHandler.getRedeliveryCount());
        }
        if ("JMS_Sun_JMSJCA_MBeanServer".equals(name)) {
            return this.mActivation.getRA().getMBeanServer();
        }
        return this.mDelegate.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.mDelegate.getPropertyNames();
    }

    public short getShortProperty(String arg0) throws JMSException {
        return this.mDelegate.getShortProperty(arg0);
    }

    public String getStringProperty(String name) throws JMSException {
        String ret = null;
        if (this.mRedeliveryStateHandler != null) {
            ret = this.mRedeliveryStateHandler.getProperty(name);
        }
        if (ret == null && "JMS_Sun_JMSJCA_MBeanName".equals(name)) {
            ret = this.mActivation.getActivationSpec().getMBeanName();
        }
        if (ret == null) {
            ret = this.mDelegate.getStringProperty(name);
        }
        return ret;
    }

    public boolean propertyExists(String arg0) throws JMSException {
        return this.mDelegate.propertyExists(arg0);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.mBatchAndHua && (LEGACY_ISROLLBACKONLY.equalsIgnoreCase(name) || SETROLLBACKONLY.equalsIgnoreCase(name))) {
            if (!value) {
                throw Exc.jmsExc(LOCALE.x("E155: Illegal value: value must be true"));
            }
            if (this.mIsAckCalled) {
                throw Exc.jmsExc(LOCALE.x("E156: Cannot set isRollbackOnly after acknowledge() has been called"));
            }
            this.mIsRollbackOnly = true;
        } else {
            this.mDelegate.setBooleanProperty(name, value);
        }
    }

    public void setByteProperty(String arg0, byte arg1) throws JMSException {
        this.mDelegate.setByteProperty(arg0, arg1);
    }

    public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        this.mDelegate.setDoubleProperty(arg0, arg1);
    }

    public void setFloatProperty(String arg0, float arg1) throws JMSException {
        this.mDelegate.setFloatProperty(arg0, arg1);
    }

    public void setIntProperty(String arg0, int arg1) throws JMSException {
        this.mDelegate.setIntProperty(arg0, arg1);
    }

    public void setJMSCorrelationID(String arg0) throws JMSException {
        this.mDelegate.setJMSCorrelationID(arg0);
    }

    public void setJMSCorrelationIDAsBytes(byte[] arg0) throws JMSException {
        this.mDelegate.setJMSCorrelationIDAsBytes(arg0);
    }

    public void setJMSDeliveryMode(int arg0) throws JMSException {
        this.mDelegate.setJMSDeliveryMode(arg0);
    }

    public void setJMSDestination(Destination arg0) throws JMSException {
        this.mDelegate.setJMSDestination(arg0);
    }

    public void setJMSExpiration(long arg0) throws JMSException {
        this.mDelegate.setJMSExpiration(arg0);
    }

    public void setJMSMessageID(String arg0) throws JMSException {
        this.mDelegate.setJMSMessageID(arg0);
    }

    public void setJMSPriority(int arg0) throws JMSException {
        this.mDelegate.setJMSPriority(arg0);
    }

    public void setJMSRedelivered(boolean arg0) throws JMSException {
        this.mDelegate.setJMSRedelivered(arg0);
    }

    public void setJMSTimestamp(long arg0) throws JMSException {
        this.mDelegate.setJMSTimestamp(arg0);
    }

    public void setJMSType(String arg0) throws JMSException {
        this.mDelegate.setJMSType(arg0);
    }

    public void setLongProperty(String arg0, long arg1) throws JMSException {
        this.mDelegate.setLongProperty(arg0, arg1);
    }

    public void setObjectProperty(String arg0, Object arg1) throws JMSException {
        this.mDelegate.setObjectProperty(arg0, arg1);
    }

    public void setShortProperty(String arg0, short arg1) throws JMSException {
        this.mDelegate.setShortProperty(arg0, arg1);
    }

    public void setStringProperty(String arg0, String arg1) throws JMSException {
        if (this.mRedeliveryStateHandler == null || !this.mRedeliveryStateHandler.setProperty(arg0, arg1)) {
            this.mDelegate.setStringProperty(arg0, arg1);
        }
    }

    public WMessageIn setBatchSize(int batchSize, AckHandler ackHandler, int iBatch) {
        this.mBatchAndHua = true;
        this.mBatchSize = batchSize;
        this.mAckHandler = ackHandler;
        this.mIBatch = iBatch;
        return this;
    }

    public void setRedeliveryState(RedeliveryStateHandler redeliveryState) {
        this.mRedeliveryStateHandler = redeliveryState;
    }

    public void setActivation(Activation a) {
        this.mActivation = a;
    }

    public static interface RedeliveryStateHandler {
        public boolean setProperty(String var1, String var2) throws JMSException;

        public String getProperty(String var1) throws JMSException;

        public int getRedeliveryCount();
    }
}

