/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.AdminQueue;
import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.core.WSession;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class WQueueSession
extends WSession
implements QueueSession {
    protected static Logger logger = LoggerFactory.getLogger(WQueueSession.class);

    public WQueueSession(JSession mgr) {
        super(mgr);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership((Destination)queue);
        queue = (Queue)this.mMgr.checkGeneric((Destination)queue);
        if (queue instanceof AdminQueue) {
            queue = (Queue)this.mMgr.createDestination((AdminDestination)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        try {
            return this.mMgr.createReceiver(queue, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership((Destination)queue);
        queue = (Queue)this.mMgr.checkGeneric((Destination)queue);
        if (queue instanceof AdminQueue) {
            queue = (Queue)this.mMgr.createDestination((AdminDestination)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        try {
            return this.mMgr.createReceiver(queue, string, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        queue = (Queue)this.mMgr.checkGeneric((Destination)queue);
        if (queue instanceof AdminQueue) {
            queue = (Queue)this.mMgr.createDestination((AdminDestination)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        try {
            return this.mMgr.createSender(queue, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }
}

