/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.core.XXid;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;

public class XLocalTransactionXA
implements LocalTransaction {
    private static Logger sLog = Logger.getLogger(XLocalTransactionXA.class);
    private XManagedConnection mManagedConnection;
    private XXid mXid;
    private static final Localizer LOCALE = Localizer.get();

    public XLocalTransactionXA(XManagedConnection managedConnection) {
        this.mManagedConnection = managedConnection;
    }

    public void begin() throws ResourceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("begin() called");
        }
        this.mXid = new XXid();
        try {
            this.mManagedConnection.getXAResource().start(this.mXid, 0);
        }
        catch (Exception ex) {
            throw Exc.rsrcExc(LOCALE.x("E079: XAResource failed on start(): {0}", ex), ex);
        }
    }

    public void commit() throws ResourceException {
        if (this.mXid == null) {
            throw Exc.rsrcExc(LOCALE.x("E080: Cannot call commit() before calling begin()"));
        }
        try {
            this.mManagedConnection.getXAResource().end(this.mXid, 0x4000000);
            this.mManagedConnection.getXAResource().commit(this.mXid, true);
        }
        catch (Exception ex) {
            throw Exc.rsrcExc(LOCALE.x("E083: XAResource failed on commit(): {0}", ex), ex);
        }
    }

    public void rollback() throws ResourceException {
        if (this.mXid == null) {
            throw Exc.rsrcExc(LOCALE.x("E082: Cannot call rollback() before calling begin()"));
        }
        try {
            this.mManagedConnection.getXAResource().end(this.mXid, 0x4000000);
            this.mManagedConnection.getXAResource().rollback(this.mXid);
        }
        catch (Exception ex) {
            throw Exc.rsrcExc(LOCALE.x("E083: XAResource failed on commit(): {0}", ex), ex);
        }
    }
}

