/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.PseudoXAResource;
import com.tongtech.jms.ra.core.PseudoXAResourceNOP;
import com.tongtech.jms.ra.core.WSession;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XLocalTransaction;
import com.tongtech.jms.ra.core.XLocalTransactionNOP;
import com.tongtech.jms.ra.core.XLocalTransactionXA;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.core.XManagedConnectionMetaData;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class XManagedConnection
implements ManagedConnection {
    private static Logger sLog = Logger.getLogger(XManagedConnection.class);
    private List mConnectionEventListeners;
    private List mHandles = new ArrayList();
    private transient PrintWriter mLogWriter;
    private XConnectionRequestInfo mConnectionDescription;
    private XManagedConnectionFactory mManagedConnectionFactory;
    private JSession mJSession;
    private XAResource mXAResource;
    private LocalTransaction mLocalTransaction;
    private XManagedConnectionMetaData mMetaData;
    private transient long mCreatedAt = System.currentTimeMillis();
    private String mUserid;
    private String mPassword;
    private long mLastUsedSuccessfullyAt;
    private static final Localizer LOCALE = Localizer.get();

    public XManagedConnection(XManagedConnectionFactory mcf, Subject subject, XConnectionRequestInfo descr) throws ResourceException {
        boolean xa;
        this.mManagedConnectionFactory = mcf;
        if (sLog.isDebugEnabled()) {
            sLog.debug("if descr is null, transacted alwary true, descr: " + descr);
        }
        if (descr == null) {
            descr = new XConnectionRequestInfo(QueueConnection.class, QueueSession.class, null, null, null, null, true, 1);
        }
        this.mConnectionDescription = descr;
        boolean bl = xa = !this.mManagedConnectionFactory.getOptionNoXA();
        if (sLog.isDebugEnabled()) {
            sLog.debug("IS TRUE XA: " + xa);
        }
        String[] uidpw = mcf.getEffectiveUseridAndPassword(descr, subject);
        this.mUserid = uidpw[0];
        this.mPassword = uidpw[1];
        try {
            this.mJSession = new JSession(xa, descr.getTransacted(), descr.getAcknowledgeMode(), descr.getSessionClass(), this);
        }
        catch (JMSException ex) {
            throw Exc.rsrcExc(LOCALE.x("E084: Failed to create session: {0}", (Object)ex), (Exception)((Object)ex));
        }
        if (xa) {
            try {
                this.mXAResource = this.mJSession.getXAResource();
            }
            catch (JMSException ex) {
                if (this.mJSession != null) {
                    try {
                        this.mJSession.destroy();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                throw Exc.rsrcExc(LOCALE.x("E085: Could not obtain XAResource: {0}", (Object)ex), (Exception)((Object)ex));
            }
        }
        if (descr.getTransacted()) {
            try {
                this.mXAResource = new PseudoXAResource((Session)this.mJSession.getDelegate());
            }
            catch (JMSException e) {
                throw Exc.rsrcExc(LOCALE.x("E086: Could not create pseudo XAResource: {0}", (Object)e), (Exception)((Object)e));
            }
        } else {
            this.mXAResource = new PseudoXAResourceNOP();
        }
        this.mLocalTransaction = xa ? new XLocalTransactionXA(this) : (descr.getTransacted() ? new XLocalTransaction(this) : new XLocalTransactionNOP());
        this.mLastUsedSuccessfullyAt = System.currentTimeMillis();
    }

    public void cleanup() throws ResourceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Cleaning up connection");
        }
        if (this.mJSession != null) {
            this.mJSession.cleanup();
        }
        for (int i = 0; i < this.mHandles.size(); ++i) {
            WSession w = (WSession)this.mHandles.get(i);
            w.setClosed();
        }
        this.mHandles.clear();
        this.mMetaData = null;
        this.getManagedConnectionFactory().getObjFactory().cleanup(this);
    }

    public boolean isInvalid() {
        if (this.mManagedConnectionFactory.isTestModeInvalidConnections()) {
            return true;
        }
        if (this.getManagedConnectionFactory().getObjFactory().isInvalid(this)) {
            return true;
        }
        if (this.mJSession != null && this.mJSession.hasExceptionOccurred()) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("isInvalid=false: one or more exceptions occurred during the use of this connection, and hence should not be reused. There were " + this.mJSession.getExceptionCount() + " exceptions " + " in total. The first exception was: " + this.mJSession.getFirstException(), this.mJSession.getFirstException());
            }
            return true;
        }
        if (this.mJSession != null && System.currentTimeMillis() - this.getLastSuccessfullyUsedAt() > this.mManagedConnectionFactory.internalGetIdleTimeout()) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Stale connection: will be destroyed. Age: " + (System.currentTimeMillis() - this.getLastSuccessfullyUsedAt()));
            }
            return true;
        }
        return false;
    }

    public void onSuccessfulOperation() {
        this.mLastUsedSuccessfullyAt = System.currentTimeMillis();
    }

    public long getLastSuccessfullyUsedAt() {
        return this.mLastUsedSuccessfullyAt;
    }

    public void destroy() throws ResourceException {
        if (this.mJSession != null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Destroying connection");
            }
            try {
                this.mJSession.destroy();
            }
            catch (JMSException ex) {
                throw Exc.rsrcExc(LOCALE.x("E087: Error while closing session: {0}", (Object)ex), (Exception)((Object)ex));
            }
            this.mJSession = null;
        }
        this.mManagedConnectionFactory.notifyMCDestroyed(this);
    }

    public XAResource getXAResource() throws ResourceException {
        return this.mXAResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.mLocalTransaction;
    }

    public ManagedConnectionMetaData getMetaData() {
        if (this.mMetaData == null) {
            this.mMetaData = new XManagedConnectionMetaData(this);
        }
        return this.mMetaData;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.getManagedConnectionFactory().getObjFactory().isInvalid(this)) {
            throw Exc.rsrcExc(LOCALE.x("E194: Invalid Connection "));
        }
        PasswordCredential pc = this.mManagedConnectionFactory.getPasswordCredential(subject);
        if (!(pc == null || Str.isEqual(pc.getUserName(), this.getUserid()) && Str.isEqual(new String(pc.getPassword()), this.getPassword()))) {
            throw new SecurityException(LOCALE.x("E164: Invalid subject {0}", subject).toString());
        }
        WSession h = this.mJSession.createHandle();
        this.mHandles.add(h);
        return h;
    }

    public void associateConnection(Object handle) throws ResourceException {
        WSession w = (WSession)handle;
        w.getJSession().getManagedConnection().disassociateConnection(w);
        w.setJSession(this.mJSession);
        this.mHandles.add(w);
        if (sLog.isDebugEnabled()) {
            sLog.debug("Associating connection with " + handle);
        }
    }

    public void disassociateConnection(WSession w) throws ResourceException {
        if (!this.mHandles.remove(w)) {
            throw Exc.rsrcExc(LOCALE.x("E165: Handle {0} is not known in this managed connection", w));
        }
    }

    public XConnectionRequestInfo getDescription() {
        return this.mConnectionDescription;
    }

    public void notifyClosedByApplicationConnection(WSession s) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Application is closing the connection handle");
        }
        this.mHandles.remove(s);
        ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this, 1);
        ev.setConnectionHandle((Object)s);
        this.distributeEvent(ev);
    }

    public void notifyCommit(WSession s) {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Application is has invoked commit");
        }
        ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this, 3);
        ev.setConnectionHandle((Object)s);
        this.distributeEvent(ev);
    }

    public void notifyRollback(WSession s) {
        ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this, 4);
        ev.setConnectionHandle((Object)s);
        this.distributeEvent(ev);
    }

    public void notifyConnectionErrorOccured(Exception ex) {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Error occured in the connection", ex);
        }
    }

    public XManagedConnectionFactory getManagedConnectionFactory() {
        return this.mManagedConnectionFactory;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.mConnectionEventListeners == null) {
            this.mConnectionEventListeners = new ArrayList();
        }
        this.mConnectionEventListeners.add(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        Iterator it = this.mConnectionEventListeners.iterator();
        while (it.hasNext()) {
            ConnectionEventListener o = (ConnectionEventListener)it.next();
            if (connectionEventListener != o) continue;
            it.remove();
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.mLogWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.mLogWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeEvent(ConnectionEvent event) {
        ConnectionEventListener[] listeners;
        int type = event.getId();
        if (sLog.isDebugEnabled()) {
            sLog.debug("Sending connection event: " + type);
        }
        XManagedConnection xManagedConnection = this;
        synchronized (xManagedConnection) {
            listeners = this.mConnectionEventListeners.toArray(new ConnectionEventListener[0]);
        }
        block10: for (int i = 0; i < listeners.length; ++i) {
            switch (type) {
                case 1: {
                    listeners[i].connectionClosed(event);
                    continue block10;
                }
                case 2: {
                    listeners[i].localTransactionStarted(event);
                    continue block10;
                }
                case 3: {
                    listeners[i].localTransactionCommitted(event);
                    continue block10;
                }
                case 4: {
                    listeners[i].localTransactionRolledback(event);
                    continue block10;
                }
                case 5: {
                    listeners[i].connectionErrorOccurred(event);
                    continue block10;
                }
                default: {
                    throw Exc.illarg(LOCALE.x("E167: Illegal eventType: {0}", Integer.toString(type)));
                }
            }
        }
    }

    public boolean useProducerPooling() {
        return this.mManagedConnectionFactory.isProducerPoolingOn();
    }

    public JSession getJSession() {
        if (this.mJSession == null) {
            throw Exc.rtexc(LOCALE.x("E166: Cannot obtain JSession: mSession is null"));
        }
        return this.mJSession;
    }

    public String dumpMCInfo() {
        StringBuffer ret = new StringBuffer();
        ret.append("Class: " + this.getClass() + ";\n");
        ret.append("Lifetime: " + (System.currentTimeMillis() - this.mCreatedAt) + " ms;\n");
        if (this.mJSession != null) {
            ret.append("Exception count: " + this.mJSession.getExceptionCount() + "\n");
        }
        ret.append("Last successfully used at: " + this.mLastUsedSuccessfullyAt + " (" + (System.currentTimeMillis() - this.mLastUsedSuccessfullyAt) + " ms ago)");
        return ret.toString();
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getUserid() {
        return this.mUserid;
    }
}

