/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.transaction.xa.Xid;

public final class XXid
implements Xid,
Serializable {
    static byte[] ipAddress;
    static long counter;
    static ServerSocket sock;
    private int formatId = 987654;
    private byte[] branchQualifier = new byte[8 + ipAddress.length];
    private byte[] globalTransactionId;

    static synchronized long incrCounter() {
        return ++counter;
    }

    public XXid() {
        int i;
        for (i = 0; i < ipAddress.length; ++i) {
            this.branchQualifier[i] = ipAddress[i];
        }
        long count = XXid.incrCounter();
        long uid = (System.currentTimeMillis() << 12) + (count & 0xFFFL);
        int j = 0;
        while (j < 8) {
            this.branchQualifier[i] = (byte)uid;
            uid >>= 8;
            ++j;
            ++i;
        }
        this.globalTransactionId = this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public static String toHex(byte[] arr) {
        StringBuffer ret = new StringBuffer(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            ret.append(XXid.hexChar(arr[i]));
        }
        return ret.toString();
    }

    public void setGlobalTransactionId(byte[] value) {
        this.globalTransactionId = value;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public void setBranchQualifier(byte[] value) {
        this.branchQualifier = value;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public void setFormatId(int value) {
        this.formatId = value;
    }

    public int hashCode() {
        int i;
        int result = 0;
        for (i = 0; i < this.branchQualifier.length; ++i) {
            result += (result << 3) + this.branchQualifier[i];
        }
        for (i = 0; i < this.globalTransactionId.length; ++i) {
            result += (result << 3) + this.globalTransactionId[i];
        }
        return result;
    }

    public boolean equals(Object that) {
        int i;
        if (this == that) {
            return true;
        }
        if (!(that instanceof XXid)) {
            return false;
        }
        XXid thatXid = (XXid)that;
        for (i = 0; i < this.branchQualifier.length; ++i) {
            if (this.branchQualifier[i] == thatXid.branchQualifier[i]) continue;
            return false;
        }
        for (i = 0; i < this.globalTransactionId.length; ++i) {
            if (this.globalTransactionId[i] == thatXid.globalTransactionId[i]) continue;
            return false;
        }
        return true;
    }

    static final char hexChar(int c) {
        String hex = "0123456789ABCDEF";
        return "0123456789ABCDEF".charAt(c & 0xF);
    }

    public String toString() {
        byte b;
        int i;
        StringBuffer result = new StringBuffer();
        result.append("xid:");
        result.append(this.formatId);
        result.append(":");
        for (i = 0; i < this.globalTransactionId.length; ++i) {
            b = this.globalTransactionId[i];
            result.append(XXid.hexChar(b >> 4));
            result.append(XXid.hexChar(b));
        }
        result.append(":");
        for (i = 0; i < this.branchQualifier.length; ++i) {
            b = this.branchQualifier[i];
            result.append(XXid.hexChar(b >> 4));
            result.append(XXid.hexChar(b));
        }
        return result.toString();
    }

    static {
        counter = 0L;
        try {
            byte[] hostAddress = InetAddress.getLocalHost().getAddress();
            ipAddress = new byte[hostAddress.length + 2];
            System.arraycopy(hostAddress, 0, ipAddress, 0, hostAddress.length);
            sock = new ServerSocket(0);
            int port = sock.getLocalPort();
            XXid.ipAddress[XXid.ipAddress.length - 2] = (byte)(port >> 8 & 0xF);
            XXid.ipAddress[XXid.ipAddress.length - 1] = (byte)(port & 0xF);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

