/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.jndi;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.SessionConnection;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.jndi.JNDISessionConnection;
import com.tongtech.jms.ra.jndi.Localizer;
import com.tongtech.jms.ra.jndi.RAJNDIResourceAdapter;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.InitialContext;
import javax.naming.RefAddr;
import javax.naming.Reference;

public class RAJNDIObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger(RAJNDIObjectFactory.class);
    public static final String JNDI_PREFIX = "jndi://";
    private static final String[] URL_PREFIXES = new String[]{"jndi://"};
    private static final Localizer LOCALE = Localizer.get();

    private void safeClose(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Object getJndiObject(Properties p, String name) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Looking up JNDI object " + name);
        }
        if (name == null || name.length() == 0) {
            throw Exc.jmsExc(LOCALE.x("E401: The JNDI name is null"));
        }
        InitialContext ctx = null;
        try {
            ctx = p.get("java.naming.factory.initial") == null ? new InitialContext() : new InitialContext(p);
            Object ret = ctx.lookup(name);
            if (sLog.isDebugEnabled()) {
                sLog.debug("Found object [" + ret + "], class=" + (ret == null ? null : ret.getClass()));
            }
            if (ret instanceof Reference && sLog.isDebugEnabled()) {
                Reference ref = (Reference)ret;
                sLog.debug("Reference properties: classname=" + ref.getClassName() + ", factoryclassname" + ref.getFactoryClassName() + ", FactoryClassLocation" + ref.getFactoryClassLocation());
                int i = 0;
                Enumeration<RefAddr> iter = ((Reference)ret).getAll();
                while (iter.hasMoreElements()) {
                    RefAddr element = iter.nextElement();
                    sLog.debug("RefAddr #" + i++ + ": tostring=[" + element + "]\r\ncontent=[" + element.getContent() + "]\r\ntype=[" + element.getType() + "]\r\nclass=" + element.getClass());
                }
            }
            Object object = ret;
            this.safeClose(ctx);
            return object;
        }
        catch (Exception e) {
            try {
                throw Exc.jmsExc(LOCALE.x("E400: Could not find JNDI object by name [{0}]: {1}", name, e), e);
            }
            catch (Throwable throwable) {
                this.safeClose(ctx);
                throw throwable;
            }
        }
    }

    public Object getJndiObject(RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl, String name) throws JMSException {
        Properties p = new Properties();
        this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        return this.getJndiObject(p, name);
    }

    @Override
    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Properties p = new Properties();
        this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        switch (domain) {
            case 1: {
                return (QueueConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.QueueCF"));
            }
            case 3: {
                return (XAQueueConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.QueueCF"));
            }
            case 2: {
                return (TopicConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.TopicCF"));
            }
            case 4: {
                return (XATopicConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.TopicCF"));
            }
            case 5: 
            case 6: {
                return (ConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.UnifiedCF"));
            }
        }
        throw Exc.jmsExc(LOCALE.x("E402: Logic fault: invalid domain {0}", Integer.toString(domain)));
    }

    @Override
    public ConnectionUrl getProperties(Properties p, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec spec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        ConnectionUrl url = super.getProperties(p, resourceAdapter, spec, fact, overrideUrl);
        if (resourceAdapter instanceof RAJNDIResourceAdapter) {
            RAJNDIResourceAdapter ra = (RAJNDIResourceAdapter)resourceAdapter;
            if (ra.getQueueConnectionFactoryJndiName() != null) {
                p.setProperty("JMSJCA.QueueCF", ra.getQueueConnectionFactoryJndiName());
            }
            if (ra.getTopicConnectionFactoryJndiName() != null) {
                p.setProperty("JMSJCA.TopicCF", ra.getTopicConnectionFactoryJndiName());
            }
            if (ra.getUnifiedConnectionFactoryJndiName() != null) {
                p.setProperty("JMSJCA.UnifiedCF", ra.getUnifiedConnectionFactoryJndiName());
            }
            if (ra.getInitialContextFactory() != null) {
                p.setProperty("java.naming.factory.initial", ra.getInitialContextFactory());
            }
            if (ra.getProviderUrl() != null) {
                p.setProperty("java.naming.provider.url", ra.getProviderUrl());
            }
        }
        return url;
    }

    @Override
    public SessionConnection createSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        return new JNDISessionConnection(connectionFactory, objfact, ra, mc, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
    }

    @Override
    public Destination createDestination(Session sess, boolean isXA, boolean isTopic, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, RAJMSResourceAdapter ra, String destName) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("createDestination(" + destName + ")");
        }
        Object ret = this.adminDestinationLookup(destName);
        if ((ret = this.checkGeneric((Destination)ret)) != null && ret instanceof AdminDestination) {
            destName = ((AdminDestination)ret).retrieveCheckedName();
            if (sLog.isDebugEnabled()) {
                sLog.debug(ret + " is an admin object: embedded name: " + destName);
            }
            ret = null;
        }
        if (ret == null && destName.startsWith(JNDI_PREFIX)) {
            String name = destName.substring(JNDI_PREFIX.length());
            if (sLog.isDebugEnabled()) {
                sLog.debug(destName + " is a jndi object: looking up [" + name + "]");
            }
            ret = (Destination)this.getJndiObject(ra, activationSpec, fact, null, name);
        }
        if (ret == null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Creating " + destName + " using createQueue()/createTopic()");
            }
            ret = isXA ? (isTopic ? ((XATopicSession)sess).getTopicSession().createTopic(destName) : ((XAQueueSession)sess).getQueueSession().createQueue(destName)) : (isTopic ? sess.createTopic(destName) : sess.createQueue(destName));
        }
        return ret;
    }

    @Override
    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getJMSServerType() {
        return "GENERIC";
    }
}

