/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.tlqjms;

import com.tongtech.jms.ra.tlqjms.Localizer;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Exc;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;

public class TlqConnectionUrl
extends ConnectionUrl {
    private String mUrl;
    private boolean mParsed;
    private String mProtocol;
    private int mPort;
    private String mHost;
    private String mService;
    private String mPath;
    private String mFile;
    private String mQuery;
    private static final Localizer LOCALE = Localizer.get();

    public TlqConnectionUrl(String url) {
        this.mUrl = url;
    }

    private void parse() {
        if (this.mParsed) {
            return;
        }
        String r = this.mUrl;
        this.mParsed = true;
        int i = r.indexOf("://");
        if (i < 0) {
            throw Exc.rtexc(LOCALE.x("E183: Invalid URL [{0}]: no protocol specified", this.mUrl));
        }
        this.mProtocol = r.substring(0, i);
        if ((i = (r = r.substring(i + "://".length())).indexOf(47)) < 0) {
            i = r.indexOf(63);
        }
        String server = i >= 0 ? r.substring(0, i) : r;
        r = i >= 0 ? r.substring(i) : "";
        i = server.indexOf(58);
        if (i >= 0) {
            this.mHost = server.substring(0, i);
            String port = server.substring(i + 1);
            this.mPort = port.length() > 0 ? Integer.parseInt(port) : -1;
        } else {
            this.mHost = server;
            this.mPort = -1;
        }
        i = r.indexOf(47);
        if (i >= 0) {
            this.mService = r.substring(i + 1);
            r = r.substring(0, i);
        }
        if (r.startsWith("?")) {
            this.mQuery = r.substring(1);
        }
    }

    public void setPort(int port) {
        this.parse();
        this.mPort = port;
        this.mUrl = null;
    }

    public void setHost(String host) {
        this.parse();
        this.mHost = host;
        this.mUrl = null;
    }

    public void setService(String service) {
        this.parse();
        this.mService = service;
        this.mUrl = null;
    }

    @Override
    public String toString() {
        if (this.mUrl == null) {
            StringBuffer url = new StringBuffer();
            url.append(this.mProtocol).append("://").append(this.mHost);
            if (this.mPort != -1) {
                url.append(":").append(this.mPort);
            }
            if (!"".equals(this.mService)) {
                url.append("/").append(this.mService);
            }
            url.append(this.mFile);
            this.mUrl = url.toString();
        }
        return this.mUrl;
    }

    public String getProtocol() {
        this.parse();
        return this.mProtocol;
    }

    public String getHost() {
        this.parse();
        return this.mHost;
    }

    public int getPort() {
        this.parse();
        return this.mPort;
    }

    public String getService() {
        this.parse();
        return this.mService;
    }

    public String getFile() {
        this.parse();
        return this.mFile;
    }

    public String getPath() {
        this.parse();
        return this.mPath;
    }

    public String getQuery() {
        this.parse();
        return this.mQuery;
    }

    @Override
    public void getQueryProperties(Properties toAddTo) {
        if (this.mUrl == null) {
            return;
        }
        String q = this.getQuery();
        TlqConnectionUrl.getQueryProperties(q, toAddTo);
    }

    public static void getQueryProperties(String q, Properties toAddTo) {
        if (q == null || q.length() == 0 || q.indexOf(61) == -1) {
            return;
        }
        StringTokenizer iter = new StringTokenizer(q, "&");
        while (iter.hasMoreElements()) {
            String pair = iter.nextToken();
            int split = pair.indexOf(61);
            if (split <= 0) {
                throw Exc.rtexc(LOCALE.x("E184: Invalid pair [{0}] in query string [{1}]", pair, q));
            }
            String key = pair.substring(0, split);
            String value = pair.substring(split + 1);
            try {
                key = URLDecoder.decode(key, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw Exc.rtexc(LOCALE.x("E185: Invalid encoding in [{0}] in query string [{1}]: {2}", pair, q, e), e);
            }
            toAddTo.setProperty(key, value);
        }
    }
}

