/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.util;

import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class MBeanHelper
implements MBeanRegistration,
DynamicMBean {
    private static Logger sLog = Logger.getLogger(MBeanHelper.class);
    private static String MBM = "mbm";
    private static String MBA = "mba";
    private ArrayList mServers = new ArrayList();
    private ArrayList mNames = new ArrayList();
    private static final Localizer LOCALE = Localizer.get();
    private static final Class[] PRIMITIVECLASSES = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Double.TYPE, Float.TYPE, Short.TYPE, Byte.TYPE, Character.TYPE};
    private static final Map PRIMITIVECLASSMAP = new HashMap();

    public void destroy() {
        for (int i = 0; i < this.mServers.size(); ++i) {
            MBeanServer s = (MBeanServer)this.mServers.get(i);
            try {
                s.unregisterMBean((ObjectName)this.mNames.get(i));
                continue;
            }
            catch (Exception ex) {
                sLog.warn(LOCALE.x("E089: Exception unregistering activation MBean [{0}] on server [{1}]", this.mNames.get(i), this.mServers.get(i)));
            }
        }
        this.mNames.clear();
        this.mServers.clear();
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this.mServers.add(mBeanServer);
        this.mNames.add(objectName);
        return objectName;
    }

    @Override
    public void postRegister(Boolean boolean0) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void setAttribute(Attribute attribute) {
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList ret = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                ret.add(new Attribute(attributeNames[i], this.getAttribute(attributeNames[i])));
                continue;
            }
            catch (Exception ex) {
                sLog.warn(LOCALE.x("E090: Failed to get attribute list: {0}", ex), ex);
            }
        }
        return ret;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.getMBeanInfo(false);
    }

    public MBeanInfo getMBeanInfo(boolean throwFailures) {
        return new MBeanInfo(this.getClass().getName(), this.getMBeanDescription(), this.getAttributeInfo(throwFailures), new MBeanConstructorInfo[0], this.getOperationsInfo(throwFailures), new MBeanNotificationInfo[0]);
    }

    protected MBeanAttributeInfo[] getAttributeInfo(boolean throwFailures) {
        ArrayList<MBeanAttributeInfo> attrinfos = new ArrayList<MBeanAttributeInfo>();
        Object target = this.getDelegate();
        Method[] targetmethods = target.getClass().getMethods();
        Object meta = this.getMetaObject();
        Method[] methods = meta.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().startsWith(MBA) || m.getName().length() <= MBA.length()) continue;
            try {
                String attrname = m.getName().substring(MBA.length());
                Class<?>[] types = m.getParameterTypes();
                Object[] args = new Object[types.length];
                for (int j = 0; j < types.length; ++j) {
                    args[i] = null;
                }
                String descr = (String)m.invoke(meta, args);
                if (descr == null) continue;
                boolean getter = false;
                boolean setter = false;
                Class<?> attrType = null;
                for (int j = 0; j < targetmethods.length; ++j) {
                    Method cand = targetmethods[j];
                    if (cand.getName().equals("get" + attrname)) {
                        attrType = cand.getReturnType();
                        getter = true;
                    }
                    if (cand.getName().equals("set" + attrname) && cand.getParameterTypes().length == 1) {
                        setter = true;
                        if (attrType == null) {
                            attrType = cand.getParameterTypes()[0];
                        }
                    }
                    if (getter && setter) break;
                }
                if (!getter && !setter) break;
                MBeanAttributeInfo info = new MBeanAttributeInfo(attrname, attrType.getName(), descr, getter, setter, false);
                attrinfos.add(info);
                continue;
            }
            catch (Exception e) {
                if (throwFailures) {
                    throw Exc.rtexc(LOCALE.x("E169: getAttributeInfo() failed: {0}", e), e);
                }
                sLog.warn(LOCALE.x("E091: Failure while building attribute descriptions for {0}: {1}", this.getClass().getName(), e));
            }
        }
        MBeanAttributeInfo[] attrs = attrinfos.toArray(new MBeanAttributeInfo[attrinfos.size()]);
        return attrs;
    }

    protected MBeanOperationInfo[] getOperationsInfo(boolean throwFailures) {
        ArrayList<MBeanOperationInfo> opinfos = new ArrayList<MBeanOperationInfo>();
        Object target = this.getDelegate();
        Method[] targetmethods = target.getClass().getMethods();
        Object meta = this.getMetaObject();
        Method[] methods = meta.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().startsWith(MBM) || m.getName().length() <= MBM.length()) continue;
            try {
                String name = m.getName().substring(MBM.length());
                Method targetMethod = null;
                for (int j = 0; j < targetmethods.length; ++j) {
                    Method cand = targetmethods[j];
                    if (!name.equals(cand.getName())) continue;
                    boolean matches = true;
                    if (m.getParameterTypes().length == cand.getParameterTypes().length) {
                        for (int k = 0; k < m.getParameterTypes().length; ++k) {
                            if (m.getParameterTypes()[k].equals(cand.getParameterTypes()[k])) continue;
                            matches = false;
                            break;
                        }
                    }
                    if (!matches) continue;
                    targetMethod = cand;
                    break;
                }
                if (targetMethod == null) {
                    throw Exc.exc(LOCALE.x("E171: Target method not found for {0}", m));
                }
                Class<?>[] types = m.getParameterTypes();
                Object[] args = new Object[types.length];
                for (int j = 0; j < types.length; ++j) {
                    args[j] = this.getReasonableDummyValue(types[j]);
                }
                String[] descr = (String[])m.invoke(meta, args);
                if (descr.length - 1 != types.length) {
                    throw Exc.exc(LOCALE.x("E172: Mismatching number of arguments for {0}", m));
                }
                MBeanParameterInfo[] paraminfos = new MBeanParameterInfo[types.length];
                for (int j = 0; j < paraminfos.length; ++j) {
                    String s = descr[j + 1];
                    int index = s.indexOf(58);
                    String parmname = "";
                    String parmdescr = s;
                    if (index > 0) {
                        parmdescr = s.substring(index + 1);
                        parmname = s.substring(0, index);
                    }
                    paraminfos[j] = new MBeanParameterInfo(parmname, targetMethod.getParameterTypes()[j].getName(), parmdescr);
                }
                opinfos.add(new MBeanOperationInfo(name, descr[0], paraminfos, targetMethod.getReturnType().getName(), 3));
                continue;
            }
            catch (Exception e) {
                if (throwFailures) {
                    throw Exc.rtexc(LOCALE.x("E173: Failure in getOperationsInfo() for method [{0}]: {1}", m, e), e);
                }
                sLog.warn(LOCALE.x("E092: Failure while building method descriptions for {0}: {1}", this.getClass().getName(), e));
            }
        }
        return opinfos.toArray(new MBeanOperationInfo[opinfos.size()]);
    }

    private Object getReasonableDummyValue(Class c) {
        if (c.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (c.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (c.equals(Boolean.TYPE)) {
            return new Boolean(false);
        }
        if (c.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        if (c.equals(Float.TYPE)) {
            return new Float(0.0f);
        }
        if (c.equals(Short.TYPE)) {
            return new Short(0);
        }
        if (c.equals(Byte.TYPE)) {
            return new Byte(0);
        }
        if (c.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        return null;
    }

    public static String concat(Object[] strs, String delim) {
        StringBuffer ret = new StringBuffer();
        if (strs != null) {
            for (int i = 0; i < strs.length; ++i) {
                if (i != 0) {
                    ret.append(delim);
                }
                ret.append(strs[i]);
            }
        }
        return ret.toString();
    }

    private static Method resolveMethod(Class targetClass, String opMethodName, String[] sig) throws ReflectionException {
        Class[] argClasses;
        if (sLog.isDebugEnabled()) {
            sLog.debug("Resolving method " + targetClass + "." + opMethodName + "(" + MBeanHelper.concat(sig, ", ") + ")");
        }
        if (sig == null) {
            argClasses = null;
        } else {
            ClassLoader targetClassLoader = targetClass.getClassLoader();
            argClasses = new Class[sig.length];
            for (int i = 0; i < sig.length; ++i) {
                argClasses[i] = (Class)PRIMITIVECLASSMAP.get(sig[i]);
                if (argClasses[i] != null) continue;
                try {
                    argClasses[i] = Class.forName(sig[i], false, targetClassLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug("Class not found: " + sig[i]);
                    }
                    throw new ReflectionException(e, LOCALE.x("Parameter class not found: [{0}]", sig[i]).toString());
                }
            }
        }
        try {
            return targetClass.getMethod(opMethodName, argClasses);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        Object invAllowed;
        Method invMethod;
        String tracename = opName + "(" + MBeanHelper.concat(opArgs, ", ") + ")";
        if (opName == null) {
            IllegalArgumentException x = Exc.illarg(LOCALE.x("E175: Method name must not be null"));
            throw new RuntimeOperationsException(x, LOCALE.x("E176: An exception occured while trying to invoke MBean method [{0}]: {1}", tracename, x).toString());
        }
        int opSplitter = opName.lastIndexOf(".");
        String opMethodName = opSplitter > 0 ? opName.substring(opSplitter + 1) : opName;
        opSplitter = opMethodName.indexOf("(");
        if (opSplitter > 0) {
            opMethodName = opMethodName.substring(0, opSplitter);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("invoke: searching operation " + opName + " as " + opMethodName + " [" + tracename + "]");
        }
        if ((invMethod = MBeanHelper.resolveMethod(this.getDelegate().getClass(), opMethodName, sig)) == null) {
            throw new MBeanException(Exc.rtexc(LOCALE.x("E174: Method {0} not found on {1}", tracename, this.getDelegate().getClass())));
        }
        Method metaMethod = MBeanHelper.resolveMethod(this.getMetaObject().getClass(), MBM + opMethodName, sig);
        if (metaMethod == null) {
            throw new MBeanException(Exc.rtexc(LOCALE.x("E177: Method {0} not found on {1} (invokation check", tracename, this.getMetaObject().getClass())));
        }
        try {
            invAllowed = metaMethod.invoke(this.getMetaObject(), opArgs);
        }
        catch (Exception e) {
            throw new MBeanException(Exc.rtexc(LOCALE.x("E178: Access check invocation error on method {0} on {1}", tracename, this.getMetaObject().getClass()), e));
        }
        if (invAllowed == null) {
            throw new MBeanException(Exc.rtexc(LOCALE.x("E179: Method {0} may not be invoked on {1}", tracename, this.getMetaObject().getClass())));
        }
        try {
            return invMethod.invoke(this.getDelegate(), opArgs);
        }
        catch (Exception e) {
            throw new MBeanException(Exc.rtexc(LOCALE.x("E180: Invocation error on method {0} on {1}", tracename, this.getDelegate().getClass()), e));
        }
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            Object target = this.getDelegate();
            Method[] targetmethods = target.getClass().getMethods();
            Method m = null;
            for (int i = 0; i < targetmethods.length; ++i) {
                Method cand = targetmethods[i];
                if (!cand.getName().equals("get" + name) || cand.getParameterTypes().length != 0) continue;
                m = cand;
            }
            if (m != null) {
                return m.invoke(target, new Object[0]);
            }
        }
        catch (Exception ex) {
            throw new MBeanException(ex, LOCALE.x("E181: Retrieval of attribute [{0}] failed: {1}", name, ex).toString());
        }
        throw new AttributeNotFoundException(LOCALE.x("E182: Invalid attribute [{0}]", name).toString());
    }

    protected abstract String getMBeanDescription();

    protected abstract Object getMetaObject();

    protected abstract Object getDelegate();

    public void mbeanTest() {
        int i;
        MBeanInfo info = this.getMBeanInfo(true);
        System.out.println(info.getDescription());
        System.out.println("Attributes:");
        MBeanAttributeInfo[] attrs = info.getAttributes();
        for (i = 0; i < attrs.length; ++i) {
            System.out.println("attr " + i + ": " + attrs[i].getType() + " " + attrs[i].getName() + ": " + attrs[i].getDescription());
        }
        System.out.println("Operations:");
        for (i = 0; i < info.getOperations().length; ++i) {
            MBeanOperationInfo o = info.getOperations()[i];
            System.out.println("Operation " + i + ": " + o.getReturnType() + " " + o.getName() + ": " + o.getDescription());
            for (int j = 0; j < o.getSignature().length; ++j) {
                MBeanParameterInfo s = o.getSignature()[j];
                System.out.println("arg " + j + ": " + s.getType() + " " + s.getName() + ": " + s.getDescription());
            }
        }
        System.out.println("End information");
    }

    static {
        for (int i = 0; i < PRIMITIVECLASSES.length; ++i) {
            Class c = PRIMITIVECLASSES[i];
            PRIMITIVECLASSMAP.put(c.getName(), c);
        }
    }
}

