/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.util;

import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import javax.jms.IllegalStateException;

public abstract class NoProxyWrapper {
    private Class mItf;
    private Object mWrapper;
    private int mCtExceptions;
    private Exception mFirstException;
    private String mSignature;
    private static final Localizer LOCALE = Localizer.get();

    protected void init(Class itf, String signature) {
        this.mItf = itf;
        this.mSignature = signature;
        this.createNewWrapper();
    }

    public Class getItfClass() {
        return this.mItf;
    }

    public static boolean isClass(Class a, Class b) {
        return a == b || a.getName().equals(b.getName());
    }

    public boolean isItfClass(Class c) {
        return NoProxyWrapper.isClass(c, this.mItf);
    }

    public String getSignature() {
        return this.mSignature;
    }

    public Object getWrapper() {
        return this.mWrapper;
    }

    public abstract void createNewWrapper();

    public void invokeOnClosed() throws IllegalStateException {
        throw Exc.illstate(LOCALE.x("E153: This {0} is closed", this.getItfClass().getName()));
    }

    public void setWrapper(Object o) {
        this.mWrapper = o;
    }

    public void exceptionOccurred(Throwable ex) {
        if (this.mFirstException == null) {
            if (ex instanceof Exception) {
                this.mFirstException = (Exception)ex;
            } else {
                this.mFirstException = new Exception("Runtime exception: " + ex);
                Exc.setCause(this.mFirstException, ex);
            }
        }
        ++this.mCtExceptions;
    }

    public boolean hasExceptionOccurred() {
        return this.mCtExceptions > 0;
    }

    public Exception getFirstException() {
        return this.mFirstException;
    }

    public int getExceptionCount() {
        return this.mCtExceptions;
    }

    public abstract void physicalClose();
}

