/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel;

import com.tongtech.jms.transport.httptunnel.HttpTunnelPacket;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Link
extends Thread {
    private static boolean DEBUG = true;
    private boolean connected = false;
    protected boolean done = false;
    protected InputStream is = null;
    protected OutputStream os = null;
    static Logger logger = LoggerFactory.getLogger(Link.class);

    protected abstract void createLink();

    protected abstract void receivePacket(HttpTunnelPacket var1);

    protected abstract void handleLinkDown();

    public synchronized void sendPacket(HttpTunnelPacket p) {
        if (DEBUG) {
            logger.debug("Sending packet : " + p);
        }
        try {
            p.writePacket(this.os);
        }
        catch (Exception e) {
            if (DEBUG) {
                logger.debug(e.toString());
            }
            this.linkDown();
        }
    }

    protected void linkDown() {
        try {
            this.is.close();
            this.os.close();
            this.handleLinkDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = false;
    }

    public void shutdown() {
        this.done = true;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                if (!this.connected) {
                    this.createLink();
                    this.connected = true;
                }
                HttpTunnelPacket p = new HttpTunnelPacket();
                p.readPacket(this.is);
                this.receivePacket(p);
            }
            catch (IllegalStateException e) {
                if (DEBUG) {
                    logger.debug(e.toString());
                }
                this.done = true;
            }
            catch (Exception e) {
                if (DEBUG) {
                    logger.debug(e.toString());
                }
                this.linkDown();
            }
        }
    }
}

