/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel.client;

import com.tongtech.jms.transport.httptunnel.HttpTunnelConnection;
import com.tongtech.jms.transport.httptunnel.HttpTunnelDefaults;
import com.tongtech.jms.transport.httptunnel.HttpTunnelDriver;
import com.tongtech.jms.transport.httptunnel.HttpTunnelPacket;
import com.tongtech.jms.transport.httptunnel.client.HttpTunnelPush;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;

public class HttpTunnelClientDriver
extends Thread
implements HttpTunnelDefaults,
HttpTunnelDriver {
    private static boolean DEBUG = true;
    private boolean stopThread = false;
    private String urlString = null;
    private String urlParam = null;
    private URL pushUrl = null;
    private URL pullUrl = null;
    private URLConnection uc = null;
    private HttpTunnelPush pushWorker = null;
    private int connId;
    private HttpTunnelConnection conn = null;
    private long lastConnectTime = 0L;
    static Logger logger = LoggerFactory.getLogger(HttpTunnelClientDriver.class);

    public HttpTunnelClientDriver(String urlString) {
        int index = urlString.lastIndexOf(63);
        if (index >= 0) {
            this.urlString = urlString.substring(0, index);
            this.urlParam = "&" + urlString.substring(index + 1);
        } else {
            this.urlString = urlString;
            this.urlParam = "";
        }
        this.setName("HttpTunnelClientDriver");
        this.setDaemon(true);
        this.pushWorker = new HttpTunnelPush();
    }

    private void handleConnInitAck(HttpTunnelPacket p) {
        if (this.conn != null) {
            return;
        }
        this.conn = new HttpTunnelConnection(this.connId, this);
        this.conn.setLocalPullPeriod(5);
    }

    private void handleConnClose(HttpTunnelPacket p) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleClose(p);
    }

    private void handleConnAbort(HttpTunnelPacket p) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleAbort(p);
    }

    private void handleConnOption(HttpTunnelPacket p) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleConnOption(p);
    }

    private void handlePacket(HttpTunnelPacket p, boolean moreData) {
        if (this.conn == null) {
            return;
        }
        this.conn.receivePacket(p, moreData);
    }

    private void handleDummyPacket(HttpTunnelPacket p) {
        if (DEBUG) {
            logger.debug("#### Received dummy packet :");
            logger.debug(p + "\n");
        }
    }

    public HttpTunnelConnection doConnect() throws IOException {
        URL connUrl = new URL(this.urlString + "?Type=connect" + this.urlParam);
        HttpTunnelPacket p = new HttpTunnelPacket();
        p.setPacketType(1);
        p.setPacketBody(null);
        p.setConnId(0);
        p.setSequence(0);
        p.setWinsize(0);
        p.setChecksum(0);
        try {
            HttpTunnelPacket resp = this.pushWorker.sendPacketDirect(connUrl, p, true);
            this.connId = resp.getConnId();
            String serverName = new String(resp.getPacketBody(), "UTF8");
            String newurlParam = "&" + serverName;
            if (!this.urlParam.equals("") && !newurlParam.equals(this.urlParam)) {
                throw new IOException("Unexpected new ServerName: " + serverName);
            }
            if (this.urlParam.equals("")) {
                this.urlParam = newurlParam;
            }
            this.pushUrl = new URL(this.urlString + "?Type=push" + this.urlParam);
            this.pullUrl = new URL(this.urlString + "?Type=pull&ConnId=" + this.connId + this.urlParam);
            while (this.conn == null) {
                HttpTunnelPacket ack;
                Vector v = this.pullPackets();
                if (v == null || v.size() == 0 || (ack = (HttpTunnelPacket)v.elementAt(0)) == null) continue;
                switch (ack.getPacketType()) {
                    case 7: {
                        throw new IOException("Connection refused");
                    }
                    case 2: {
                        this.handleConnInitAck(ack);
                        break;
                    }
                    case 5: {
                        this.handleConnClose(p);
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "Connection refused : ";
            if (e instanceof EOFException) {
                message = "Connection refused : Make sure that the broker is running and its HTTP service is active...";
            }
            if (e.getMessage() != null) {
                message = message + e.getMessage();
            }
            ConnectException ce = new ConnectException(message);
            try {
                ce.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw ce;
        }
        this.pushWorker.startPushThread(this.pushUrl);
        this.start();
        return this.conn;
    }

    @Override
    public void sendPacket(HttpTunnelPacket p) {
        this.pushWorker.sendPacket(p);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("Sending packet" + p);
        }
    }

    @Override
    public void shutdown(int connId) {
        this.pushWorker.shutdown();
        this.stopThread = true;
        if (this.uc != null && this.uc instanceof HttpURLConnection) {
            try {
                ((HttpURLConnection)this.uc).disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.conn = null;
    }

    /*
     * Unable to fully structure code
     */
    private Vector pullPackets() throws Exception {
        block19: {
            block18: {
                v = null;
                responseCode = 200;
                try {
                    this.uc = this.pullUrl.openConnection();
                    this.uc.setDoInput(true);
                    this.uc.setDoOutput(true);
                    this.uc.setUseCaches(false);
                    os = this.uc.getOutputStream();
                    p = new HttpTunnelPacket();
                    p.writePacket(os);
                    os.close();
                    this.uc.connect();
                    if (this.uc instanceof HttpURLConnection) {
                        responseCode = ((HttpURLConnection)this.uc).getResponseCode();
                    } else {
                        this.uc.getContentType();
                    }
                }
                catch (IOException e) {
                    this.handleHTTPConnectError();
                    throw e;
                }
                if (responseCode == 200) break block18;
                this.handleHTTPConnectError();
                break block19;
            }
            this.lastConnectTime = System.currentTimeMillis();
            v = new Vector<HttpTunnelPacket>();
            is = this.uc.getInputStream();
            while (true) {
                try {
                    while (true) {
                        p = new HttpTunnelPacket();
                        p.readPacket(is);
                        v.addElement(p);
                    }
                }
                catch (Exception e) {
                    block21: {
                        block20: {
                            if (v.size() == 0) {
                                HttpTunnelClientDriver.logger.error("Received packet ,but parse error ");
                            }
                            if (v.size() <= 1) break block20;
                            this.conn.setLocalPullPeriod(5);
                            break block21;
                        }
                        if (v.size() != 1) ** GOTO lbl-1000
                        p = (HttpTunnelPacket)v.elementAt(0);
                        if (p.getPacketType() == 11) {
                            v.removeElement(p);
                            continue;
                        }
                        if (p.getPacketType() != 12) {
                            if (this.conn != null) {
                                this.conn.setLocalPullPeriod(5);
                            }
                        } else if ((pullPeriod = this.conn.getPullPeriod()) > 0) {
                            try {
                                if (pullPeriod >= 5000) {
                                    pullPeriod = 5000;
                                }
                                Thread.sleep(pullPeriod);
                                this.conn.setLocalPullPeriod(pullPeriod <<= 2);
                            }
                            catch (Exception var6_9) {}
                        } else {
                            throw e;
                        }
                    }
                    is.close();
                }
                break;
            }
        }
        this.uc = null;
        return v;
    }

    private void handleHTTPConnectError() {
        if (this.conn.getConnectionTimeout() <= 0) {
            return;
        }
        if (this.lastConnectTime == 0L) {
            return;
        }
        if (System.currentTimeMillis() - this.lastConnectTime > (long)(this.conn.getConnectionTimeout() * 1000)) {
            HttpTunnelPacket p = new HttpTunnelPacket();
            p.setPacketType(9);
            p.setConnId(this.connId);
            p.setSequence(0);
            p.setWinsize(0);
            p.setChecksum(0);
            p.setPacketBody(null);
            this.handleConnAbort(p);
        }
    }

    private void handleHttpPullError() {
    }

    @Override
    public void run() {
        while (!this.stopThread) {
            try {
                HttpTunnelPacket p;
                int j;
                Vector v = this.pullPackets();
                if (v == null || v.size() == 0) {
                    this.handleHttpPullError();
                    continue;
                }
                for (j = v.size() - 1; j >= 0 && (p = (HttpTunnelPacket)v.elementAt(j)).getPacketType() != 4; --j) {
                }
                block13: for (int i = 0; i < v.size(); ++i) {
                    p = (HttpTunnelPacket)v.elementAt(i);
                    if (p.getPacketType() == 7) {
                        // empty if block
                    }
                    if (DEBUG && logger.isDebugEnabled()) {
                        logger.debug("Received packet:" + p);
                    }
                    switch (p.getPacketType()) {
                        case 5: {
                            this.handleConnClose(p);
                            continue block13;
                        }
                        case 9: {
                            this.handleConnAbort(p);
                            continue block13;
                        }
                        case 10: {
                            this.handleConnOption(p);
                            continue block13;
                        }
                        case 4: 
                        case 6: {
                            this.handlePacket(p, i != j);
                            continue block13;
                        }
                        case 100: {
                            this.handleDummyPacket(p);
                            continue block13;
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.handleHttpPullError();
            }
        }
    }

    @Override
    public Hashtable getDebugState() {
        return new Hashtable();
    }
}

