/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel.test;

import java.io.Serializable;
import java.util.Random;

class RandomBytes
implements Serializable {
    private byte[] data = null;
    private int sequence = 0;

    public static byte computeChecksum(byte[] data) {
        int sum = 0;
        for (int i = 0; i < data.length; ++i) {
            if ((sum += data[i] & 0xFF) <= 255) continue;
            sum = (sum & 0xFF) + 1;
        }
        return (byte)(~(sum & 0xFF));
    }

    public RandomBytes(int maxlen) {
        Random r = new Random();
        int len = (int)(r.nextFloat() * (float)maxlen) + 1;
        this.data = new byte[len];
        this.data[0] = 0;
        for (int i = 1; i < len; ++i) {
            this.data[i] = (byte)(32 + (int)(r.nextFloat() * 96.0f));
        }
        this.data[0] = RandomBytes.computeChecksum(this.data);
    }

    public RandomBytes(String str) {
        byte[] in = str.getBytes();
        this.data = new byte[in.length + 1];
        this.data[0] = 0;
        System.arraycopy(in, 0, this.data, 1, in.length);
        this.data[0] = RandomBytes.computeChecksum(this.data);
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public byte getChecksum() {
        return this.data[0];
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isValid() {
        return RandomBytes.computeChecksum(this.data) == 0;
    }

    public static void main(String[] args) {
        int maxlen = 64;
        if (args.length > 0) {
            try {
                maxlen = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                maxlen = -1;
            }
        }
        RandomBytes rb = maxlen < 0 ? new RandomBytes(args[0]) : new RandomBytes(maxlen);
        byte[] tmp = rb.getData();
        int len = tmp.length;
        System.out.println("Bytes = " + new String(tmp, 1, len - 1));
        System.out.println("Length = " + (len - 1));
        System.out.println("Checksum = " + rb.getChecksum());
        System.out.println("Computed checksum = " + RandomBytes.computeChecksum(tmp));
        System.out.println("rb.isValid() = " + rb.isValid());
    }
}

