/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel.test;

import com.tongtech.jms.transport.httptunnel.HttpTunnelSocket;
import com.tongtech.jms.transport.httptunnel.test.RandomBytes;
import java.io.BufferedOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Random;

class Writer
extends Thread {
    private HttpTunnelSocket s = null;
    private OutputStream os = null;
    private static int SLEEP = Integer.getInteger("test.sleep", 0);
    private static int DATASIZE = Integer.getInteger("test.datasize", 32768);
    private static int VERBOSITY = Integer.getInteger("test.verbosity", 0);
    private static int MAX = Integer.getInteger("test.max", -1);
    private static int PULLPERIOD = Integer.getInteger("test.pullperiod", -1);

    public Writer(HttpTunnelSocket s) {
        this.s = s;
        try {
            s.setPullPeriod(PULLPERIOD);
            this.os = s.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(this.os, 8192);
            ObjectOutputStream dos = new ObjectOutputStream(bos);
            Random r = new Random();
            for (int n = 0; MAX < 0 || n < MAX; ++n) {
                RandomBytes rb = new RandomBytes(DATASIZE);
                rb.setSequence(n);
                dos.writeObject(rb);
                dos.flush();
                dos.reset();
                if (SLEEP <= 0) continue;
                Thread.sleep((int)(r.nextFloat() * 1000.0f));
                if (VERBOSITY <= 0) continue;
                System.out.println("#### Sent packet #" + n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("#### Writer exiting...");
    }
}

