/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.util.ByteSequence;
import com.tongtech.protocol.util.DataByteArrayOutputStream;
import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Message;
import com.tongtech.remote.protocol.v3.BaseMessageMarshaller;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jms.JMSException;

public class PartialMessageMarshaller
extends BaseMessageMarshaller {
    static Logger logger = LoggerFactory.getLogger(PartialMessageMarshaller.class);
    DataByteArrayOutputStream bytesOut = new DataByteArrayOutputStream();
    private int partSize = 0;
    private int messageContentPktSize = 0;
    private int msgContentoffset = 0;
    private int messagePropertiesPktSize;
    private int msgPropertiesoffset;
    private int msgSeq = 0;
    private int msgInfoSize = 384;

    protected PartialMessageMarshaller(int partSize, int msgInfoSize) {
        this.partSize = partSize;
        this.msgInfoSize = msgInfoSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWithPartial(Message msg, DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler, boolean needAck, AckQueue tmpQ, Long ackId, MessageProducerImpl producer) throws JMSException {
        try {
            msg.beforeMarshall(format);
            int contentLength = msg.getMsgSize();
            int propertiesLength = msg.getPropSize();
            msg.setCommandId(ackId.intValue());
            msg.setResponseRequired(needAck);
            if (needAck && tmpQ != null) {
                handler.connection.addToAckQTable(ackId, tmpQ);
            }
            this.msgContentoffset = 0;
            this.msgPropertiesoffset = 0;
            this.msgSeq = 0;
            msg.setLast(false);
            while (this.msgContentoffset < contentLength || this.msgContentoffset == 0 && this.msgSeq == 0 || this.msgPropertiesoffset < propertiesLength) {
                int totalLen;
                if (this.partSize == 0) {
                    this.messageContentPktSize = contentLength;
                    this.messagePropertiesPktSize = propertiesLength;
                    ++this.msgSeq;
                } else {
                    try {
                        TlqRemoteProtocolHandler.handleSendError(ackId, handler);
                    }
                    catch (JMSException e) {
                        if (needAck) {
                            throw e;
                        }
                        logger.debug("send message error ", e);
                        return;
                    }
                    msg.setMsgSeq(this.msgSeq++);
                    if (this.msgPropertiesoffset < propertiesLength) {
                        this.messagePropertiesPktSize = propertiesLength - this.msgPropertiesoffset > this.partSize ? this.partSize : propertiesLength - this.msgPropertiesoffset;
                        this.messageContentPktSize = this.partSize - this.messagePropertiesPktSize;
                        if (contentLength < this.messageContentPktSize) {
                            this.messageContentPktSize = contentLength;
                        }
                    } else {
                        this.messagePropertiesPktSize = 0;
                        this.messageContentPktSize = contentLength - this.msgContentoffset > this.partSize ? this.partSize : contentLength - this.msgContentoffset;
                    }
                }
                if (msg.getMsgSeq() == 0 && (totalLen = this.messageContentPktSize + this.messagePropertiesPktSize + this.msgInfoSize) > this.partSize) {
                    int needSpace = totalLen - this.partSize;
                    if (this.messageContentPktSize >= needSpace) {
                        this.messageContentPktSize -= needSpace;
                    } else {
                        this.messagePropertiesPktSize -= needSpace - this.messageContentPktSize;
                        this.messageContentPktSize = 0;
                    }
                }
                if (this.msgContentoffset + this.messageContentPktSize == contentLength && this.msgPropertiesoffset + this.messagePropertiesPktSize == propertiesLength) {
                    msg.setLast(true);
                }
                producer.waitForSpace(msg.getProducerId().getValue());
                MessageProducerImpl.ProducerState ps = (MessageProducerImpl.ProducerState)producer.producerStates.get(new Long(msg.getProducerId().getValue()));
                msg.setSeqId(ps.getProducerWindow().getUsage());
                TlqRemoteProtocolHandler tlqRemoteProtocolHandler = handler;
                synchronized (tlqRemoteProtocolHandler) {
                    this.marshal(msg, os, format);
                    os.flush();
                    handler.setTimeToPing(false);
                }
                producer.increaseUsage(msg.getProducerId().getValue(), this.messageContentPktSize + this.messagePropertiesPktSize);
                msg.afterMarshall(format);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    public synchronized void marshal(Object o, DataOutputStream dataOut, OpenWireFormat wireFormat) throws IOException {
        int size = 1;
        if (o != null) {
            DataStructure c = (DataStructure)o;
            byte type = this.getDataStructureType();
            if (wireFormat.isTightEncodingEnabled()) {
                BooleanStream bs = new BooleanStream();
                size += this.tightMarshal1(wireFormat, c, bs);
                size += bs.marshalledSize();
                if (!wireFormat.isSizePrefixDisabled()) {
                    dataOut.writeShort(size + 3);
                }
                dataOut.writeByte(1);
                dataOut.writeByte(type);
                bs.marshal(dataOut);
                this.tightMarshal2(wireFormat, c, dataOut, bs);
            } else {
                OutputStream looseOut = dataOut;
                if (!wireFormat.isSizePrefixDisabled()) {
                    this.bytesOut.restart();
                    looseOut = this.bytesOut;
                }
                looseOut.writeByte(type);
                this.looseMarshal(wireFormat, c, (DataOutput)((Object)looseOut));
                if (!wireFormat.isSizePrefixDisabled()) {
                    ByteSequence sequence = this.bytesOut.toByteSequence();
                    dataOut.writeInt(sequence.getLength());
                    dataOut.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                }
            }
            this.msgContentoffset += this.messageContentPktSize;
            this.msgPropertiesoffset += this.messagePropertiesPktSize;
            logger.trace("send a message ...{}", c);
        } else {
            if (!wireFormat.isSizePrefixDisabled()) {
                dataOut.writeInt(size);
            }
            dataOut.writeByte(0);
        }
    }

    private int tightMarshal1(OpenWireFormat wireFormat, DataStructure c, BooleanStream bs) throws IOException {
        return !this.isFirstPkt() ? this.BaseMessagetightMarshal1(wireFormat, c, bs) : this.FirstParttightMarshal1(wireFormat, c, bs);
    }

    private void tightMarshal2(OpenWireFormat wireFormat, DataStructure c, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        if (!this.isFirstPkt()) {
            this.BaseMessagetightMarshal2(wireFormat, c, dataOut, bs);
        } else {
            this.FirstParttightMarshal2(wireFormat, c, dataOut, bs);
        }
    }

    private void looseMarshal(OpenWireFormat wireFormat, DataStructure c, DataOutput looseOut) throws IOException {
        if (!this.isFirstPkt()) {
            this.BaseMessagelooseMarshal(wireFormat, c, looseOut);
        } else {
            this.FirstPartlooseMarshal(wireFormat, c, looseOut);
        }
    }

    public int BaseMessagetightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Message info = (Message)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalMessageProperties1(info.getMarshalledProperties(), bs);
        return (rc += this.tightMarshalMessageContent1(info.getContent(), bs)) + 0;
    }

    public void BaseMessagetightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        Message info = (Message)o;
        this.tightMarshalMessageProperties2(info, dataOut, bs);
        this.tightMarshalMessageContent2(info, dataOut, bs);
    }

    public void BaseMessagelooseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        Message info = (Message)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalMessageProperties(wireFormat, info, dataOut);
        this.looseMarshalMessageContent(wireFormat, info, dataOut);
    }

    public int FirstParttightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Message info = (Message)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTransactionId(), bs);
        rc += this.tightMarshalString1(info.getGroupID(), bs);
        rc += this.tightMarshalString1(info.getCorrelationId(), bs);
        bs.writeBoolean(info.isPersistent());
        rc += this.tightMarshalLong1(wireFormat, info.getExpiration(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info.getReplyTo(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getTimestamp(), bs);
        bs.writeBoolean(info.isCompressed());
        rc += this.tightMarshalByteArray1(info.getUsrContext(), bs);
        rc += this.tightMarshalMessageProperties1(info.getMarshalledProperties(), bs);
        return (rc += this.tightMarshalMessageContent1(info.getContent(), bs)) + 25;
    }

    public void FirstParttightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        Message info = (Message)o;
        dataOut.writeInt(info.getMsgSize());
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getMessageType());
        dataOut.writeInt(info.getPropNum());
        this.tightMarshalCachedObject2(wireFormat, info.getTransactionId(), dataOut, bs);
        this.tightMarshalString2(info.getGroupID(), dataOut, bs);
        dataOut.writeInt(info.getGroupSequence());
        this.tightMarshalString2(info.getCorrelationId(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalLong2(wireFormat, info.getExpiration(), dataOut, bs);
        dataOut.writeByte(info.getPriority());
        this.tightMarshalNestedObject2(wireFormat, info.getReplyTo(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getTimestamp(), dataOut, bs);
        bs.readBoolean();
        dataOut.writeInt(info.getRedeliveryCounter());
        this.tightMarshalByteArray2(info.getUsrContext(), dataOut, bs);
        this.tightMarshalMessageProperties2(info, dataOut, bs);
        this.tightMarshalMessageContent2(info, dataOut, bs);
    }

    public void FirstPartlooseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        Message info = (Message)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getMsgSize());
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getMessageType());
        dataOut.writeInt(info.getPropNum());
        this.looseMarshalCachedObject(wireFormat, info.getTransactionId(), dataOut);
        this.looseMarshalString(info.getGroupID(), dataOut);
        dataOut.writeInt(info.getGroupSequence());
        this.looseMarshalString(info.getCorrelationId(), dataOut);
        dataOut.writeBoolean(info.isPersistent());
        this.looseMarshalLong(wireFormat, info.getExpiration(), dataOut);
        dataOut.writeByte(info.getPriority());
        this.looseMarshalNestedObject(wireFormat, info.getReplyTo(), dataOut);
        this.looseMarshalLong(wireFormat, info.getTimestamp(), dataOut);
        dataOut.writeBoolean(info.isCompressed());
        dataOut.writeInt(info.getRedeliveryCounter());
        this.looseMarshalByteArray(wireFormat, info.getUsrContext(), dataOut);
        this.looseMarshalMessageProperties(wireFormat, info, dataOut);
        this.looseMarshalMessageContent(wireFormat, info, dataOut);
    }

    protected void looseMarshalMessageProperties(OpenWireFormat wireFormat, DataStructure info, DataOutput dataOut) throws IOException {
    }

    protected void looseMarshalMessageContent(OpenWireFormat wireFormat, DataStructure info, DataOutput dataOut) throws IOException {
        Message message = (Message)info;
        boolean haveProperties = false;
        boolean haveContent = false;
        if (message.getMarshalledProperties() != null) {
            dataOut.writeInt(this.messagePropertiesPktSize);
            haveProperties = true;
        }
        if (message.getContent() != null) {
            dataOut.writeInt(this.messageContentPktSize);
            haveContent = true;
        }
        if (haveProperties) {
            dataOut.write(message.getMarshalledProperties(), this.msgPropertiesoffset, this.messagePropertiesPktSize);
        }
        if (haveContent) {
            dataOut.write(message.getContent(), this.msgContentoffset, this.messageContentPktSize);
        }
    }

    protected int tightMarshalMessageContent1(byte[] data, BooleanStream bs) throws IOException {
        bs.writeBoolean(data != null);
        if (data != null) {
            return this.messageContentPktSize + 4;
        }
        return 0;
    }

    protected int tightMarshalMessageProperties1(byte[] marshalledProperties, BooleanStream bs) throws IOException {
        bs.writeBoolean(marshalledProperties != null);
        if (marshalledProperties != null) {
            return this.messagePropertiesPktSize + 4;
        }
        return 0;
    }

    protected void tightMarshalMessageProperties2(DataStructure info, DataOutput dataOut, BooleanStream bs) throws IOException {
    }

    protected void tightMarshalMessageContent2(DataStructure info, DataOutput dataOut, BooleanStream bs) throws IOException {
        Message message = (Message)info;
        boolean haveProperties = false;
        boolean haveContent = false;
        if (bs.readBoolean()) {
            dataOut.writeInt(this.messagePropertiesPktSize);
            haveProperties = true;
        }
        if (bs.readBoolean()) {
            dataOut.writeInt(this.messageContentPktSize);
            haveContent = true;
        }
        if (haveProperties) {
            dataOut.write(message.getMarshalledProperties(), this.msgPropertiesoffset, this.messagePropertiesPktSize);
        }
        if (haveContent) {
            dataOut.write(message.getContent(), this.msgContentoffset, this.messageContentPktSize);
        }
    }

    @Override
    public DataStructure createObject() {
        return null;
    }

    @Override
    public byte getDataStructureType() {
        return this.isFirstPkt() ? (byte)23 : 60;
    }

    private boolean isFirstPkt() {
        return this.msgContentoffset == 0 && this.msgPropertiesoffset == 0;
    }
}

