/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.jms.JMSException;
import com.tongtech.jmsclient.ReadChannel;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.jms.Destination;

public class ReadAckChannel
extends ReadChannel
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ReadAckChannel.class);
    protected static final String iReadAckChannel = "iReadAckChannel-";
    public Thread readAckChannelThread = null;

    public ReadAckChannel(ConnectionImpl connection) {
        super(connection);
        this.init();
    }

    private void init() {
        this.protectMode = this.connection.getProtectMode();
        this.readAckChannelThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.readAckChannelThread.setDaemon(true);
        }
        this.readAckChannelThread.setName(iReadAckChannel + this.connection.getLocalID());
        this.readAckChannelThread.start();
    }

    private void dispatch(ReadWritePacket pkt) throws javax.jms.JMSException {
        switch (pkt.getPacketType()) {
            case 119: {
                return;
            }
            case 54: {
                this.processPing(pkt);
                return;
            }
            case 55: {
                return;
            }
            case 73: {
                this.processInfoPacket(pkt);
                break;
            }
            case 15: 
            case 123: {
                this.replaceConsumerID(pkt);
                this.processAcknowledge(pkt);
                break;
            }
            case 11: {
                this.checkRedirectStatus(pkt);
                this.replaceConnectionID(pkt);
                this.updateBrokerVersionInfo(pkt);
                this.processAcknowledge(pkt);
                this.connection.writeChannel.updateFlowControl(pkt);
                break;
            }
            case 19: {
                this.replaceProducerID(pkt);
                this.processAcknowledge(pkt);
                break;
            }
            case 125: {
                break;
            }
            case 0: 
            case 8: 
            case 13: 
            case 17: 
            case 37: 
            case 38: 
            case 41: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 77: 
            case 79: 
            case 117: 
            case 118: 
            case 120: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 157: 
            case 168: 
            case 210: {
                this.processAcknowledge(pkt);
                break;
            }
            case 160: {
                this.processAcknowledge(pkt);
                this.receivedGoodByeReply = true;
                this.close();
                break;
            }
            case 121: {
                this.processResumeFlow(pkt);
                break;
            }
            case 28: {
                this.processBrokerGoodbye(pkt);
                break;
            }
            case 74: {
                this.processDebug(pkt);
                break;
            }
            default: {
                if (this.isClosed) break;
                String errString = AdministeredObject.cr.getKString("W2000");
                logger.warn(errString);
                pkt.dump(logger);
                this.checkConnectionState();
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connection.sayGoodbye(new Integer(0));
    }

    private void checkConnectionState() {
        try {
            if (this.protocolHandler.isClosed()) {
                logger.warn("Fatal Error: ReadChannel closing due to protocol handler closed.");
                this.close();
            }
        }
        catch (Exception e) {
            logger.info("", e);
        }
    }

    private void processPing(ReadOnlyPacket ping) {
        try {
            if (ping.getFlag(16)) {
                this.protocolHandler.pingReply(ping);
            }
        }
        catch (Exception jmse) {
            logger.warn(jmse.getLocalizedMessage(), jmse);
        }
    }

    private void processInfoPacket(ReadWritePacket pkt) {
        try {
            Hashtable prop = pkt.getProperties();
            int requestType = (Integer)prop.get("JMQRequestType");
            if (requestType == 1) {
                this.processStatusInfoPacket(pkt);
            } else if (requestType == 2) {
                this.processClusterInfoPacket(pkt);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("*** received unknown INFO packet: ");
                }
                pkt.dump(logger);
            }
            String addrlist = (String)prop.get("JMQBrokerList");
            if (addrlist != null) {
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                this.connection.JMQBrokerList = addrlist;
                this.connection.triggerConnectionAddressListChangedEvent(addrlist);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.info("", e);
            pkt.dump(logger);
        }
    }

    private void processStatusInfoPacket(ReadWritePacket pkt) {
        Hashtable prop = ReadAckChannel.getHashtableFromMessageBody(pkt);
        this.processStatusInfo(prop);
    }

    private void processStatusInfo(Hashtable prop) {
        boolean isLocal = this.isLocalBroker(prop);
        if (isLocal) {
            int state = (Integer)prop.get("State");
            long msecs = 0L;
            if (state == 7) {
                Long milliSecs = (Long)prop.get("ShutdownMS");
                if (milliSecs != null) {
                    msecs = milliSecs;
                }
                this.connection.triggerConnectionClosingEvent(msecs);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("INFO pkt is not for the local broker.");
        }
    }

    private boolean isLocalBroker(Hashtable prop) {
        boolean isLocal = (Boolean)prop.get("isLocal");
        return isLocal;
    }

    private void processClusterInfoPacket(ReadWritePacket pkt) {
        boolean isLocal = false;
        Hashtable table = ReadAckChannel.getHashtableFromMessageBody(pkt);
        Iterator it = table.values().iterator();
        boolean found = false;
        Hashtable prop = null;
        while (it.hasNext() && !found) {
            Object obj = it.next();
            if (!(obj instanceof Hashtable) || !(isLocal = this.isLocalBroker(prop = (Hashtable)obj))) continue;
            found = true;
        }
        if (found) {
            this.processStatusInfo(prop);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("INFO pkt is not for the local broker.");
            }
            pkt.dump(logger);
        }
    }

    public static Hashtable getHashtableFromMessageBody(ReadOnlyPacket pkt) {
        Hashtable prop = null;
        try {
            InputStream is = pkt.getMessageBodyStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            prop = (Hashtable)ois.readObject();
            ois.close();
            is.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.info("", e);
        }
        return prop;
    }

    protected void processDebug(ReadWritePacket pkt) {
        try {
            Hashtable props = ReadAckChannel.getHashtableFromMessageBody(pkt);
            boolean isLoggingConfigSet = this.setLoggingConfig(props);
            if (isLoggingConfigSet) {
                return;
            }
        }
        catch (Throwable e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
    }

    private boolean setLoggingConfig(Hashtable props) {
        boolean isLoggingConfigSet = false;
        try {
            String loggerName = (String)props.get("logging.name");
            if (loggerName != null) {
                java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
                String levelName = (String)props.get("logging.level");
                Level level = Level.parse(levelName);
                logger.setLevel(level);
                System.out.println("***** set logger " + logger.getName() + " to level " + levelName);
                String handlerClassName = (String)props.get("logging.handler");
                Handler handler = null;
                if (handlerClassName != null) {
                    System.out.println("**** Handler: " + handlerClassName);
                    if (handlerClassName.equals("java.util.logging.FileHandler")) {
                        String pattern = (String)props.get("logging.pattern");
                        if (pattern != null) {
                            System.out.println("**** logging pattern: " + pattern);
                            handler = new FileHandler(pattern);
                        } else {
                            handler = new FileHandler();
                        }
                    } else {
                        handler = (Handler)Class.forName(handlerClassName).newInstance();
                    }
                    handler.setLevel(level);
                    String formatterClassName = (String)props.get("logging.formatter");
                    if (formatterClassName != null) {
                        Formatter formatter = (Formatter)Class.forName(formatterClassName).newInstance();
                        System.out.println("*** setting formatter to handler: " + formatterClassName);
                        handler.setFormatter(formatter);
                    }
                    logger.addHandler(handler);
                    System.out.println("***** set handler " + handlerClassName + " to logger " + loggerName);
                }
                isLoggingConfigSet = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isLoggingConfigSet;
    }

    protected void processBrokerGoodbye(ReadWritePacket pkt) throws javax.jms.JMSException {
        Boolean jmqExit = null;
        String evcode = "E203";
        try {
            Hashtable props = pkt.getProperties();
            if (props != null) {
                jmqExit = (Boolean)props.get("JMQExit");
                Integer reason = (Integer)props.get("JMQGoodbyeReason");
                int goodbyeReason = -1;
                if (reason != null) {
                    goodbyeReason = reason;
                    switch (goodbyeReason) {
                        case 1: {
                            evcode = "E201";
                            break;
                        }
                        case 2: {
                            evcode = "E202";
                            break;
                        }
                        case 3: {
                            evcode = "E204";
                            break;
                        }
                        case 4: {
                            evcode = "E203";
                            break;
                        }
                        case 5: {
                            evcode = "E206";
                            break;
                        }
                        default: {
                            evcode = "E203";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
        this.connection.triggerConnectionClosedEvent(evcode, null);
        if (!this.connection.tmqiReconnect || jmqExit != null && jmqExit.booleanValue()) {
            String errorString = AdministeredObject.cr.getKString("C4056");
            javax.jms.JMSException jmse = new javax.jms.JMSException(errorString, "C4056");
            this.exitConnection(jmse);
        }
    }

    private void updateBrokerVersionInfo(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Boolean isHA;
            int statusCode;
            Integer protoLevel;
            Hashtable props = pkt.getProperties();
            String brokerVersion = (String)props.get("JMQVersion");
            if (brokerVersion != null) {
                this.connection.setBrokerVersion(brokerVersion);
            }
            if ((protoLevel = (Integer)props.get("JMQProtocolLevel")) != null) {
                this.connection.setBrokerProtocolLevel(protoLevel);
            }
            if ((statusCode = ((Integer)props.get("JMQStatus")).intValue()) == 505 && this.connection.checkBrokerProtocolLevel()) {
                this.connection.setNegotiateProtocolLevel(true);
                this.close();
            } else if (statusCode == 200 && (isHA = (Boolean)props.get("JMQHA")) != null && isHA.booleanValue()) {
                String tmp;
                Long storeID;
                this.connection.setConnectedToHABroker();
                if (this.connection.JMQClusterID == null) {
                    this.connection.JMQClusterID = (String)props.get("JMQClusterID");
                }
                if ((storeID = (Long)props.get("JMQStoreSession")) != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("**** Previous JMQStoreSession: {}", this.connection.JMQStoreSession);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("**** Using JMQStoreSession: {}", storeID);
                    }
                    this.connection.JMQStoreSession = storeID;
                }
                if ((tmp = (String)props.get("JMQBrokerList")) != null) {
                    this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                    this.connection.JMQBrokerList = tmp;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("*** connected to HA broker.  JMQClusterID={} JMQStoreSession={} JMQBrokerList={}", new Object[]{this.connection.JMQClusterID, this.connection.JMQStoreSession, this.connection.JMQBrokerList});
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(e, "C4000", true);
        }
    }

    protected void replaceConnectionID(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Long connectionID = (Long)props.get("JMQConnectionID");
            if (connectionID != null) {
                this.connection.setConnectionID(String.valueOf(connectionID));
            }
        }
        catch (Exception e) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(e, "C4000", true);
        }
    }

    protected void replaceProducerID(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Long jmqBytesProp;
            Hashtable props = pkt.getProperties();
            Long ackID = new Long(pkt.getConsumerID());
            Long newID = (Long)props.get("JMQProducerID");
            MessageProducerImpl producer = (MessageProducerImpl)this.requestMetaData.get(ackID);
            this.requestMetaData.remove(ackID);
            if (newID == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("**** No producer for packet: ");
                }
                pkt.dump(logger);
                return;
            }
            int jmqSize = -1;
            long jmqBytes = -1L;
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            if (jmqSizeProp != null) {
                jmqSize = jmqSizeProp;
            }
            if ((jmqBytesProp = (Long)props.get("JMQBytes")) != null) {
                jmqBytes = jmqBytesProp;
            }
            long producerID = newID;
            Destination dest = producer.addProducerDest;
            producer.setProducerID(dest, producerID);
            producer.setFlowLimit(producerID, jmqSize);
            producer.setFlowBytesLimit(producerID, jmqBytes);
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.warn("", e);
        }
    }

    protected void replaceConsumerID(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Long ackID = new Long(pkt.getConsumerID());
            Long newID = new Long(Long.parseLong((String)props.get("JMS_TONG_ConsumerID")));
            Consumer consumer = (Consumer)this.requestMetaData.get(ackID);
            this.requestMetaData.remove(ackID);
            if (newID == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("**** No consumer for packet: ");
                }
                pkt.dump(logger);
                return;
            }
            Integer destType = (Integer)props.get("JMQDestType");
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            if (logger.isTraceEnabled()) {
                logger.trace("repalceConsumerID: destType:{} jmqSizeProp:{} ", destType == null ? null : destType, (Object)(jmqSizeProp == null ? null : jmqSizeProp));
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
    }

    protected void processResumeFlow(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            Long jmqBytesProp = (Long)props.get("JMQBytes");
            Long producerID = (Long)props.get("JMQProducerID");
            if (logger.isTraceEnabled()) {
                logger.trace("processResumeFlow() : JMQSize = {}, JMQBytes = {}, ProducerID = {}", new Object[]{jmqSizeProp, jmqBytesProp, producerID});
            }
            if (producerID != null) {
                MessageProducerImpl producer = this.connection.findMessageProducer(producerID);
                if (producer != null) {
                    if (jmqSizeProp != null) {
                        producer.setFlowLimit(producerID, jmqSizeProp);
                    }
                    if (jmqBytesProp != null) {
                        producer.setFlowBytesLimit(producerID, jmqBytesProp);
                    }
                } else {
                    logger.info("*** warning: Cannot find producer for the resume pkt: ");
                }
            } else {
                this.connection.writeChannel.updateFlowControl(pkt);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
            pkt.dump(logger);
        }
    }

    protected void processAcknowledge(ReadWritePacket pkt) throws javax.jms.JMSException {
        long ackId = pkt.getConsumerID();
        SessionQueue ackQ = this.ackQTable.get(new Long(ackId));
        if (ackQ != null) {
            ackQ.enqueueNotify(pkt);
        } else if (!(this.connection.connectionIsBroken || this.connection.reconnecting || this.connection.isCloseCalled || 124 == pkt.getPacketType() || 128 == pkt.getPacketType())) {
            String errorString = AdministeredObject.cr.getKString("W2001");
            String pktstr = errorString + "\n" + pkt.toVerboseString();
            logger.trace("{} PacketType:{}", (Object)pktstr, (Object)new Integer(pkt.getPacketType()));
        }
    }

    @Override
    public void run() {
        ReadWritePacket packet = null;
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        while (!this.isClosed) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for read ack packet...{}", new Boolean(this.isClosed));
                }
                packet = this.protocolHandler.readPacket(0);
                this.dispatch(packet);
            }
            catch (javax.jms.JMSException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("ReadChannel[connection closed={}, received goodbye-reply={}] : {}", new Object[]{new Boolean(this.connection.isClosed), new Boolean(this.receivedGoodByeReply), e.getMessage()}, (Object)e);
                }
                if (this.isFatalErrorSet) {
                    this.fatalError(this.savedError);
                    System.out.println("ReadAckChannel exit 1...");
                    return;
                }
                if (this.connection.isClosed || this.receivedGoodByeReply) {
                    this.connection.connectionIsBroken = true;
                    this.closeIOAndNotify();
                    System.out.println("ReadAckChannel exit 2...");
                    return;
                }
                if (this.isBrokerNonResponsive) {
                    this.isBrokerNonResponsive = false;
                    this.connection.triggerConnectionClosedEvent("E207", null);
                } else {
                    this.connection.triggerConnectionClosedEvent("E206", e);
                }
                this.recover2(e);
            }
            catch (Exception ex) {
                logger.warn("no message!!");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable error) {
                logger.error("ReadAckChannel error.", error);
                this.fatalError(error);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ReadAckChannel exit 4...");
        }
    }

    private void checkRedirectStatus(ReadWritePacket pkt) throws javax.jms.JMSException {
        if (this.connection.reconnecting) {
            try {
                Hashtable props = pkt.getProperties();
                int statusCode = (Integer)props.get("JMQStatus");
                if (statusCode == 301) {
                    this.connection.JMQStoreOwner = (String)props.get("JMQStoreOwner");
                    this.connection.initiator.setRedirectURL(this.connection.JMQStoreOwner);
                    this.protocolHandler.close();
                    String str = AdministeredObject.cr.getKString("I108", this.connection.getLastContactedBrokerAddress(), this.connection.JMQStoreOwner);
                    ConnectionImpl.connectionLogger.log(Level.INFO, str);
                    JMSException jmse = new JMSException(str);
                    ExceptionHandler.throwJMSException(jmse);
                } else if (statusCode == 408) {
                    String str = AdministeredObject.cr.getKString("I109", this.connection.getLastContactedBrokerAddress());
                    ConnectionImpl.connectionLogger.log(Level.INFO, str);
                    this.protocolHandler.close();
                    JMSException jmse = new JMSException(str);
                    ExceptionHandler.throwJMSException(jmse);
                }
            }
            catch (javax.jms.JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                JMSException jmse = new JMSException(e.toString());
                ExceptionHandler.throwJMSException(jmse);
            }
        }
    }
}

