/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ConnectionRecover;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.InterestTable;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.ReadQTable;
import java.util.Hashtable;
import javax.jms.JMSException;

public abstract class ReadChannel {
    static Logger logger = LoggerFactory.getLogger(ReadChannel.class);
    protected ConnectionImpl connection = null;
    protected ProtocolHandler protocolHandler = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected InterestTable interestTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isClosed = false;
    protected boolean receivedGoodByeReply = false;
    protected FlowControl flowControl = null;
    protected boolean protectMode = false;
    protected boolean isFatalErrorSet = false;
    protected Throwable savedError = null;
    protected JMSException savedJMSException = null;
    protected boolean fatalErrorIsProcessed = false;
    protected boolean isBrokerNonResponsive = false;
    protected ConnectionRecover conrc = null;
    public static final int REQUEST_TYPE_STATUS = 1;
    public static final int REQUEST_TYPE_CLUSTER = 2;
    public static final int READ_ACK = 0;
    public static final int READ_MESSAGE = 1;

    public ReadChannel(ConnectionImpl connection) {
        this.connection = connection;
        this.protocolHandler = connection.getProtocolHandler();
        this.interestTable = connection.interestTable;
        this.readQTable = connection.readQTable;
        this.ackQTable = connection.ackQTable;
        this.requestMetaData = connection.requestMetaData;
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.flowControl.close();
    }

    public synchronized void setFatalError(Throwable err) {
        try {
            if (this.isFatalErrorSet) {
                return;
            }
            this.isFatalErrorSet = true;
            this.savedError = err;
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.warn("", e);
        }
    }

    public void setBrokerNonResponsive() {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("*** broker is not responsive.  Closing I/O stream ...");
            }
            this.isBrokerNonResponsive = true;
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatalError(Throwable error) {
        try {
            ExceptionHandler.logError(error);
            ReadChannel readChannel = this;
            synchronized (readChannel) {
                block10: {
                    if (!this.fatalErrorIsProcessed) break block10;
                    return;
                }
                this.fatalErrorIsProcessed = true;
            }
            this.connection.connectionIsBroken = true;
            this.readQTable.closeAll();
            String errorString = AdministeredObject.cr.getKString("C4089", error.toString());
            JMSException jmse = new JMSException(errorString, "C4089");
            this.exitConnection(jmse);
        }
        catch (Throwable err) {
            logger.warn("", err);
        }
        finally {
            this.isClosed = true;
        }
    }

    public void recover2(JMSException e) {
        this.connection.setRecoverInProcess(true);
        boolean connectStatus = false;
        if (this.connection.tmqiReconnect) {
            connectStatus = this.doRecover();
        }
        this.connection.setRecoverInProcess(false);
        if (!connectStatus) {
            this.exitConnection(e);
        }
    }

    private boolean doRecover() {
        boolean reconnected = false;
        try {
            this.connection.setReconnecting(true);
            this.closeIOAndNotify();
            if (this.conrc == null) {
                this.conrc = new ConnectionRecover(this.connection);
            } else {
                this.conrc.waitUntilInactive();
                if (this.conrc.getRecoverState() == 7) {
                    return false;
                }
            }
            this.conrc.init();
            reconnected = true;
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            this.connection.setReconnecting(false);
        }
        if (reconnected) {
            this.conrc.start();
        }
        return reconnected;
    }

    public void exitConnection(JMSException e) {
        this.connection.connectionIsBroken = true;
        this.savedJMSException = e;
        try {
            this.closeIOAndNotify();
            this.readQTable.closeAll();
            this.connection.exitConnection();
            this.flowControl.close();
        }
        finally {
            this.isClosed = true;
            this.connection.triggerConnectionClosedEvent("E206", e);
            this.connection.logLifeCycle("E500");
            if (this.connection.exceptionListener != null) {
                this.connection.triggerConnectionExitEvent(e);
            } else {
                Exception linkedE = e.getLinkedException();
                if (linkedE != null && this.protocolHandler.getAuthenticated()) {
                    logger.warn("", linkedE);
                }
                if (this.protocolHandler.getAuthenticated()) {
                    logger.warn("", e);
                }
            }
        }
    }

    public void closeIOAndNotify() {
        try {
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.warn("", e);
        }
        this.readQTable.notifyAllQueues();
        this.ackQTable.notifyAllQueues();
    }
}

