/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.jms.JMSException;
import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jms.protocol.TlqRemoteReadWritePacket;
import com.tongtech.jmsclient.PartialMessageDebugThread;
import com.tongtech.jmsclient.filemessage.FileMessageReceiver;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.remote.protocol.command.BaseMessage;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataResponse;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.FileContent;
import com.tongtech.remote.protocol.command.FileInfo;
import com.tongtech.remote.protocol.command.PartialMessageAck;
import com.tongtech.remote.protocol.command.ProducerAck;
import com.tongtech.remote.protocol.command.RemoveInfo;
import com.tongtech.remote.protocol.command.Response;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ConnectionRecover;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.InterestTable;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.QueueReceiverImpl;
import com.tongtech.tmqi.jmsclient.ReadQTable;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.TopicSubscriberImpl;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;

public class TlqRemoteReadMessageChannel
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(TlqRemoteReadMessageChannel.class);
    protected Thread readChannelThread = null;
    private ConnectionImpl connection = null;
    private ProtocolHandler protocolHandler = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected InterestTable interestTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isClosed = false;
    protected boolean receivedGoodByeReply = false;
    protected FlowControl flowControl = null;
    protected boolean protectMode = false;
    protected static final String iMQReadChannel = "iMQReadChannel-";
    private boolean isFatalErrorSet = false;
    private Throwable savedError = null;
    protected javax.jms.JMSException savedJMSException = null;
    private boolean fatalErrorIsProcessed = false;
    private boolean isBrokerNonResponsive = false;
    protected ConnectionRecover conrc = null;
    public Map partialMessageMap = null;
    public Map fileInfoMap = null;
    public Map fileReceiverMap;
    protected Map partialMessageErrorAckMap;
    private PartialMessageDebugThread partialMessageDebugThread = null;
    public static final int REQUEST_TYPE_STATUS = 1;
    public static final int REQUEST_TYPE_CLUSTER = 2;

    TlqRemoteReadMessageChannel(ConnectionImpl connection) {
        this.connection = connection;
        this.protocolHandler = connection.getProtocolHandler();
        this.interestTable = connection.interestTable;
        this.readQTable = connection.readQTable;
        this.ackQTable = connection.ackQTable;
        this.requestMetaData = connection.requestMetaData;
        this.init();
    }

    private void init() {
        this.protectMode = this.connection.getProtectMode();
        this.connection.flowControl = this.flowControl = new FlowControl(this.connection);
        this.flowControl.start();
        this.readChannelThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.readChannelThread.setDaemon(true);
        }
        this.partialMessageMap = new ConcurrentHashMap();
        this.fileInfoMap = new ConcurrentHashMap();
        this.fileReceiverMap = new ConcurrentHashMap();
        this.partialMessageErrorAckMap = ((TlqRemoteProtocolHandler)this.protocolHandler).partialMessageErrorAckMap;
        this.readChannelThread.setName(iMQReadChannel + this.connection.getLocalID());
        this.readChannelThread.start();
    }

    private void dispatch(ReadWritePacket pkt) throws javax.jms.JMSException {
        Command command = ((TlqRemoteReadWritePacket)pkt).getCommand();
        logger.trace("pkt received: {}", command.getDataStructureType());
        block0 : switch (command.getDataStructureType()) {
            case 1: {
                this.processAcknowledge(pkt);
                break;
            }
            case 30: {
                Response response = (Response)command;
                switch (response.getRequestCommandType()) {
                    case 5: {
                        this.replaceConsumerID(pkt);
                        this.processAcknowledge(pkt);
                        break block0;
                    }
                    case 6: {
                        this.replaceProducerID(pkt);
                        this.processAcknowledge(pkt);
                        break block0;
                    }
                    case 10: {
                        break block0;
                    }
                }
                this.processAcknowledge(pkt);
                break;
            }
            case 32: {
                Response response = (Response)command;
                DataStructure data = ((DataResponse)response).getData();
                switch (response.getRequestCommandType()) {
                    case 12: {
                        this.processAcknowledge(pkt);
                        RemoveInfo removeInfo = (RemoveInfo)data;
                        if (removeInfo.getObjectId().getDataStructureType() != 120) break block0;
                        this.receivedGoodByeReply = true;
                        this.close();
                        break;
                    }
                    case 23: 
                    case 60: 
                    case 83: {
                        PartialMessageAck errorAck = (PartialMessageAck)data;
                        if (!this.needProducerResponse(command.getCommandId())) {
                            if (errorAck.getStatusCode() == 0) break block0;
                            this.processSendException(errorAck);
                            break;
                        }
                        this.partialMessageErrorAckMap.put(new Long(command.getCommandId()), errorAck);
                        this.processAcknowledge(pkt);
                        break;
                    }
                    default: {
                        this.processAcknowledge(pkt);
                        break;
                    }
                }
                break;
            }
            case 33: {
                Response response = (Response)command;
                switch (response.getRequestCommandType()) {
                    case 5: {
                        this.replaceConsumerID(pkt);
                        this.processAcknowledge(pkt);
                        break block0;
                    }
                }
                this.processAcknowledge(pkt);
                break;
            }
            case 31: {
                this.processAcknowledge(pkt);
                break;
            }
            case 23: 
            case 60: {
                this.processJMSMessage(pkt);
                break;
            }
            case 19: {
                this.processProducerAck(pkt);
                break;
            }
            case 10: {
                this.protocolHandler.ping();
                break;
            }
            case 82: {
                this.processFileInfo(pkt);
                break;
            }
            case 83: {
                this.processFileMessage(pkt);
                break;
            }
            case 36: {
                this.processAcknowledge(pkt);
                break;
            }
            default: {
                if (this.isClosed) break;
                String errString = AdministeredObject.cr.getKString("W2000");
                if (logger.isTraceEnabled()) {
                    logger.trace(errString);
                }
                pkt.dump(logger);
                this.checkConnectionState();
            }
        }
    }

    private void processSendException(PartialMessageAck errorAck) {
        javax.jms.JMSException jmse = new javax.jms.JMSException(errorAck.getReason(), String.valueOf(errorAck.getStatusCode()));
        this.connection.triggerSendExcetpion(jmse);
    }

    private boolean needProducerResponse(long ackId) {
        SessionQueue ackQ = this.ackQTable.get(new Long(ackId));
        return ackQ != null;
    }

    private void processFileMessage(ReadWritePacket pkt) {
        FileContent content = (FileContent)((TlqRemoteReadWritePacket)pkt).getCommand();
        ConsumerId consumerid = content.getConsumerId();
        FileMessageReceiver receiver = (FileMessageReceiver)this.fileReceiverMap.get(consumerid);
        if (receiver == null) {
            logger.debug("consumerid :{} FileMessageReceiver is null ", consumerid);
            return;
        }
        if (content.getPiece() < receiver.getRemainPiece()) {
            return;
        }
        try {
            boolean isFinished = receiver.getFileReceiveHandler().receiveFileContent(content);
            if (isFinished) {
                this.fileReceiverMap.remove(consumerid);
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    private void processFileInfo(ReadWritePacket pkt) {
        FileInfo info = (FileInfo)((TlqRemoteReadWritePacket)pkt).getCommand();
        Object obj = this.fileInfoMap.get(new Long(info.getSeqId()));
        FileInfo remain = null;
        if (obj != null) {
            remain = (FileInfo)obj;
            remain.appendProperties(info);
            if (info.isLast()) {
                remain.setFileName(info.getFileName());
                remain.setFileSize(info.getFileSize());
                remain.setPieceSize(info.getPieceSize());
            }
        } else {
            this.fileInfoMap.put(new Long(info.getSeqId()), info);
        }
        if (info.isLast()) {
            if (remain == null) {
                remain = info;
            }
            this.fileInfoMap.remove(new Long(info.getSeqId()));
            FileMessageReceiver receiver = new FileMessageReceiver(remain, this.connection, this);
            this.fileReceiverMap.put(info.getTargetConsumerId(), receiver);
            logger.trace("add receiver :" + receiver);
            receiver.receive(this.connection.getProtocolHandler());
        }
    }

    private void processProducerAck(ReadWritePacket pkt) {
        ProducerAck producerAck = (ProducerAck)((TlqRemoteReadWritePacket)pkt).getCommand();
        long id = producerAck.getProducerId().getValue();
        long resumeSize = producerAck.getSize();
        MessageProducerImpl producer = this.connection.findMessageProducer(new Long(id));
        if (producer != null) {
            producer.decreaseUsage(id, resumeSize);
        }
    }

    private void checkConnectionState() {
        try {
            if (this.protocolHandler.isClosed()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Fatal Error: ReadChannel closing due to protocol handler closed.");
                }
                this.close();
            }
        }
        catch (Exception e) {
            logger.info("", e);
        }
    }

    private void processPing(ReadOnlyPacket ping) {
        try {
            if (ping.getFlag(16)) {
                this.protocolHandler.pingReply(ping);
            }
        }
        catch (Exception jmse) {
            logger.warn(jmse.getLocalizedMessage(), jmse);
        }
    }

    private void processInfoPacket(ReadWritePacket pkt) {
        try {
            Hashtable prop = pkt.getProperties();
            int requestType = (Integer)prop.get("JMQRequestType");
            if (requestType == 1) {
                this.processStatusInfoPacket(pkt);
            } else if (requestType == 2) {
                this.processClusterInfoPacket(pkt);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("*** received unknown INFO packet: ");
                }
                pkt.dump(logger);
            }
            String addrlist = (String)prop.get("JMQBrokerList");
            if (addrlist != null) {
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                this.connection.JMQBrokerList = addrlist;
                this.connection.triggerConnectionAddressListChangedEvent(addrlist);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.info("", e);
            pkt.dump(logger);
        }
    }

    private void processStatusInfoPacket(ReadWritePacket pkt) {
        Hashtable prop = TlqRemoteReadMessageChannel.getHashtableFromMessageBody(pkt);
        this.processStatusInfo(prop);
    }

    private void processStatusInfo(Hashtable prop) {
        boolean isLocal = this.isLocalBroker(prop);
        if (isLocal) {
            int state = (Integer)prop.get("State");
            long msecs = 0L;
            if (state == 7) {
                Long milliSecs = (Long)prop.get("ShutdownMS");
                if (milliSecs != null) {
                    msecs = milliSecs;
                }
                this.connection.triggerConnectionClosingEvent(msecs);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("INFO pkt is not for the local broker.");
        }
    }

    private boolean isLocalBroker(Hashtable prop) {
        boolean isLocal = (Boolean)prop.get("isLocal");
        return isLocal;
    }

    private void processClusterInfoPacket(ReadWritePacket pkt) {
        boolean isLocal = false;
        Hashtable table = TlqRemoteReadMessageChannel.getHashtableFromMessageBody(pkt);
        Iterator it = table.values().iterator();
        boolean found = false;
        Hashtable prop = null;
        while (it.hasNext() && !found) {
            Object obj = it.next();
            if (!(obj instanceof Hashtable) || !(isLocal = this.isLocalBroker(prop = (Hashtable)obj))) continue;
            found = true;
        }
        if (found) {
            this.processStatusInfo(prop);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("INFO pkt is not for the local broker.");
            }
            pkt.dump(logger);
        }
    }

    public static Hashtable getHashtableFromMessageBody(ReadOnlyPacket pkt) {
        Hashtable prop = null;
        try {
            InputStream is = pkt.getMessageBodyStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            prop = (Hashtable)ois.readObject();
            ois.close();
            is.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.info("", e);
        }
        return prop;
    }

    protected void processDebug(ReadWritePacket pkt) {
        try {
            Hashtable props = TlqRemoteReadMessageChannel.getHashtableFromMessageBody(pkt);
            boolean isLoggingConfigSet = this.setLoggingConfig(props);
            if (isLoggingConfigSet) {
                return;
            }
        }
        catch (Throwable e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
    }

    private boolean setLoggingConfig(Hashtable props) {
        boolean isLoggingConfigSet = false;
        try {
            String loggerName = (String)props.get("logging.name");
            if (loggerName != null) {
                java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
                String levelName = (String)props.get("logging.level");
                Level level = Level.parse(levelName);
                logger.setLevel(level);
                String handlerClassName = (String)props.get("logging.handler");
                Handler handler = null;
                if (handlerClassName != null) {
                    String pattern;
                    handler = handlerClassName.equals("java.util.logging.FileHandler") ? ((pattern = (String)props.get("logging.pattern")) != null ? new FileHandler(pattern) : new FileHandler()) : (Handler)Class.forName(handlerClassName).newInstance();
                    handler.setLevel(level);
                    String formatterClassName = (String)props.get("logging.formatter");
                    if (formatterClassName != null) {
                        Formatter formatter = (Formatter)Class.forName(formatterClassName).newInstance();
                        handler.setFormatter(formatter);
                    }
                    logger.addHandler(handler);
                }
                isLoggingConfigSet = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isLoggingConfigSet;
    }

    protected void processBrokerGoodbye(ReadWritePacket pkt) throws javax.jms.JMSException {
        Boolean jmqExit = null;
        String evcode = "E203";
        try {
            Hashtable props = pkt.getProperties();
            if (props != null) {
                jmqExit = (Boolean)props.get("JMQExit");
                Integer reason = (Integer)props.get("JMQGoodbyeReason");
                int goodbyeReason = -1;
                if (reason != null) {
                    goodbyeReason = reason;
                    switch (goodbyeReason) {
                        case 1: {
                            evcode = "E201";
                            break;
                        }
                        case 2: {
                            evcode = "E202";
                            break;
                        }
                        case 3: {
                            evcode = "E204";
                            break;
                        }
                        case 4: {
                            evcode = "E203";
                            break;
                        }
                        case 5: {
                            evcode = "E206";
                            break;
                        }
                        default: {
                            evcode = "E203";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
        this.connection.triggerConnectionClosedEvent(evcode, null);
        if (!this.connection.tmqiReconnect || jmqExit != null && jmqExit.booleanValue()) {
            String errorString = AdministeredObject.cr.getKString("C4056");
            javax.jms.JMSException jmse = new javax.jms.JMSException(errorString, "C4056");
            this.exitConnection(jmse);
        }
    }

    private void updateBrokerVersionInfo(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Boolean isHA;
            int statusCode;
            Integer protoLevel;
            Hashtable props = pkt.getProperties();
            String brokerVersion = (String)props.get("JMQVersion");
            if (brokerVersion != null) {
                this.connection.setBrokerVersion(brokerVersion);
            }
            if ((protoLevel = (Integer)props.get("JMQProtocolLevel")) != null) {
                this.connection.setBrokerProtocolLevel(protoLevel);
            }
            if ((statusCode = ((Integer)props.get("JMQStatus")).intValue()) == 505 && this.connection.checkBrokerProtocolLevel()) {
                this.connection.setNegotiateProtocolLevel(true);
                this.close();
            } else if (statusCode == 200 && (isHA = (Boolean)props.get("JMQHA")) != null && isHA.booleanValue()) {
                String tmp;
                Long storeID;
                this.connection.setConnectedToHABroker();
                if (this.connection.JMQClusterID == null) {
                    this.connection.JMQClusterID = (String)props.get("JMQClusterID");
                }
                if ((storeID = (Long)props.get("JMQStoreSession")) != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("**** Previous JMQStoreSession: " + this.connection.JMQStoreSession);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("**** Using JMQStoreSession: " + storeID);
                    }
                    this.connection.JMQStoreSession = storeID;
                }
                if ((tmp = (String)props.get("JMQBrokerList")) != null) {
                    this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                    this.connection.JMQBrokerList = tmp;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("*** connected to HA broker.  JMQClusterID=" + this.connection.JMQClusterID + " JMQStoreSession=" + this.connection.JMQStoreSession + " JMQBrokerList=" + this.connection.JMQBrokerList);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(e, "C4000", true);
        }
    }

    protected void replaceConnectionID(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Long connectionID = (Long)props.get("JMQConnectionID");
            if (connectionID != null) {
                this.connection.setConnectionID(String.valueOf(connectionID));
            }
        }
        catch (Exception e) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(e, "C4000", true);
        }
    }

    protected void replaceProducerID(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Long ackID = new Long(((TlqRemoteReadWritePacket)pkt).getCommand().getCommandId());
            this.requestMetaData.remove(ackID);
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.warn("", e);
        }
    }

    protected void replaceConsumerID(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            int jmqSize;
            Response command = (Response)((TlqRemoteReadWritePacket)pkt).getCommand();
            Long ackID = new Long(command.getCommandId());
            Consumer consumer = (Consumer)this.requestMetaData.get(ackID);
            this.requestMetaData.remove(ackID);
            this.interestTable.addInterest(consumer);
            Integer jmqSizeProp = new Integer(1000);
            if (jmqSizeProp != null && (jmqSize = jmqSizeProp.intValue()) > 0) {
                consumer.setPrefetchMaxMsgCount(jmqSize);
            }
            this.connection.flowControl.addConsumerFlowControl(consumer);
            SessionImpl session = null;
            if (command.getRequestCommandType() == 5) {
                if (consumer instanceof TopicSubscriberImpl) {
                    TopicSubscriberImpl ts = (TopicSubscriberImpl)consumer;
                    session = ts.getSession();
                    session.addMessageConsumer((MessageConsumerImpl)consumer);
                } else if (consumer instanceof QueueReceiverImpl) {
                    QueueReceiverImpl qr = (QueueReceiverImpl)consumer;
                    session = qr.getSession();
                    session.addMessageConsumer((MessageConsumerImpl)consumer);
                } else if (consumer instanceof BrowserConsumer) {
                    BrowserConsumer bc = (BrowserConsumer)consumer;
                    session = bc.getSession();
                    session.addBrowserConsumer(bc);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
    }

    protected void processResumeFlow(ReadWritePacket pkt) throws javax.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            Long jmqBytesProp = (Long)props.get("JMQBytes");
            Long producerID = (Long)props.get("JMQProducerID");
            if (logger.isTraceEnabled()) {
                logger.trace("processResumeFlow() : JMQSize = " + jmqSizeProp + ", JMQBytes = " + jmqBytesProp + ", ProducerID = " + producerID);
            }
            if (producerID != null) {
                MessageProducerImpl producer = this.connection.findMessageProducer(producerID);
                if (producer != null) {
                    if (jmqSizeProp != null) {
                        producer.setFlowLimit(producerID, jmqSizeProp);
                    }
                    if (jmqBytesProp != null) {
                        producer.setFlowBytesLimit(producerID, jmqBytesProp);
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace("*** warning: Cannot find producer for the resume pkt: ");
                    }
                    pkt.dump(logger);
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Connection Resume Flow pkt dump: ");
                }
                pkt.dump(logger);
                this.connection.writeChannel.updateFlowControl(pkt);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
            pkt.dump(logger);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processJMSMessage(ReadWritePacket pkt) throws javax.jms.JMSException {
        SessionQueue sessionQ = null;
        Consumer consumer = null;
        Long sessionId = null;
        this.flowControl.messageReceived();
        if (pkt.getFlowPaused()) {
            this.flowControl.requestConnectionFlowResume();
        }
        BaseMessage message = (BaseMessage)((TlqRemoteReadWritePacket)pkt).getCommand();
        if (pkt.getPacketType() != 7) {
            boolean isfirstPkt;
            boolean bl = isfirstPkt = message.getDataStructureType() == 23;
            if (isfirstPkt && !message.isLast()) {
                this.partialMessageMap.put(new Long(message.getSeqId()), pkt);
                ((TlqRemoteReadWritePacket)pkt).setPartialMessageLastRecTimestamp(System.currentTimeMillis());
                return;
            }
            if (!isfirstPkt) {
                TlqRemoteReadWritePacket remainPkt = (TlqRemoteReadWritePacket)this.partialMessageMap.get(new Long(message.getSeqId()));
                if (remainPkt != null) {
                    remainPkt.appendPartialMessage(message);
                    remainPkt.setPartialMessageLastRecTimestamp(System.currentTimeMillis());
                    if (!message.isLast()) return;
                    this.partialMessageMap.remove(new Long(message.getSeqId()));
                    remainPkt.setPartialBufToMessage();
                    pkt = remainPkt;
                    logger.trace("recvice last partial message {}", message.getMessageId());
                } else {
                    logger.error("Can't find out message in partial message map ,{},Cousumser Id :{}", message.getMessageId(), (Object)new Integer(message.getTargetConsumerId().getValue()));
                }
            }
        }
        pkt.setMessageID(message.getMessageId().getValue());
        long id = message.getTargetConsumerId().getValue();
        consumer = this.interestTable.getConsumer(new Long(id));
        if (consumer != null) {
            sessionId = consumer.getReadQueueId();
            if (sessionId != null) {
                sessionQ = this.readQTable.get(sessionId);
                if (sessionQ != null) {
                    this.flowControl.messageReceived(consumer);
                    if (pkt.getConsumerFlow()) {
                        this.flowControl.requestResume(consumer);
                    }
                    if (consumer instanceof BrowserConsumer) {
                        this.deliverToBrowserConsumer((BrowserConsumer)consumer, pkt);
                        return;
                    } else {
                        sessionQ.enqueueNotify(pkt);
                    }
                    return;
                } else {
                    String errorString = AdministeredObject.cr.getKString("W2001");
                    String pktstr = errorString + "\n" + pkt.toVerboseString();
                    ConnectionImpl.connectionLogger.log(Level.WARNING, pktstr);
                }
                return;
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("ERROR: NO session (null) for packet: ");
                }
                pkt.dump(logger);
                String msg = "No Session for pkt: \n" + pkt.toVerboseString();
                ConnectionImpl.connectionLogger.log(Level.FINE, msg);
            }
            return;
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("ERROR: NO consumer for packet: " + pkt);
            }
            pkt.dump(logger);
            String msg = "No consumer for pkt: \n" + pkt.toVerboseString();
            ConnectionImpl.connectionLogger.log(Level.FINE, msg);
        }
    }

    protected void deliverToBrowserConsumer(BrowserConsumer consumer, ReadOnlyPacket pkt) throws javax.jms.JMSException {
        MessageImpl message = this.protocolHandler.getJMSMessage(pkt);
        SessionImpl session = consumer.session;
        message.setSession(session);
        consumer.onMessage(message);
    }

    protected void processAcknowledge(ReadWritePacket pkt) throws javax.jms.JMSException {
        Command command = ((TlqRemoteReadWritePacket)pkt).getCommand();
        long ackId = command.getCommandId();
        SessionQueue ackQ = this.ackQTable.get(new Long(ackId));
        if (ackQ != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("*** notify waiting queue ...." + command);
            }
            ackQ.enqueueNotify(pkt);
        } else if (!(this.connection.connectionIsBroken || this.connection.reconnecting || this.connection.isCloseCalled)) {
            String errorString = AdministeredObject.cr.getKString("W2001");
            String pktstr = errorString + "\n" + pkt.toVerboseString();
            logger.warn(pktstr + " command:" + command);
        }
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.flowControl.close();
    }

    @Override
    public void run() {
        ReadWritePacket packet = null;
        while (!this.isClosed) {
            try {
                packet = this.protocolHandler.readPacket(1);
                this.dispatch(packet);
            }
            catch (javax.jms.JMSException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("ReadChannel[connection closed=" + this.connection.isClosed + ", received goodbye-reply=" + this.receivedGoodByeReply + "] : " + e.getMessage());
                }
                logger.error("", e);
                if (this.isFatalErrorSet) {
                    this.fatalError(this.savedError);
                    return;
                }
                if (this.connection.isClosed || this.receivedGoodByeReply) {
                    this.connection.connectionIsBroken = true;
                    this.closeIOAndNotify();
                    return;
                }
                if (this.isBrokerNonResponsive) {
                    this.isBrokerNonResponsive = false;
                    this.connection.triggerConnectionClosedEvent("E207", null);
                } else {
                    this.connection.triggerConnectionClosedEvent("E206", e);
                }
                this.recover2(e);
            }
            catch (Exception ex) {
                logger.info("TcpReadChannel", ex);
                ex.printStackTrace();
            }
            catch (Throwable error) {
                error.printStackTrace();
                this.fatalError(error);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ReadChannel exit ...");
        }
    }

    protected synchronized void setFatalError(Throwable err) {
        try {
            if (this.isFatalErrorSet) {
                return;
            }
            this.isFatalErrorSet = true;
            this.savedError = err;
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.info("", e);
        }
    }

    public void setBrokerNonResponsive() {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("*** broker is not responsive.  Closing I/O stream ...");
            }
            this.isBrokerNonResponsive = true;
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fatalError(Throwable error) {
        try {
            ExceptionHandler.logError(error);
            TlqRemoteReadMessageChannel tlqRemoteReadMessageChannel = this;
            synchronized (tlqRemoteReadMessageChannel) {
                block10: {
                    if (!this.fatalErrorIsProcessed) break block10;
                    return;
                }
                this.fatalErrorIsProcessed = true;
            }
            this.connection.connectionIsBroken = true;
            this.readQTable.closeAll();
            String errorString = AdministeredObject.cr.getKString("C4089", error.toString());
            javax.jms.JMSException jmse = new javax.jms.JMSException(errorString, "C4089");
            this.exitConnection(jmse);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        finally {
            this.isClosed = true;
        }
    }

    private void recover2(javax.jms.JMSException e) {
        this.connection.setRecoverInProcess(true);
        boolean connectStatus = false;
        if (this.connection.tmqiReconnect) {
            connectStatus = this.doRecover();
        }
        this.connection.setRecoverInProcess(false);
        if (!connectStatus) {
            this.exitConnection(e);
        }
    }

    private boolean doRecover() {
        boolean reconnected = false;
        try {
            this.connection.setReconnecting(true);
            this.closeIOAndNotify();
            if (this.conrc == null) {
                this.conrc = new ConnectionRecover(this.connection);
            } else {
                this.conrc.waitUntilInactive();
                if (this.conrc.getRecoverState() == 7) {
                    return false;
                }
            }
            this.conrc.init();
            reconnected = true;
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            this.connection.setReconnecting(false);
        }
        if (reconnected) {
            this.conrc.start();
        }
        return reconnected;
    }

    protected void exitConnection(javax.jms.JMSException e) {
        this.connection.connectionIsBroken = true;
        this.savedJMSException = e;
        try {
            this.closeIOAndNotify();
            this.readQTable.closeAll();
            this.connection.exitConnection();
            this.flowControl.close();
        }
        finally {
            this.isClosed = true;
            this.connection.triggerConnectionClosedEvent("E206", e);
            this.connection.logLifeCycle("E500");
            if (this.connection.exceptionListener != null) {
                this.connection.triggerConnectionExitEvent(e);
            } else {
                Exception linkedE = e.getLinkedException();
                if (linkedE != null && this.protocolHandler.getAuthenticated()) {
                    logger.warn("", linkedE);
                }
                if (this.protocolHandler.getAuthenticated()) {
                    logger.warn("", e);
                }
            }
        }
    }

    public void closeIOAndNotify() {
        try {
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.info("", e);
        }
        this.readQTable.notifyAllQueues();
        this.ackQTable.notifyAllQueues();
    }

    private void checkRedirectStatus(ReadWritePacket pkt) throws javax.jms.JMSException {
        if (this.connection.reconnecting) {
            try {
                Hashtable props = pkt.getProperties();
                int statusCode = (Integer)props.get("JMQStatus");
                if (statusCode == 301) {
                    this.connection.JMQStoreOwner = (String)props.get("JMQStoreOwner");
                    this.connection.initiator.setRedirectURL(this.connection.JMQStoreOwner);
                    this.protocolHandler.close();
                    String str = AdministeredObject.cr.getKString("I108", this.connection.getLastContactedBrokerAddress(), this.connection.JMQStoreOwner);
                    ConnectionImpl.connectionLogger.log(Level.INFO, str);
                    JMSException jmse = new JMSException(str);
                    ExceptionHandler.throwJMSException(jmse);
                } else if (statusCode == 408) {
                    String str = AdministeredObject.cr.getKString("I109", this.connection.getLastContactedBrokerAddress());
                    ConnectionImpl.connectionLogger.log(Level.INFO, str);
                    this.protocolHandler.close();
                    JMSException jmse = new JMSException(str);
                    ExceptionHandler.throwJMSException(jmse);
                }
            }
            catch (javax.jms.JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                JMSException jmse = new JMSException(e.toString());
                ExceptionHandler.throwJMSException(jmse);
            }
        }
    }

    public void dispatchFileMessage(TlqRemoteReadWritePacket pkt) throws javax.jms.JMSException {
        this.processJMSMessage(pkt);
    }

    public void cleanUpFileInfoBySeqId(Long seqId) {
        this.fileInfoMap.remove(seqId);
    }

    public void cleanUpFileMessageReceiver(ConsumerId consumerid) {
        Object receiver = this.fileReceiverMap.get(consumerid);
        if (receiver != null) {
            ((FileMessageReceiver)receiver).cleanUp();
            this.fileReceiverMap.remove(consumerid);
        }
    }
}

