/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient.filemessage;

import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jms.protocol.TlqRemoteReadWritePacket;
import com.tongtech.jmsclient.TlqRemoteReadMessageChannel;
import com.tongtech.jmsclient.filemessage.FileReceiveHandler;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.util.TlqKnlMessagePropertiesUtil;
import com.tongtech.remote.protocol.command.FileInfo;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;

public class FileMessageReceiver {
    static Logger logger = LoggerFactory.getLogger(FileReceiveHandler.class);
    protected FileInfo fileinfo;
    protected ConnectionImpl connection;
    private TlqRemoteReadMessageChannel readChannel;
    protected boolean hasError;
    protected String recvDir = "";
    protected int fileNameLength = 0;
    protected FileReceiveHandler fileHandler = null;
    private int remainPiece = 0;

    public int getRemainPiece() {
        return this.remainPiece;
    }

    public FileMessageReceiver(FileInfo info, ConnectionImpl connection, TlqRemoteReadMessageChannel tlqRemoteReadMessageChannel) {
        this.fileinfo = info;
        this.readChannel = tlqRemoteReadMessageChannel;
        this.connection = connection;
        String temp = connection.getTrimmedProperty("tmqiFileRcvDir");
        this.recvDir = temp == null || temp.equals("null") || temp.equals("") ? TlqRemoteProtocolHandler.RECV_FILE_DIR : temp;
    }

    public FileReceiveHandler getFileReceiveHandler() {
        return this.fileHandler;
    }

    public void receive(ProtocolHandler h) {
        TlqRemoteProtocolHandler handler = (TlqRemoteProtocolHandler)h;
        if (handler.isLocalFile) {
            TlqRemoteReadWritePacket pkt = FileReceiveHandler.createFileMessage(this.fileinfo, null);
            try {
                this.readChannel.dispatchFileMessage(pkt);
            }
            catch (JMSException e) {
                logger.debug("error", e);
            }
            return;
        }
        String filename = this.fixFileName();
        File file = this.getRecordFile();
        try {
            File filedir = new File(this.recvDir);
            TlqRemoteProtocolHandler.createDirIfNotExists(filedir);
            this.recvDir = filedir.getCanonicalPath();
            File testfile = null;
            testfile = new File(this.recvDir + File.separator + this.fileinfo.getFileName());
            boolean resume = this.isResume(file, testfile);
            if (!resume) {
                filename = this.handleRecvFileRename(file, testfile);
            }
            RandomAccessFile recordFile = new RandomAccessFile(file, "rw");
            this.caculateFileNameLengthAndWriteToFileIfNotResume(filename, recordFile, resume);
            logger.trace("msgid :{} ,resume:{}", new Object[]{this.fileinfo.getMessageId(), new Boolean(resume)});
            int recvPiece = 0;
            if (resume && (recvPiece = this.getReceivedPiece(recordFile)) == 0) {
                this.createFileHandler(file, recvPiece, 0L, this.fileinfo.getFileSize());
                this.fileHandler.init();
                return;
            }
            this.remainPiece = recvPiece;
            logger.trace("recvPiece:{},fileinfo.getPieceSize {}", new Object[]{new Integer(recvPiece), new Integer(this.fileinfo.getPieceSize())});
            this.sendFileRecvRequest(handler, file, recvPiece);
            recordFile.close();
        }
        catch (Exception e) {
            logger.warn("receive file error", e);
        }
    }

    public void cleanUp() {
        this.readChannel.cleanUpFileInfoBySeqId(new Long(this.fileinfo.getSeqId()));
    }

    private File getRecordFile() {
        String recFilename = this.fileinfo.getMessageId().getValue();
        File file = new File(TlqRemoteProtocolHandler.FILEMSG_CONF_DIR + File.separator + recFilename.replace(':', '_') + ".rec");
        return file;
    }

    private void sendFileRecvRequest(TlqRemoteProtocolHandler handler, File file, int recvPiece) {
        long start = recvPiece * this.fileinfo.getPieceSize();
        long end = this.fileinfo.getFileSize();
        logger.trace("start Receive ,msgid {},start :{},end : {},receive from : {}", new Object[]{this.fileinfo.getMessageId(), new Long(start), new Long(end), new Integer(recvPiece)});
        if (start >= end) {
            start = recvPiece * this.fileinfo.getPieceSize();
        } else {
            recvPiece = recvPiece == 0 ? 0 : recvPiece;
        }
        this.createFileHandler(file, recvPiece, start, end);
        this.fileHandler.handle(handler.getDataOutputStream(), handler.getOpenWireFormat(), handler);
    }

    private void createFileHandler(File file, int recvPiece, long start, long end) {
        this.fileHandler = new FileReceiveHandler(this.fileinfo, this, file, start, end, recvPiece, this.readChannel);
    }

    private int getReceivedPiece(RandomAccessFile recordFile) throws IOException {
        recordFile.seek(this.fileNameLength);
        byte[] value = new byte[4];
        recordFile.read(value);
        int recvPiece = TlqKnlMessagePropertiesUtil.parseInteger(value);
        return recvPiece;
    }

    private String handleRecvFileRename(File file, File testfile) throws IOException {
        String rename;
        String filename = null;
        if (testfile.exists() && (rename = this.connection.getTrimmedProperty("tmqiRcvFileRename")) != null && Boolean.valueOf(rename).booleanValue()) {
            filename = this.fileinfo.getMessageId().getValue().replace(':', '_') + "_" + this.fileinfo.getFileName();
            this.fileinfo.setRenamed(true);
            this.fileinfo.setFileName(filename);
        }
        file.createNewFile();
        return filename;
    }

    private boolean isResume(File file, File testfile) {
        boolean resume = false;
        if (file.exists() && testfile.exists()) {
            resume = true;
        }
        return resume;
    }

    private void caculateFileNameLengthAndWriteToFileIfNotResume(String filename, RandomAccessFile recordFile, boolean resume) throws IOException, UnsupportedEncodingException {
        if (resume) {
            byte[] lengthBytes = new byte[4];
            recordFile.read(lengthBytes);
            int length = TlqKnlMessagePropertiesUtil.parseInteger(lengthBytes);
            this.fileNameLength = 4 + length;
        } else {
            String recvFilename = this.recvDir + File.separator + filename;
            byte[] nameBytes = recvFilename.getBytes("UTF-8");
            int byteLength = nameBytes.length;
            this.writeFileNameAndLengthToFile(recordFile, nameBytes, byteLength);
            this.fileNameLength = 4 + byteLength;
        }
    }

    private void writeFileNameAndLengthToFile(RandomAccessFile recordFile, byte[] nameBytes, int byteLength) throws IOException {
        recordFile.write(TlqKnlMessagePropertiesUtil.parseInt(byteLength));
        recordFile.write(nameBytes);
    }

    private String fixFileName() {
        String filename = this.fileinfo.getFileName();
        if (filename.startsWith("\"") && filename.endsWith("\"")) {
            filename = filename.substring(1, filename.length() - 1);
            this.fileinfo.setFileName(filename);
        }
        return filename;
    }
}

