/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient.filemessage;

import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.tmqi.jmsclient.FileMessageStatus;

class FileMessageStatusImpl
implements FileMessageStatus {
    private volatile double snapshot;
    private final double maxValue;
    private final MessageId messageId;
    private volatile boolean isFileTransporting;

    protected FileMessageStatusImpl(double maxValue, MessageId messageId) {
        this.maxValue = maxValue;
        this.messageId = messageId;
        this.isFileTransporting = true;
    }

    protected void updatePercentage(double snapshot) {
        this.snapshot = snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanStatus() {
        this.isFileTransporting = false;
        FileMessageStatusImpl fileMessageStatusImpl = this;
        synchronized (fileMessageStatusImpl) {
            this.notifyAll();
        }
    }

    @Override
    public int getFileProgressPercentage() {
        double result = this.snapshot / this.maxValue;
        return (int)(result * 100.0);
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public boolean isFileTransporting() {
        return this.isFileTransporting;
    }
}

