/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient.filemessage;

import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jms.protocol.TlqRemoteReadWritePacket;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.jmsclient.TlqRemoteReadMessageChannel;
import com.tongtech.jmsclient.filemessage.FileMessageReceiver;
import com.tongtech.jmsclient.filemessage.FileMessageStatusImpl;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.util.TlqKnlMessagePropertiesUtil;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConsumeFileInfoRequest;
import com.tongtech.remote.protocol.command.FileContent;
import com.tongtech.remote.protocol.command.FileInfo;
import com.tongtech.remote.protocol.command.Message;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Observable;
import javax.jms.JMSException;

public class FileReceiveHandler
extends Observable {
    static Logger logger = LoggerFactory.getLogger(FileReceiveHandler.class);
    private RandomAccessFile file;
    private RandomAccessFile recordFile;
    private long startPos;
    private long endPos;
    private FileMessageReceiver receiver;
    private int startPiece;
    private int recordPos = 1;
    private File recFile;
    private int filePos = 0;
    private FileInfo fileInfo;
    private TlqRemoteReadMessageChannel readChannel = null;
    private FileMessageStatusImpl snapshotImpl = null;

    public FileReceiveHandler(FileInfo fileInfo, FileMessageReceiver receiver, File file, long start, long end, int recvPiece, TlqRemoteReadMessageChannel readChannel) {
        this.receiver = receiver;
        this.startPos = start;
        this.endPos = end;
        this.recFile = file;
        this.fileInfo = fileInfo;
        this.readChannel = readChannel;
        this.startPiece = recvPiece;
        this.snapshotImpl = new FileMessageStatusImpl(this.endPos, fileInfo.getMessageId());
        MessageConsumerImpl consumer = (MessageConsumerImpl)receiver.connection.interestTable.getConsumer(new Long(fileInfo.getTargetConsumerId().getValue()));
        consumer.setFileProgressSnapshot(this.snapshotImpl);
    }

    protected void init() throws Exception {
        String filename = this.fileInfo.getFileName();
        this.file = new RandomAccessFile(this.receiver.recvDir + File.separator + filename, "rw");
        this.recordFile = new RandomAccessFile(this.recFile, "rw");
    }

    public void handle(DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler) {
        try {
            this.init();
            this.sendFileReqeust(os, format, handler);
        }
        catch (Exception e) {
            logger.debug("receive file content error :{}", e);
            this.receiver.hasError = true;
        }
    }

    public boolean receiveFileContent(FileContent content) throws IOException {
        boolean finished = false;
        this.file.seek(this.startPos);
        long point = this.file.getFilePointer();
        logger.trace("recv a fileContent :point :{},length:{},pieces :{}", new Object[]{new Long(point), new Integer(content.getFileContent().length), new Integer(content.getPiece())});
        this.file.write(content.getFileContent());
        ++this.filePos;
        this.startPos += (long)content.getFileContent().length;
        this.recordFile(content, this.filePos);
        this.snapshotImpl.updatePercentage(this.startPos);
        if (this.file.getFilePointer() == this.endPos) {
            this.startPos = 0L;
            this.file.close();
            finished = true;
            this.afterReceive();
        }
        return finished;
    }

    private void recordFile(FileContent content, int pos) throws IOException {
        if (pos % this.recordPos == 0) {
            this.recordFile.seek(this.receiver.fileNameLength);
            this.recordFile.write(TlqKnlMessagePropertiesUtil.parseInt(content.getPiece()));
            logger.trace("record picece to threadNum :file :pos :{},{}", new Object[]{new Integer(pos), new Integer(content.getPiece())});
        }
    }

    private void sendFileReqeust(DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler) throws IOException, JMSException {
        ConsumeFileInfoRequest request = new ConsumeFileInfoRequest();
        request.setSeqId(this.receiver.fileinfo.getSeqId());
        request.setConsumerId(this.receiver.fileinfo.getTargetConsumerId());
        request.setStartIndex(this.startPiece);
        handler.sendCommandNoAck(request);
    }

    public void afterReceive() throws IOException {
        if (this.receiver.hasError || this.receiver.connection.isClosed) {
            return;
        }
        TlqRemoteReadWritePacket pkt = FileReceiveHandler.createFileMessage(this.fileInfo, this.receiver);
        try {
            this.readChannel.dispatchFileMessage(pkt);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        finally {
            this.recordFile.close();
            boolean bl = this.recFile.delete();
        }
    }

    public static TlqRemoteReadWritePacket createFileMessage(FileInfo fileInfo, FileMessageReceiver receiver) {
        TlqRemoteReadWritePacket tlqPkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        tlqPkt.setPacketType(7);
        tlqPkt.setMessageID(fileInfo.getMessageId().toString());
        Message msg = new Message();
        msg.setMessageType(7);
        msg.setMessageId(fileInfo.getMessageId());
        msg.setTargetConsumerId(fileInfo.getTargetConsumerId());
        msg.setDestination(fileInfo.getDestination());
        msg.setRecievedByDFBridge(fileInfo.isRenamed());
        msg.setMarshalledProperties(fileInfo.getMarshalledProperties());
        msg.setPropSize(fileInfo.getPropSize());
        msg.setPropNum(fileInfo.getPropNum());
        msg.setUsrContext(fileInfo.getUsrContext());
        msg.setSeqId(fileInfo.getSeqId());
        msg.setPriority(fileInfo.getPriority());
        msg.setPersistent(fileInfo.getPersistent());
        try {
            String content = null;
            content = receiver == null ? fileInfo.getFileName() : receiver.recvDir + File.separator + fileInfo.getFileName();
            msg.setContent(content.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        tlqPkt.setCommand(msg);
        return tlqPkt;
    }
}

