/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.protocol.util;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TlqKnlMessagePropertiesUtil {
    static Logger logger = LoggerFactory.getLogger(TlqKnlMessagePropertiesUtil.class);
    public static final String PROPERTIES_PREFIX = "\u0000TLQ";
    public static final byte[] PROPERTIES_PREFIX_BYTES = "\u0000TLQ".getBytes();
    public static final int PROPERTIES_PREFIX_HEAD_LENGTH = 16;
    public static final int PROPERTIES_PREFIX_INT = TlqKnlMessagePropertiesUtil.parseInteger("\u0000TLQ".getBytes());

    public static Properties getProperties(byte[] propertiesData, int len) {
        Properties properties = new Properties();
        if (null == propertiesData || propertiesData.length < 27) {
            return properties;
        }
        byte[] prefix = new byte[4];
        System.arraycopy(propertiesData, 0, prefix, 0, 4);
        if (TlqKnlMessagePropertiesUtil.parseInteger(prefix) != PROPERTIES_PREFIX_INT) {
            return properties;
        }
        int pos = 16;
        do {
            try {
                byte[] lengthByte = new byte[4];
                System.arraycopy(propertiesData, pos, lengthByte, 0, 4);
                int length = TlqKnlMessagePropertiesUtil.parseInteger(lengthByte);
                byte[] nameByte = new byte[length];
                System.arraycopy(propertiesData, pos += 4, nameByte, 0, length);
                String name = new String(nameByte);
                pos += length;
                byte type = propertiesData[pos++];
                byte[] valueByteLength = new byte[4];
                System.arraycopy(propertiesData, pos, valueByteLength, 0, 4);
                int valueLength = TlqKnlMessagePropertiesUtil.parseInteger(valueByteLength);
                byte[] valueByte = new byte[valueLength];
                System.arraycopy(propertiesData, pos += 4, valueByte, 0, valueLength);
                String value = new String(valueByte);
                pos += valueLength;
                switch (type) {
                    case 83: {
                        String stringValue = new String(value);
                        if (stringValue.equals("true") || stringValue.equals("false")) {
                            properties.put(name, Boolean.valueOf(stringValue));
                            break;
                        }
                        properties.put(name, stringValue);
                        break;
                    }
                    case 73: {
                        properties.put(name, new Integer(value));
                        break;
                    }
                    case 67: {
                        properties.put(name, new Byte(valueByte[0]));
                        break;
                    }
                    case 68: {
                        properties.put(name, new Double(value));
                        break;
                    }
                    case 108: {
                        properties.put(name, new Long(value));
                        break;
                    }
                    case 115: {
                        properties.put(name, new Short(value));
                        break;
                    }
                    case 76: {
                        properties.put(name, new Long(value));
                        break;
                    }
                    case 70: {
                        properties.put(name, new Float(value));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (pos + 1 < len);
        return properties;
    }

    public static int getByte(Map p, byte[] knlByte) {
        System.arraycopy(PROPERTIES_PREFIX_BYTES, 0, knlByte, 0, 4);
        System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(knlByte.length), 0, knlByte, 4, 4);
        int pos = 16;
        Set keys = p.keySet();
        for (String key : keys) {
            byte[] keyByte = key.getBytes();
            int keyLen = keyByte.length;
            Object value = p.get(key);
            byte[] valueByte = value.toString().getBytes();
            int valueLen = valueByte.length;
            if (value instanceof String) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 83;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Integer) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 73;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Boolean) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 83;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Byte) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 67;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Short) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 115;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Long) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 76;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Float) {
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 70;
                System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (!(value instanceof Double)) continue;
            System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, knlByte, pos, 4);
            System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
            knlByte[pos += keyLen] = 68;
            System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, knlByte, ++pos, 4);
            System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
            pos += valueLen;
        }
        knlByte[pos] = 0;
        System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(pos - 16), 0, knlByte, 8, 4);
        System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(p.size()), 0, knlByte, 12, 4);
        return pos;
    }

    public static int getByte(Map p, JMQByteArrayOutputStream os) {
        os.write(PROPERTIES_PREFIX_BYTES, 0, 4);
        os.write(new byte[8], 0, 8);
        os.write(TlqKnlMessagePropertiesUtil.parseInt(p.size()), 0, 4);
        int pos = 16;
        Set keys = p.keySet();
        for (String key : keys) {
            byte[] keyByte = key.getBytes();
            int keyLen = keyByte.length;
            Object value = p.get(key);
            byte[] valueByte = value.toString().getBytes();
            int valueLen = valueByte.length;
            os.write(TlqKnlMessagePropertiesUtil.parseInt(keyLen), 0, 4);
            pos += 4;
            os.write(keyByte, 0, keyLen);
            pos += keyLen;
            if (value instanceof String) {
                os.write(83);
            } else if (value instanceof Integer) {
                os.write(73);
            } else if (value instanceof Boolean) {
                os.write(83);
            } else if (value instanceof Byte) {
                os.write(67);
                byte valueByte1 = (Byte)value;
                valueByte = new byte[]{valueByte1};
                valueLen = valueByte.length;
            } else if (value instanceof Short) {
                os.write(115);
            } else if (value instanceof Long) {
                os.write(76);
            } else if (value instanceof Float) {
                os.write(70);
            } else if (value instanceof Double) {
                os.write(68);
            }
            ++pos;
            os.write(TlqKnlMessagePropertiesUtil.parseInt(valueLen), 0, 4);
            pos += 4;
            os.write(valueByte, 0, valueLen);
            pos += valueLen;
        }
        os.write(0);
        System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(os.getCount()), 0, os.getBuf(), 4, 4);
        System.arraycopy(TlqKnlMessagePropertiesUtil.parseInt(pos - 16), 0, os.getBuf(), 8, 4);
        return pos;
    }

    public static byte[] parseInt(int i) {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static int parseInteger(byte[] b) {
        if (b.length != 4) {
            throw new IllegalArgumentException();
        }
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static void main(String[] argv) {
        int i;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String key = "test";
        Integer value = new Integer(1);
        map.put("JMS_TONG_Encrypted", new Boolean(true));
        map.put("JMS_TONG_Compressed", new Boolean(true));
        byte[] knlByte = new byte[100];
        TlqKnlMessagePropertiesUtil.getByte(map, knlByte);
        for (i = 0; i < 4; ++i) {
            System.out.print(PROPERTIES_PREFIX_BYTES[i] + " ");
        }
        System.out.println();
        for (i = 0; i < 4; ++i) {
            System.out.print(TlqKnlMessagePropertiesUtil.parseInt(100)[i] + " ");
        }
        System.out.println();
        for (i = 0; i < 4; ++i) {
            System.out.print(TlqKnlMessagePropertiesUtil.parseInt(key.length())[i] + " ");
        }
        System.out.println();
        for (i = 0; i < key.length(); ++i) {
            System.out.print(key.getBytes()[i] + " ");
        }
        System.out.println();
        System.out.println(73);
        for (i = 0; i < 4; ++i) {
            System.out.print(TlqKnlMessagePropertiesUtil.parseInt(value.toString().length())[i] + " ");
        }
        System.out.println();
        for (i = 0; i < value.toString().length(); ++i) {
            System.out.print(value.toString().getBytes()[i] + " ");
        }
        System.out.println();
        for (i = 0; i < knlByte.length; ++i) {
            System.out.print(knlByte[i] + " ");
        }
        JMQByteArrayOutputStream os = new JMQByteArrayOutputStream(new byte[30]);
        TlqKnlMessagePropertiesUtil.getByte(map, os);
        System.out.println();
        System.out.println("count:" + os.getCount());
        for (int i2 = 0; i2 < os.getCount(); ++i2) {
            System.out.print(os.getBuf()[i2] + " ");
        }
    }
}

