/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.remote.protocol.command.BaseCommand;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.LongInfo;
import com.tongtech.remote.protocol.command.TransactionId;

public class MessageAck
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 22;
    public static final byte DELIVERED_ACK_TYPE = 0;
    public static final byte STANDARD_ACK_TYPE = 2;
    public static final byte POSION_ACK_TYPE = 1;
    public static final byte REDELIVERED_ACK_TYPE = 3;
    public static final byte INDIVIDUAL_ACK_TYPE = 4;
    protected byte ackType;
    protected ConsumerId consumerId;
    protected TransactionId transactionId;
    protected ConsumerId[] consumerIds;
    protected LongInfo[] seqIds;
    protected transient String consumerKey;

    public ConsumerId[] getConsumerIds() {
        return this.consumerIds;
    }

    public void setConsumerIds(ConsumerId[] consumerIds) {
        this.consumerIds = consumerIds;
    }

    public LongInfo[] getSeqIds() {
        return this.seqIds;
    }

    public void setSeqIds(LongInfo[] seqids) {
        this.seqIds = seqids;
    }

    public void copy(MessageAck copy) {
        super.copy(copy);
        copy.transactionId = this.transactionId;
        copy.ackType = this.ackType;
        copy.consumerId = this.consumerId;
    }

    @Override
    public byte getDataStructureType() {
        return 22;
    }

    @Override
    public boolean isMessageAck() {
        return true;
    }

    public boolean isPoisonAck() {
        return this.ackType == 1;
    }

    public boolean isStandardAck() {
        return this.ackType == 2;
    }

    public boolean isDeliveredAck() {
        return this.ackType == 0;
    }

    public boolean isRedeliveredAck() {
        return this.ackType == 3;
    }

    public boolean isIndividualAck() {
        return this.ackType == 4;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(TransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(ConsumerId consumerId) {
        this.consumerId = consumerId;
    }

    public byte getAckType() {
        return this.ackType;
    }

    public void setAckType(byte ackType) {
        this.ackType = ackType;
    }
}

