/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.command.ProducerInfo;
import com.tongtech.tmqi.util.Hex;
import java.io.UnsupportedEncodingException;

public class MessageId
implements DataStructure,
Comparable {
    static Logger logger = LoggerFactory.getLogger(MessageId.class);
    public static final byte DATA_STRUCTURE_TYPE = 110;
    protected transient ProducerId producerId;
    protected transient long producerSequenceId;
    protected transient long brokerSequenceId;
    protected byte[] byteValue;
    private transient String value;
    private transient String key;
    private transient int hashCode;

    public MessageId() {
        this.producerId = new ProducerId();
    }

    public MessageId(ProducerInfo producerInfo, long producerSequenceId) {
        this.producerId = producerInfo.getProducerId();
        this.producerSequenceId = producerSequenceId;
    }

    public MessageId(String messageKey) {
        this.setValue(messageKey);
    }

    public MessageId(String producerId, long producerSequenceId) {
        this(new ProducerId(producerId), producerSequenceId);
    }

    public MessageId(ProducerId producerId, long producerSequenceId) {
        this.producerId = producerId;
        this.producerSequenceId = producerSequenceId;
    }

    private void setValue(String messageKey) {
        if (messageKey.startsWith("__TONGTECH__") && messageKey.endsWith("__:ID:__")) {
            String encoderStr = messageKey.substring("__TONGTECH__".length(), messageKey.length() - "__:ID:__".length());
            if (logger.isDebugEnabled()) {
                logger.debug("IBMMQ ackMsg: {}", (Object)encoderStr);
            }
            this.byteValue = Hex.decodeHex(encoderStr.toCharArray());
        } else {
            try {
                if (messageKey != null) {
                    int len = 32;
                    if (messageKey.getBytes("UTF-8").length < len) {
                        len = messageKey.getBytes("UTF-8").length;
                    }
                    this.byteValue = new byte[len];
                    System.arraycopy(messageKey.getBytes("UTF-8"), 0, this.byteValue, 0, len);
                }
            }
            catch (UnsupportedEncodingException ex) {
                logger.error("", ex);
            }
        }
        this.value = messageKey;
    }

    public void setTextView(String key) {
        this.key = key;
    }

    @Override
    public byte getDataStructureType() {
        return 110;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MessageId id = (MessageId)o;
        return this.getValue().equals(id.getValue());
    }

    public int hashCode() {
        this.hashCode = this.getValue().hashCode();
        return this.hashCode;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.producerId.toString() + ":" + this.producerSequenceId;
        }
        return this.key;
    }

    public String toString() {
        return this.getValue();
    }

    public ProducerId getProducerId() {
        return this.producerId;
    }

    public void setProducerId(ProducerId producerId) {
        this.producerId = producerId;
    }

    public long getProducerSequenceId() {
        return this.producerSequenceId;
    }

    public void setProducerSequenceId(long producerSequenceId) {
        this.producerSequenceId = producerSequenceId;
    }

    public long getBrokerSequenceId() {
        return this.brokerSequenceId;
    }

    public void setBrokerSequenceId(long brokerSequenceId) {
        this.brokerSequenceId = brokerSequenceId;
    }

    @Override
    public boolean isMarshallAware() {
        return false;
    }

    public MessageId copy() {
        MessageId copy = new MessageId(this.producerId, this.producerSequenceId);
        copy.key = this.key;
        copy.brokerSequenceId = this.brokerSequenceId;
        return copy;
    }

    public int compareTo(Object other) {
        int result = -1;
        if (other != null) {
            result = this.toString().compareTo(other.toString());
        }
        return result;
    }

    public String getValue() {
        if (this.value == null || this.value.equals("")) {
            String temp = null;
            try {
                String msgid = new String(this.byteValue, 0, 32, "UTF-8");
                if (msgid.startsWith("ID:")) {
                    temp = msgid;
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append("__TONGTECH__");
                    sb.append(new String(Hex.encodeHex(this.byteValue)));
                    sb.append("__:ID:__");
                    temp = sb.toString();
                    if (logger.isDebugEnabled()) {
                        logger.debug("after encoder, from IBMMQ. {}", (Object)sb.toString());
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error("messageID endcode error ", e);
            }
            this.value = temp;
            return temp;
        }
        return this.value;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public void setByteValue(byte[] byteValue) {
        this.byteValue = byteValue;
    }
}

