/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.BaseMessage;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class BaseMessageMarshaller
extends BaseCommandMarshaller {
    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        BaseMessage info = (BaseMessage)o;
        info.setBrowseLast(bs.readBoolean());
        info.setMsgSeq(dataIn.readInt());
        info.setMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info.setLast(bs.readBoolean());
        info.setProducerId((ProducerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((Destination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setSeqId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setTargetConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        BaseMessage info = (BaseMessage)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info.isBrowseLast());
        rc += this.tightMarshalNestedObject1(wireFormat, info.getMessageId(), bs);
        bs.writeBoolean(info.isLast());
        rc += this.tightMarshalCachedObject1(wireFormat, info.getProducerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getDestination(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getSeqId(), bs);
        return (rc += this.tightMarshalCachedObject1(wireFormat, info.getTargetConsumerId(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        BaseMessage info = (BaseMessage)o;
        bs.readBoolean();
        dataOut.writeInt(info.getMsgSeq());
        this.tightMarshalNestedObject2(wireFormat, info.getMessageId(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalCachedObject2(wireFormat, info.getProducerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getDestination(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getSeqId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getTargetConsumerId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        BaseMessage info = (BaseMessage)o;
        info.setBrowseLast(dataIn.readBoolean());
        info.setMsgSeq(dataIn.readInt());
        info.setMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info.setLast(dataIn.readBoolean());
        info.setProducerId((ProducerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setDestination((Destination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setSeqId(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setTargetConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        BaseMessage info = (BaseMessage)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeBoolean(info.isBrowseLast());
        dataOut.writeInt(info.getMsgSeq());
        this.looseMarshalNestedObject(wireFormat, info.getMessageId(), dataOut);
        dataOut.writeBoolean(info.isLast());
        this.looseMarshalCachedObject(wireFormat, info.getProducerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getDestination(), dataOut);
        this.looseMarshalLong(wireFormat, info.getSeqId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getTargetConsumerId(), dataOut);
    }
}

