/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConnectionId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.DestinationInfo;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DestinationInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 8;
    }

    @Override
    public DataStructure createObject() {
        return new DestinationInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        DestinationInfo info = (DestinationInfo)o;
        info.setConnectionId((ConnectionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((Destination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setOperationType(dataIn.readByte());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        DestinationInfo info = (DestinationInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getConnectionId(), bs);
        return (rc += this.tightMarshalCachedObject1(wireFormat, info.getDestination(), bs)) + 1;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        DestinationInfo info = (DestinationInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info.getConnectionId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getDestination(), dataOut, bs);
        dataOut.writeByte(info.getOperationType());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        DestinationInfo info = (DestinationInfo)o;
        info.setConnectionId((ConnectionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setDestination((Destination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setOperationType(dataIn.readByte());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        DestinationInfo info = (DestinationInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getConnectionId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getDestination(), dataOut);
        dataOut.writeByte(info.getOperationType());
    }
}

