/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.FileContent;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FileContentMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 83;
    }

    @Override
    public DataStructure createObject() {
        return new FileContent();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        FileContent info = (FileContent)o;
        info.setSeqId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setMessageId((MessageId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setProducerId((ProducerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setPiece(dataIn.readInt());
        info.tightUnMarshalBaseMessageFileContentUserDef(info, dataIn, bs);
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        FileContent info = (FileContent)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalLong1(wireFormat, info.getSeqId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getMessageId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getConsumerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getProducerId(), bs);
        return (rc += this.tightMarshalByteArray1(info.getFileContent(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        FileContent info = (FileContent)o;
        this.tightMarshalLong2(wireFormat, info.getSeqId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getMessageId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getConsumerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getProducerId(), dataOut, bs);
        dataOut.writeInt(info.getPiece());
        info.tightMarshalBaseMessageFileContentUserDef(info, dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        FileContent info = (FileContent)o;
        info.setSeqId(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setMessageId((MessageId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setProducerId((ProducerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setPiece(dataIn.readInt());
        info.looseUnMarshalBaseMessageFileContentUserDef(info, dataIn);
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        FileContent info = (FileContent)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalLong(wireFormat, info.getSeqId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getMessageId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getConsumerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getProducerId(), dataOut);
        dataOut.writeInt(info.getPiece());
        info.looseMarshalBaseMessageFileContentUserDef(wireFormat, info, dataOut);
    }
}

