/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.FileInfo;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FileInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 82;
    }

    @Override
    public DataStructure createObject() {
        return new FileInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        FileInfo info = (FileInfo)o;
        info.setSeqId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setProducerId((ProducerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((Destination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setTargetConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setMessageId((MessageId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setFileName(this.tightUnmarshalString(dataIn, bs));
        info.setLast(bs.readBoolean());
        info.setMarshalledProperties(this.tightUnmarshalByteArray(dataIn, bs));
        info.setTransactionId((TransactionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setExpiration(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setTimestamp(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setCorrelationId(this.tightUnmarshalString(dataIn, bs));
        info.setReplyTo((Destination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setPersistent(bs.readBoolean());
        info.setType(this.tightUnmarshalString(dataIn, bs));
        info.setPriority(dataIn.readByte());
        info.setGroupID(this.tightUnmarshalString(dataIn, bs));
        info.setGroupSequence(dataIn.readInt());
        info.setCompressed(bs.readBoolean());
        info.setUserID(this.tightUnmarshalString(dataIn, bs));
        info.setRedeliveryCounter(dataIn.readInt());
        info.setFileSize(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setPropSize(dataIn.readInt());
        info.setPieceSize(dataIn.readInt());
        info.setResume(bs.readBoolean());
        info.setPropNum(dataIn.readInt());
        info.setRenamed(bs.readBoolean());
        info.setSeq(dataIn.readInt());
        info.setUsrContext(this.tightUnmarshalByteArray(dataIn, bs));
        info.setMsgIdx(dataIn.readInt());
        info.setFlag(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        FileInfo info = (FileInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalLong1(wireFormat, info.getSeqId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getProducerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getDestination(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTargetConsumerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getMessageId(), bs);
        rc += this.tightMarshalString1(info.getFileName(), bs);
        bs.writeBoolean(info.isLast());
        rc += this.tightMarshalByteArray1(info.getMarshalledProperties(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTransactionId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getExpiration(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getTimestamp(), bs);
        rc += this.tightMarshalString1(info.getCorrelationId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getReplyTo(), bs);
        bs.writeBoolean(info.isPersistent());
        rc += this.tightMarshalString1(info.getType(), bs);
        rc += this.tightMarshalString1(info.getGroupID(), bs);
        bs.writeBoolean(info.isCompressed());
        rc += this.tightMarshalString1(info.getUserID(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getFileSize(), bs);
        bs.writeBoolean(info.isResume());
        bs.writeBoolean(info.isRenamed());
        return (rc += this.tightMarshalByteArray1(info.getUsrContext(), bs)) + 33;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        FileInfo info = (FileInfo)o;
        this.tightMarshalLong2(wireFormat, info.getSeqId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getProducerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getDestination(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getTargetConsumerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getMessageId(), dataOut, bs);
        this.tightMarshalString2(info.getFileName(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalByteArray2(info.getMarshalledProperties(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getTransactionId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getExpiration(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getTimestamp(), dataOut, bs);
        this.tightMarshalString2(info.getCorrelationId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getReplyTo(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalString2(info.getType(), dataOut, bs);
        dataOut.writeByte(info.getPriority());
        this.tightMarshalString2(info.getGroupID(), dataOut, bs);
        dataOut.writeInt(info.getGroupSequence());
        bs.readBoolean();
        this.tightMarshalString2(info.getUserID(), dataOut, bs);
        dataOut.writeInt(info.getRedeliveryCounter());
        this.tightMarshalLong2(wireFormat, info.getFileSize(), dataOut, bs);
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getPieceSize());
        bs.readBoolean();
        dataOut.writeInt(info.getPropNum());
        bs.readBoolean();
        dataOut.writeInt(info.getSeq());
        this.tightMarshalByteArray2(info.getUsrContext(), dataOut, bs);
        dataOut.writeInt(info.getMsgIdx());
        dataOut.writeInt(info.getFlag());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        FileInfo info = (FileInfo)o;
        info.setSeqId(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setProducerId((ProducerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setDestination((Destination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setTargetConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setMessageId((MessageId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setFileName(this.looseUnmarshalString(dataIn));
        info.setLast(dataIn.readBoolean());
        info.setMarshalledProperties(this.looseUnmarshalByteArray(dataIn));
        info.setTransactionId((TransactionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setExpiration(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setTimestamp(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setCorrelationId(this.looseUnmarshalString(dataIn));
        info.setReplyTo((Destination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setPersistent(dataIn.readBoolean());
        info.setType(this.looseUnmarshalString(dataIn));
        info.setPriority(dataIn.readByte());
        info.setGroupID(this.looseUnmarshalString(dataIn));
        info.setGroupSequence(dataIn.readInt());
        info.setCompressed(dataIn.readBoolean());
        info.setUserID(this.looseUnmarshalString(dataIn));
        info.setRedeliveryCounter(dataIn.readInt());
        info.setFileSize(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setPropSize(dataIn.readInt());
        info.setPieceSize(dataIn.readInt());
        info.setResume(dataIn.readBoolean());
        info.setPropNum(dataIn.readInt());
        info.setRenamed(dataIn.readBoolean());
        info.setSeq(dataIn.readInt());
        info.setUsrContext(this.looseUnmarshalByteArray(dataIn));
        info.setMsgIdx(dataIn.readInt());
        info.setFlag(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        FileInfo info = (FileInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalLong(wireFormat, info.getSeqId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getProducerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getDestination(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getTargetConsumerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getMessageId(), dataOut);
        this.looseMarshalString(info.getFileName(), dataOut);
        dataOut.writeBoolean(info.isLast());
        this.looseMarshalByteArray(wireFormat, info.getMarshalledProperties(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getTransactionId(), dataOut);
        this.looseMarshalLong(wireFormat, info.getExpiration(), dataOut);
        this.looseMarshalLong(wireFormat, info.getTimestamp(), dataOut);
        this.looseMarshalString(info.getCorrelationId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getReplyTo(), dataOut);
        dataOut.writeBoolean(info.isPersistent());
        this.looseMarshalString(info.getType(), dataOut);
        dataOut.writeByte(info.getPriority());
        this.looseMarshalString(info.getGroupID(), dataOut);
        dataOut.writeInt(info.getGroupSequence());
        dataOut.writeBoolean(info.isCompressed());
        this.looseMarshalString(info.getUserID(), dataOut);
        dataOut.writeInt(info.getRedeliveryCounter());
        this.looseMarshalLong(wireFormat, info.getFileSize(), dataOut);
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getPieceSize());
        dataOut.writeBoolean(info.isResume());
        dataOut.writeInt(info.getPropNum());
        dataOut.writeBoolean(info.isRenamed());
        dataOut.writeInt(info.getSeq());
        this.looseMarshalByteArray(wireFormat, info.getUsrContext(), dataOut);
        dataOut.writeInt(info.getMsgIdx());
        dataOut.writeInt(info.getFlag());
    }
}

