/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.JndiRequest;
import com.tongtech.remote.protocol.v3.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JndiRequestMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 80;
    }

    @Override
    public DataStructure createObject() {
        return new JndiRequest();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        JndiRequest info = (JndiRequest)o;
        info.setVersion(dataIn.readInt());
        info.setRequestType(dataIn.readInt());
        info.setRequestInfo(this.tightUnmarshalString(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        JndiRequest info = (JndiRequest)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalString1(info.getRequestInfo(), bs)) + 8;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        JndiRequest info = (JndiRequest)o;
        dataOut.writeInt(info.getVersion());
        dataOut.writeInt(info.getRequestType());
        this.tightMarshalString2(info.getRequestInfo(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        JndiRequest info = (JndiRequest)o;
        info.setVersion(dataIn.readInt());
        info.setRequestType(dataIn.readInt());
        info.setRequestInfo(this.looseUnmarshalString(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        JndiRequest info = (JndiRequest)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getVersion());
        dataOut.writeInt(info.getRequestType());
        this.looseMarshalString(info.getRequestInfo(), dataOut);
    }
}

