/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConnectionId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.LocalTransactionId;
import com.tongtech.remote.protocol.v3.TransactionIdMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalTransactionIdMarshaller
extends TransactionIdMarshaller {
    @Override
    public byte getDataStructureType() {
        return 111;
    }

    @Override
    public DataStructure createObject() {
        return new LocalTransactionId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        LocalTransactionId info = (LocalTransactionId)o;
        info.setValue(dataIn.readInt());
        info.setConnectionId((ConnectionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        LocalTransactionId info = (LocalTransactionId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalCachedObject1(wireFormat, info.getConnectionId(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        LocalTransactionId info = (LocalTransactionId)o;
        dataOut.writeInt(info.getValue());
        this.tightMarshalCachedObject2(wireFormat, info.getConnectionId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        LocalTransactionId info = (LocalTransactionId)o;
        info.setValue(dataIn.readInt());
        info.setConnectionId((ConnectionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        LocalTransactionId info = (LocalTransactionId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getValue());
        this.looseMarshalCachedObject(wireFormat, info.getConnectionId(), dataOut);
    }
}

