/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.Message;
import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.remote.protocol.v3.BaseMessageMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessageMarshaller
extends BaseMessageMarshaller {
    @Override
    public byte getDataStructureType() {
        return 23;
    }

    @Override
    public DataStructure createObject() {
        return new Message();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        Message info = (Message)o;
        info.setMsgSize(dataIn.readInt());
        info.setPropSize(dataIn.readInt());
        info.setMessageType(dataIn.readInt());
        info.setPropNum(dataIn.readInt());
        info.setTransactionId((TransactionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setGroupID(this.tightUnmarshalString(dataIn, bs));
        info.setGroupSequence(dataIn.readInt());
        info.setCorrelationId(this.tightUnmarshalString(dataIn, bs));
        info.setPersistent(bs.readBoolean());
        info.setExpiration(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setPriority(dataIn.readByte());
        info.setReplyTo((Destination)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info.setTimestamp(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setCompressed(bs.readBoolean());
        info.setRedeliveryCounter(dataIn.readInt());
        info.setUsrContext(this.tightUnmarshalByteArray(dataIn, bs));
        info.tightUnMarshalBaseMessagePropertiesUserDef(info, dataIn, bs);
        info.tightUnMarshalBaseMessageContentUserDef(info, dataIn, bs);
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Message info = (Message)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTransactionId(), bs);
        rc += this.tightMarshalString1(info.getGroupID(), bs);
        rc += this.tightMarshalString1(info.getCorrelationId(), bs);
        bs.writeBoolean(info.isPersistent());
        rc += this.tightMarshalLong1(wireFormat, info.getExpiration(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info.getReplyTo(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getTimestamp(), bs);
        bs.writeBoolean(info.isCompressed());
        rc += this.tightMarshalByteArray1(info.getUsrContext(), bs);
        rc += this.tightMarshalByteArray1(info.getMarshalledProperties(), bs);
        return (rc += this.tightMarshalByteArray1(info.getContent(), bs)) + 25;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        Message info = (Message)o;
        dataOut.writeInt(info.getMsgSize());
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getMessageType());
        dataOut.writeInt(info.getPropNum());
        this.tightMarshalCachedObject2(wireFormat, info.getTransactionId(), dataOut, bs);
        this.tightMarshalString2(info.getGroupID(), dataOut, bs);
        dataOut.writeInt(info.getGroupSequence());
        this.tightMarshalString2(info.getCorrelationId(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalLong2(wireFormat, info.getExpiration(), dataOut, bs);
        dataOut.writeByte(info.getPriority());
        this.tightMarshalNestedObject2(wireFormat, info.getReplyTo(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getTimestamp(), dataOut, bs);
        bs.readBoolean();
        dataOut.writeInt(info.getRedeliveryCounter());
        this.tightMarshalByteArray2(info.getUsrContext(), dataOut, bs);
        info.tightMarshalBaseMessagePropertiesUserDef(info, dataOut, bs);
        info.tightMarshalBaseMessageContentUserDef(info, dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        Message info = (Message)o;
        info.setMsgSize(dataIn.readInt());
        info.setPropSize(dataIn.readInt());
        info.setMessageType(dataIn.readInt());
        info.setPropNum(dataIn.readInt());
        info.setTransactionId((TransactionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setGroupID(this.looseUnmarshalString(dataIn));
        info.setGroupSequence(dataIn.readInt());
        info.setCorrelationId(this.looseUnmarshalString(dataIn));
        info.setPersistent(dataIn.readBoolean());
        info.setExpiration(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setPriority(dataIn.readByte());
        info.setReplyTo((Destination)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info.setTimestamp(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setCompressed(dataIn.readBoolean());
        info.setRedeliveryCounter(dataIn.readInt());
        info.setUsrContext(this.looseUnmarshalByteArray(dataIn));
        info.looseUnMarshalBaseMessagePropertiesUserDef(info, dataIn);
        info.looseUnMarshalBaseMessageContentUserDef(info, dataIn);
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        Message info = (Message)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getMsgSize());
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getMessageType());
        dataOut.writeInt(info.getPropNum());
        this.looseMarshalCachedObject(wireFormat, info.getTransactionId(), dataOut);
        this.looseMarshalString(info.getGroupID(), dataOut);
        dataOut.writeInt(info.getGroupSequence());
        this.looseMarshalString(info.getCorrelationId(), dataOut);
        dataOut.writeBoolean(info.isPersistent());
        this.looseMarshalLong(wireFormat, info.getExpiration(), dataOut);
        dataOut.writeByte(info.getPriority());
        this.looseMarshalNestedObject(wireFormat, info.getReplyTo(), dataOut);
        this.looseMarshalLong(wireFormat, info.getTimestamp(), dataOut);
        dataOut.writeBoolean(info.isCompressed());
        dataOut.writeInt(info.getRedeliveryCounter());
        this.looseMarshalByteArray(wireFormat, info.getUsrContext(), dataOut);
        info.looseMarshalBaseMessagePropertiesUserDef(wireFormat, info, dataOut);
        info.looseMarshalBaseMessageContentUserDef(wireFormat, info, dataOut);
    }
}

