/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.MonitorInfo;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MonitorInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 87;
    }

    @Override
    public DataStructure createObject() {
        return new MonitorInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MonitorInfo info = (MonitorInfo)o;
        info.setMonitorType(dataIn.readInt());
        info.setMonitorObjectID(this.tightUnmarshalString(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MonitorInfo info = (MonitorInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalString1(info.getMonitorObjectID(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MonitorInfo info = (MonitorInfo)o;
        dataOut.writeInt(info.getMonitorType());
        this.tightMarshalString2(info.getMonitorObjectID(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MonitorInfo info = (MonitorInfo)o;
        info.setMonitorType(dataIn.readInt());
        info.setMonitorObjectID(this.looseUnmarshalString(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MonitorInfo info = (MonitorInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getMonitorType());
        this.looseMarshalString(info.getMonitorObjectID(), dataOut);
    }
}

