/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.PartialMessageAck;
import com.tongtech.remote.protocol.v3.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PartialMessageAckMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 125;
    }

    @Override
    public DataStructure createObject() {
        return new PartialMessageAck();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        PartialMessageAck info = (PartialMessageAck)o;
        info.setStatusCode(dataIn.readInt());
        info.setReason(this.tightUnmarshalString(dataIn, bs));
        info.setMsgSeq(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        PartialMessageAck info = (PartialMessageAck)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalString1(info.getReason(), bs)) + 8;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        PartialMessageAck info = (PartialMessageAck)o;
        dataOut.writeInt(info.getStatusCode());
        this.tightMarshalString2(info.getReason(), dataOut, bs);
        dataOut.writeInt(info.getMsgSeq());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        PartialMessageAck info = (PartialMessageAck)o;
        info.setStatusCode(dataIn.readInt());
        info.setReason(this.looseUnmarshalString(dataIn));
        info.setMsgSeq(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        PartialMessageAck info = (PartialMessageAck)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getStatusCode());
        this.looseMarshalString(info.getReason(), dataOut);
        dataOut.writeInt(info.getMsgSeq());
    }
}

