/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.v3.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProducerIdMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 123;
    }

    @Override
    public DataStructure createObject() {
        return new ProducerId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ProducerId info = (ProducerId)o;
        info.setConnectionId(dataIn.readShort());
        info.setSessionId(dataIn.readInt());
        info.setValue(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ProducerId info = (ProducerId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return rc + 10;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ProducerId info = (ProducerId)o;
        dataOut.writeShort(info.getConnectionId());
        dataOut.writeInt(info.getSessionId());
        dataOut.writeInt(info.getValue());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ProducerId info = (ProducerId)o;
        info.setConnectionId(dataIn.readShort());
        info.setSessionId(dataIn.readInt());
        info.setValue(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ProducerId info = (ProducerId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeShort(info.getConnectionId());
        dataOut.writeInt(info.getSessionId());
        dataOut.writeInt(info.getValue());
    }
}

