/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.SessionId;
import com.tongtech.remote.protocol.v3.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SessionIdMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 121;
    }

    @Override
    public DataStructure createObject() {
        return new SessionId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        SessionId info = (SessionId)o;
        info.setConnectionId(dataIn.readShort());
        info.setValue(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        SessionId info = (SessionId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return rc + 6;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        SessionId info = (SessionId)o;
        dataOut.writeShort(info.getConnectionId());
        dataOut.writeInt(info.getValue());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        SessionId info = (SessionId)o;
        info.setConnectionId(dataIn.readShort());
        info.setValue(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        SessionId info = (SessionId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeShort(info.getConnectionId());
        dataOut.writeInt(info.getValue());
    }
}

