/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.WireFormatInfo;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WireFormatInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 1;
    }

    @Override
    public DataStructure createObject() {
        return new WireFormatInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        WireFormatInfo info = (WireFormatInfo)o;
        info.setMagic(this.tightUnmarshalConstByteArray(dataIn, bs, 8));
        info.setVersion(dataIn.readInt());
        info.setLocalFile(bs.readBoolean());
        info.setRsrv(this.tightUnmarshalByteArray(dataIn, bs));
        info.setEndian(dataIn.readByte());
        info.setType(dataIn.readByte());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        WireFormatInfo info = (WireFormatInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalConstByteArray1(info.getMagic(), bs, 8);
        bs.writeBoolean(info.isLocalFile());
        return (rc += this.tightMarshalByteArray1(info.getRsrv(), bs)) + 6;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        WireFormatInfo info = (WireFormatInfo)o;
        this.tightMarshalConstByteArray2(info.getMagic(), dataOut, bs, 8);
        dataOut.writeInt(info.getVersion());
        bs.readBoolean();
        this.tightMarshalByteArray2(info.getRsrv(), dataOut, bs);
        dataOut.writeByte(info.getEndian());
        dataOut.writeByte(info.getType());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        WireFormatInfo info = (WireFormatInfo)o;
        info.setMagic(this.looseUnmarshalConstByteArray(dataIn, 8));
        info.setVersion(dataIn.readInt());
        info.setLocalFile(dataIn.readBoolean());
        info.setRsrv(this.looseUnmarshalByteArray(dataIn));
        info.setEndian(dataIn.readByte());
        info.setType(dataIn.readByte());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        WireFormatInfo info = (WireFormatInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalConstByteArray(wireFormat, info.getMagic(), dataOut, 8);
        dataOut.writeInt(info.getVersion());
        dataOut.writeBoolean(info.isLocalFile());
        this.looseMarshalByteArray(wireFormat, info.getRsrv(), dataOut);
        dataOut.writeByte(info.getEndian());
        dataOut.writeByte(info.getType());
    }
}

