/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.basement;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tlq.base.jcrycomp;
import com.tongtech.tlq.basement.KnlMessageProperties;
import com.tongtech.tlq.basement.TlqException;
import com.tongtech.tmqi.TlqJmsConfiguration;
import java.util.Hashtable;
import java.util.Properties;

public class TlqMessage {
    private static Logger logger = LoggerFactory.getLogger(TlqMessage.class);
    public static final int MESSAGEID_LEN = 33;
    public static final int TLQPER_Y = 1;
    public static final int TLQPER_N = 0;
    public static final int TLQPER_AS_QUEDEF = -1;
    public static final int TLQPRI_NORMAL = 4;
    public static final int TLQPRI_LOW = 0;
    public static final int TLQPRI_MID = 4;
    public static final int TLQPRI_HIGH = 9;
    public static final int TLQORIGIN_AP = 0;
    public static final int TLQORIGIN_JMS = 1;
    public static final int TLQORIGIN_THINCLI = 2;
    public static final int TLQOPER_COMPRESS = 1;
    public static final int TLQOPER_EXIT = 2;
    public static final int BUF_MSG = 0;
    public static final int FILE_MSG = 1;
    public static final int EVENT_MSG = 2;
    public static final int TRIGGER_MSG = 3;
    public static final int TLQGROUP_NOTIN = 0;
    public static final int TLQGROUP_IN = 1;
    public static final int TLQGROUP_LAST = 2;
    public static final int TLQVER_0 = 0;
    public static final int TLQVER_7 = 7;
    public static final String JMS_TLQ_Encrypted = "JMS_TONG_Encrypted";
    public static final String JMS_TLQ_Compressed = "JMS_TONG_Compressed";
    public static final int TLQ_QUEUE_FLAG = 0;
    public static final int TLQ_TOPIC_FLAG = 1;
    public char VerNo = (char)7;
    public char MsgType = '\u0000';
    private byte[] UsrContext = new byte[65];
    public char MsgOperateType;
    public String FileSize = "0";
    public String Reserve = "";
    public short OffSet = 0;
    protected byte[] MsgId = null;
    protected byte[] CorrMsgId = null;
    public int MsgSize = 0;
    public char Persistence = '\u0001';
    public int Expiry = -1;
    public char Priority = (char)4;
    public byte[] MsgOperateInfo;
    public int RollbackCount = 0;
    public String SrcNode = "";
    public int PutDateTime = 0;
    public String DestQName;
    public String GroupID = "";
    public int GroupSeq = 0;
    public char GroupStatus = '\u0000';
    public char MsgOrigin = '\u0000';
    public int OrgMsgLen = 0;
    public int EvTime = 0;
    public int EvStyle = 0;
    protected int UserPropertyLen = 0;
    protected int UserPropertyNum = 0;
    protected Hashtable properties;
    protected byte[] propStr;
    protected byte[] data;
    public char SubFlag = '\u0000';
    public char RenamedFlag = '\u0000';
    public byte[] CryptCompFlag = new byte[2];
    public static int TLQDECRYPTDECOMP = 0;
    public static int TLQENCRYPT = 1;
    public static int TLQCOMP = 2;
    public static int TLQENCRYPTCOMP = 3;
    public static int TLQCOMPENCRYPT = 4;
    private static final int DEFAULT_PROP_LIMIT = 5120;
    private static int PROP_LIMIT = 5120;
    private jcrycomp cc = null;
    public static final String PROPERTIES_PREFIX = "\u0000TLQ";
    public static final byte[] PROPERTIES_PREFIX_BYTES;
    public static final int PROPERTIES_PREFIX_HEAD_LENGTH = 16;
    public static final int PROPERTIES_PREFIX_INT;

    public TlqMessage() {
        int i;
        this.properties = new Properties();
        this.MsgId = new byte[33];
        for (i = 0; i < 33; ++i) {
            this.MsgId[i] = 0;
        }
        this.CorrMsgId = new byte[33];
        for (i = 0; i < 33; ++i) {
            this.CorrMsgId[i] = 0;
        }
    }

    public void setUsrContext(byte[] b) throws IllegalArgumentException {
        if (b.length > 64) {
            throw new IllegalArgumentException("size of UsrContext <=64 ");
        }
        System.arraycopy(b, 0, this.UsrContext, 0, b.length);
        this.UsrContext[b.length + 1] = 0;
    }

    public byte[] getUsrContext() {
        int i = 0;
        for (i = 0; i < this.UsrContext.length && this.UsrContext[i] != 0; ++i) {
        }
        byte[] b = new byte[i];
        System.arraycopy(this.UsrContext, 0, b, 0, i);
        return b;
    }

    public void setIntProperty(String propName, int value) {
        this.properties.put(propName, new Integer(value));
    }

    public void setBooleanProperty(String propName, boolean value) {
        this.properties.put(propName, new Boolean(value));
    }

    public void setStringProperty(String propName, String value) {
        if (value != null) {
            this.properties.put(propName, value);
        }
    }

    public void setByteProperty(String propName, byte value) {
        this.properties.put(propName, new Byte(value));
    }

    public int getIntProperty(String propName) {
        Integer value = (Integer)this.properties.get(propName);
        if (null == value) {
            return 0;
        }
        return value;
    }

    public String getStringProperty(String propName) {
        return (String)this.properties.get(propName);
    }

    public byte getByteProperty(String propName) {
        return (Byte)this.properties.get(propName);
    }

    public boolean getBooleanProperty(String propName) {
        Object o = this.properties.get(propName);
        if (null == o) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        return false;
    }

    public int getPropertyNum() {
        return this.UserPropertyNum;
    }

    public void setMsgData(byte[] value) {
        this.data = value;
    }

    public synchronized void pack() throws TlqException {
        int res;
        boolean Encrypted = this.getBooleanProperty(JMS_TLQ_Encrypted);
        boolean Compressed = this.getBooleanProperty(JMS_TLQ_Compressed);
        int len = -1;
        if (null != this.data && 0 == this.data.length) {
            return;
        }
        if (Compressed) {
            if (null == this.cc) {
                this.cc = new jcrycomp();
            }
            if (this.MsgType == '\u0001') {
                res = this.cc.TCompFile(this);
                if (res < 0) {
                    throw new TlqException("Pack file fail,please check input file name");
                }
            } else {
                len = this.cc.TCompData(this);
                if (len < 0) {
                    throw new TlqException("Pack data fail");
                }
            }
        }
        if (Encrypted) {
            if (null == this.cc) {
                this.cc = new jcrycomp();
            }
            if (this.MsgType == '\u0001') {
                res = this.cc.TEncryptFile(this);
                if (res < 0) {
                    throw new TlqException("Pack file fail,please check input file name");
                }
                this.MsgSize = this.data.length;
            } else {
                len = this.cc.TEncryptData(this);
                if (len < 0) {
                    throw new TlqException("Pack data fail");
                }
            }
        }
    }

    public synchronized void unpack() throws TlqException {
        if (null != this.data && 0 == this.data.length) {
            return;
        }
        while (this.CryptCompFlag[0] != TLQDECRYPTDECOMP) {
            int res = -1;
            if (this.CryptCompFlag[0] == TLQENCRYPT || this.CryptCompFlag[0] == TLQCOMPENCRYPT) {
                if (null == this.cc) {
                    this.cc = new jcrycomp();
                }
                if (this.MsgType == '\u0001') {
                    res = this.cc.TDecryptFile(this);
                    if (res < 0) {
                        throw new TlqException("Unpack file fail");
                    }
                } else {
                    res = this.cc.TDecryptData(this);
                    if (res < 0) {
                        throw new TlqException("Unpack data fail");
                    }
                }
            }
            if (this.CryptCompFlag[0] != TLQCOMP && this.CryptCompFlag[0] != TLQENCRYPTCOMP) continue;
            if (null == this.cc) {
                this.cc = new jcrycomp();
            }
            if (!(this.MsgType == '\u0001' ? (res = this.cc.TDeCompFile(this)) < 0 : (res = this.cc.TDeCompData(this)) < 0)) continue;
            throw new TlqException("Unpack data fail");
        }
    }

    public byte[] getMsgData() {
        return this.data;
    }

    public void setProperties(byte[] value) {
        this.propStr = value;
    }

    public byte[] getProperties() {
        return this.propStr;
    }

    public void parsePropertiesByte() {
        if (null == this.propStr) {
            this.propStr = new byte[PROP_LIMIT];
        }
        int len = KnlMessageProperties.getByte(this.properties, this.propStr);
        this.UserPropertyLen = len - 16;
        this.UserPropertyNum = this.getPropProperties().size();
    }

    public Hashtable getPropProperties() {
        return this.properties;
    }

    public void parseProperties() {
        this.properties = KnlMessageProperties.getProperties(this.propStr, this.UserPropertyLen);
    }

    static {
        try {
            PROP_LIMIT = Integer.parseInt(TlqJmsConfiguration.getInstance().getProperty("tmqiPropertyLimitMax"));
            logger.trace("load property max from file {}", PROP_LIMIT);
            if (PROP_LIMIT < 0) {
                PROP_LIMIT = 5120;
            }
        }
        catch (Exception e) {
            PROP_LIMIT = 5120;
        }
        PROPERTIES_PREFIX_BYTES = PROPERTIES_PREFIX.getBytes();
        PROPERTIES_PREFIX_INT = KnlMessageProperties.parseInteger(PROPERTIES_PREFIX.getBytes());
    }
}

