/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi;

import com.tongtech.jms.ConnectionFactory;
import com.tongtech.jms.JMSException;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.UnifiedConnectionImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Properties;
import javax.jms.Connection;
import tongtech.jms.jndi.Env;

public class BasicConnectionFactory
extends AdministeredObject
implements javax.jms.ConnectionFactory,
ConnectionFactory {
    private static final String defaultsBase = "ConnectionFactory";
    private static final String DEFAULT_I_CONNECTION_HANDLER = "com.tongtech.tmqi.jmsclient.protocol.tcp.TCPStreamHandler";
    private static final String DEFAULT_I_CONNECTION_HANDLER_LABEL = "Connection Handler Classname";
    private static final String DEFAULT_I_USERNAME_PASSWORD = "guest";
    private static final String DEFAULT_I_USERNAME_LABEL = "Default Username";
    private static final String DEFAULT_I_PASSWORD_LABEL = "Default Password";
    private static final String DEFAULT_I_ACKTIMEOUT = "0";
    private static final String DEFAULT_I_ACKTIMEOUT_LABEL = "Acknowledgement Timeout";
    private static final boolean DEFAULT_JMSXPROP_VALUE = false;
    private transient boolean adminConnectionCreated = false;
    private transient boolean adminKeyUsed = false;
    private transient String connectionType = "NORMAL";

    public BasicConnectionFactory() {
        super(defaultsBase);
    }

    protected BasicConnectionFactory(String defaultsBase) {
        super(defaultsBase);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.adminConnectionCreated = false;
        this.adminKeyUsed = false;
        this.connectionType = "NORMAL";
    }

    public Connection createConnection() throws javax.jms.JMSException {
        return this.createConnection(this.getProperty("tmqiDefaultUsername"), this.getProperty("tmqiDefaultPassword"));
    }

    public Connection createConnection(String username, String password) throws javax.jms.JMSException {
        return new UnifiedConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    public final void setConnectionType(String type) {
        this.connectionType = "ADMINKEY".equals(type) || "ADMIN".equals(type) ? type : "NORMAL";
    }

    public final String getConnectionType() {
        if (this.connectionType == null) {
            this.connectionType = "NORMAL";
        }
        return this.connectionType;
    }

    @Override
    public String toString() {
        return defaultsBase + super.toString();
    }

    @Override
    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("tmqiConnectionHandler", DEFAULT_I_CONNECTION_HANDLER);
        this.configurationTypes.put("tmqiConnectionHandler", "com.tongtech.tmqi.PropertyOwner");
        this.configurationLabels.put("tmqiConnectionHandler", DEFAULT_I_CONNECTION_HANDLER_LABEL);
        this.configuration.put("tmqiDefaultUsername", DEFAULT_I_USERNAME_PASSWORD);
        this.configurationTypes.put("tmqiDefaultUsername", "java.lang.String");
        this.configurationLabels.put("tmqiDefaultUsername", DEFAULT_I_USERNAME_LABEL);
        this.configuration.put("tmqiDefaultPassword", DEFAULT_I_USERNAME_PASSWORD);
        this.configurationTypes.put("tmqiDefaultPassword", "java.lang.String");
        this.configurationLabels.put("tmqiDefaultPassword", DEFAULT_I_PASSWORD_LABEL);
        this.configuration.put("tmqiAckTimeout", DEFAULT_I_ACKTIMEOUT);
        this.configurationTypes.put("tmqiAckTimeout", "java.lang.Integer");
        this.configurationLabels.put("tmqiAckTimeout", DEFAULT_I_ACKTIMEOUT_LABEL);
    }

    @Override
    public void overrideProperties() {
        String fileDir = Env.getEnvVariable("TCLIFILESDIR");
        if (fileDir != null && !fileDir.equals("")) {
            this.configuration.put("tmqiFileRcvDir", fileDir);
        }
    }

    @Override
    public void close() throws JMSException {
    }
}

