/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.apps.console;

import com.tongtech.tmqi.admin.apps.console.ActionManager;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class ConsoleObj
extends DefaultMutableTreeNode {
    @Override
    public String toString() {
        return this.getExplorerLabel();
    }

    public JPopupMenu getExporerPopupMenu(ActionManager actionMgr) {
        String label = this.toString();
        int mask = this.getExplorerPopupMenuItemMask();
        JPopupMenu popup = new JPopupMenu(label);
        popup.setLabel(label);
        this.checkActionFlag(actionMgr, popup, mask, 1024);
        this.checkActionFlag(actionMgr, popup, mask, 2048);
        this.checkActionFlag(actionMgr, popup, mask, 65536);
        this.checkActionFlag(actionMgr, popup, mask, 256);
        this.checkActionFlag(actionMgr, popup, mask, 512);
        this.checkActionFlag(actionMgr, popup, mask, 128);
        this.checkActionFlag(actionMgr, popup, mask, 64);
        this.checkActionFlag(actionMgr, popup, mask, 1);
        this.checkActionFlag(actionMgr, popup, mask, 2);
        this.checkActionFlag(actionMgr, popup, mask, 32768);
        this.checkActionFlag(actionMgr, popup, mask, 32);
        return popup;
    }

    public boolean canBeInspected() {
        return this.getInspectorPanelClassName() != null;
    }

    public String getActionLabel(int actionFlag, boolean forMenu) {
        return null;
    }

    public ImageIcon getActionIcon(int actionFlag) {
        return null;
    }

    private void checkActionFlag(ActionManager actionMgr, JPopupMenu popup, int mask, int actionFlag) {
        if (this.flagSet(mask, actionFlag)) {
            ImageIcon icon;
            String label;
            JMenuItem item = popup.add(actionMgr.getAction(actionFlag));
            char m = actionMgr.getCharMnemonic(actionFlag);
            if (m != '\u0000') {
                item.setMnemonic(m);
            }
            if ((label = this.getActionLabel(actionFlag, true)) != null) {
                item.setText(label);
            }
            if ((icon = this.getActionIcon(actionFlag)) != null) {
                item.setIcon(icon);
            }
        }
    }

    private boolean flagSet(int mask, int actionFlag) {
        return (mask & actionFlag) == actionFlag;
    }

    public abstract String getExplorerLabel();

    public abstract String getExplorerToolTip();

    public abstract ImageIcon getExplorerIcon();

    public abstract int getExplorerPopupMenuItemMask();

    public abstract int getActiveActions();

    public abstract String getInspectorPanelClassName();

    public abstract String getInspectorPanelId();

    public abstract String getInspectorPanelHeader();
}

