/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.apps.console;

import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.admin.apps.console.AdminDialog;
import com.tongtech.tmqi.admin.apps.console.util.IntegerField;
import com.tongtech.tmqi.admin.apps.console.util.LabelValuePanel;
import com.tongtech.tmqi.admin.apps.console.util.LabelledComponent;
import com.tongtech.tmqi.admin.apps.console.util.LongField;
import com.tongtech.tmqi.admin.resources.AdminConsoleResources;
import com.tongtech.tmqi.admin.util.Globals;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ObjStoreConFactoryDialog
extends AdminDialog
implements ActionListener {
    protected JTabbedPane tabbedPane;
    protected JTextField lookupText;
    protected JLabel lookupLabel;
    protected JLabel cfLabel;
    protected JCheckBox checkBox;
    protected JComboBox factoryCombo;
    protected Vector cfProps;
    protected LabelledComponent[] extraItems;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private LabelledComponent lookupItem;
    private boolean addExtra;

    public ObjStoreConFactoryDialog(Frame parent, String title) {
        super(parent, title, 81);
    }

    public ObjStoreConFactoryDialog(Frame parent, String title, int whichButtons) {
        super(parent, title, whichButtons, false);
    }

    @Override
    public JPanel createWorkPanel() {
        boolean propsDlg = false;
        if (this.getTitle().equals(acr.getString("A1301"))) {
            propsDlg = true;
        }
        JPanel workPanel = new JPanel();
        JPanel topPanel = this.makeTopPanel(propsDlg);
        QueueConnectionFactory aobj = new QueueConnectionFactory();
        String groupString = aobj.getPropertyGroups();
        String[] groups = this.stringToArray(groupString, "|");
        if (groups == null) {
            return workPanel;
        }
        GridBagLayout gridbag = new GridBagLayout();
        workPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(topPanel, c);
        workPanel.add(topPanel);
        this.tabbedPane = new JTabbedPane();
        this.cfProps = new Vector();
        for (int i = 0; i < groups.length; ++i) {
            String groupPropsString;
            String[] props;
            String groupName = aobj.getLabelForGroup(groups[i]);
            JPanel groupPanel = this.layoutGroupProperties(groups[i], groupName, props = this.stringToArray(groupPropsString = aobj.getPropertiesForGroup(groups[i]), "|"), aobj);
            if (groupPanel == null) continue;
            this.tabbedPane.addTab(groupName, groupPanel);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(this.tabbedPane, c);
        workPanel.add(this.tabbedPane);
        if (propsDlg) {
            int maxWidth = this.tabbedPane.getPreferredSize().width;
            Dimension dim = new Dimension(maxWidth - this.lookupItem.getLabelWidth() - 40, this.lookupLabel.getPreferredSize().height);
            this.lookupItem.getComponent().setPreferredSize(dim);
        }
        return workPanel;
    }

    private JPanel makeTopPanel(boolean propsDlg) {
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagLayout gridbag = new GridBagLayout();
        topPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel1 = new JPanel(new GridLayout(0, 1, -1, -1));
        LabelledComponent[] items = new LabelledComponent[3];
        this.checkBox = new JCheckBox();
        if (propsDlg) {
            this.lookupLabel = new JLabel(" ");
            this.cfLabel = new JLabel(" ");
            items[0] = new LabelledComponent(acr.getString("A1302") + ":", this.lookupLabel);
            this.lookupItem = items[0];
            items[1] = new LabelledComponent(acr.getString("A1303") + ":", this.cfLabel);
        } else {
            this.lookupText = new JTextField(25);
            String[] stringArray = new String[6];
            stringArray[0] = acr.getString("A1235");
            stringArray[1] = acr.getString("A1203");
            stringArray[2] = acr.getString("A1204");
            stringArray[3] = acr.getString("A1234");
            stringArray[4] = acr.getString("A1232");
            stringArray[5] = acr.getString("A1233");
            String[] factories = stringArray;
            this.factoryCombo = new JComboBox<String>(factories);
            items[0] = new LabelledComponent(acr.getString("A1302") + ":", this.lookupText);
            items[1] = new LabelledComponent(acr.getString("A1303") + ":", (JComponent)this.factoryCombo, 0);
        }
        items[2] = new LabelledComponent(acr.getString("A1315") + ":", this.checkBox);
        LabelValuePanel lvp = new LabelValuePanel(items, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        gridbag.setConstraints(panel1, c);
        topPanel.add(panel1);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        gridbag.setConstraints(lvp, c);
        topPanel.add(lvp);
        return topPanel;
    }

    private JPanel makeConnHandlerPanel() {
        JPanel chPanel = new JPanel();
        return chPanel;
    }

    @Override
    public void doOK() {
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doClose() {
    }

    @Override
    public void doClear() {
    }

    private String[] stringToArray(String from, String separator) {
        if (from == null) {
            return null;
        }
        if (separator == null) {
            separator = " ";
        }
        StringTokenizer toks = new StringTokenizer(from, separator);
        String[] result = new String[toks.countTokens()];
        int i = 0;
        while (toks.hasMoreTokens()) {
            result[i++] = toks.nextToken().trim();
        }
        return result;
    }

    private JPanel layoutGroupProperties(String groupNumber, String groupName, String[] props, AdministeredObject aobj) {
        LabelledComponent[] items = new LabelledComponent[props.length];
        int k = 0;
        this.addExtra = false;
        for (int i = 0; i < props.length; ++i) {
            items[k++] = this.makeLabelledComponent(aobj, props[i]);
            if (!this.addExtra) continue;
            for (int j = 0; j < this.extraItems.length; ++j) {
                items[k++] = this.extraItems[j];
            }
            this.addExtra = false;
        }
        LabelValuePanel lvp = new LabelValuePanel(items, 5, 5);
        for (int i = 0; i < items.length; ++i) {
            this.cfProps.add(items[i]);
        }
        return lvp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            this.doComboBox((JComboBox)source);
        } else {
            super.actionPerformed(e);
        }
    }

    public void doComboBox(JComboBox comboBox) {
        String name = (String)comboBox.getSelectedItem();
    }

    protected void setValue(JComponent c, String propType, String value) {
        if (propType.equals("List") && c instanceof JComboBox) {
            ((JComboBox)c).setSelectedItem(value);
        } else if (propType.equals("java.lang.String") && c instanceof JTextField) {
            ((JTextField)c).setText(value);
        } else if (propType.equals("java.lang.Integer") && c instanceof JTextField) {
            ((JTextField)c).setText(value);
        } else if (propType.equals("java.lang.Long") && c instanceof JTextField) {
            ((JTextField)c).setText(value);
        } else if (propType.equals("java.lang.Boolean") && c instanceof JCheckBox) {
            if (value.equalsIgnoreCase("true")) {
                ((JCheckBox)c).setSelected(true);
            } else {
                ((JCheckBox)c).setSelected(false);
            }
        } else {
            System.err.println("No setting for " + propType + " " + value);
        }
    }

    protected String getValue(JComponent c, String propType) {
        String value = "";
        if (propType.equals("List") && c instanceof JComboBox) {
            value = (String)((JComboBox)c).getSelectedItem();
        } else if (propType.equals("java.lang.String") && c instanceof JTextField) {
            value = ((JTextField)c).getText();
        } else if (propType.equals("java.lang.Integer") && c instanceof JTextField) {
            value = ((JTextField)c).getText();
        } else if (propType.equals("java.lang.Long") && c instanceof JTextField) {
            value = ((JTextField)c).getText();
        } else if (propType.equals("java.lang.Boolean") && c instanceof JCheckBox) {
            value = ((JCheckBox)c).isSelected() ? "true" : "false";
        } else {
            System.err.println("No value for " + propType + " " + c);
        }
        return value;
    }

    private void changeOtherValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals("...")) continue;
            values[i] = acr.getString("A1216");
        }
    }

    private String[] omitOtherValues(String[] values) {
        int newLength = values.length;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals("...")) continue;
            --newLength;
        }
        String[] newValues = new String[newLength];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals("...")) continue;
            newValues[j++] = values[i];
        }
        return newValues;
    }

    private LabelledComponent makeLabelledComponent(AdministeredObject aobj, String propName) {
        LabelledComponent lc = null;
        String propType = null;
        String propLabel = null;
        String propDefault = null;
        try {
            propType = aobj.getPropertyType(propName);
            propLabel = aobj.getPropertyLabel(propName);
            propDefault = aobj.getProperty(propName);
        }
        catch (Exception e) {
            System.out.println("Exception for property: " + propName + e.toString());
        }
        if (propType.equals("List")) {
            String listValues = aobj.getPropertyListValues(propName);
            String[] comboValues = this.stringToArray(listValues, "|");
            comboValues = this.omitOtherValues(comboValues);
            this.changeOtherValues(comboValues);
            if (comboValues != null) {
                lc = new LabelledComponent(propLabel + ":", new JComboBox<String>(comboValues));
                JComboBox comp = (JComboBox)lc.getComponent();
                comp.addActionListener(this);
                lc.setClientData(propName);
            }
            this.extraItems = new LabelledComponent[0];
        } else if (propType.equals("java.lang.Integer")) {
            lc = propDefault == null ? new LabelledComponent(propLabel + ":", new IntegerField(Integer.MIN_VALUE, Integer.MAX_VALUE, propDefault, 7)) : new LabelledComponent(propLabel + ":", new IntegerField(Integer.MIN_VALUE, Integer.MAX_VALUE, 7));
            lc.setClientData(propName);
        } else if (propType.equals("java.lang.Long")) {
            lc = propDefault == null ? new LabelledComponent(propLabel + ":", new LongField(Long.MIN_VALUE, Long.MAX_VALUE, propDefault, 7)) : new LabelledComponent(propLabel + ":", new LongField(Long.MIN_VALUE, Long.MAX_VALUE, 7));
            lc.setClientData(propName);
        } else if (propType.equals("java.lang.Boolean")) {
            lc = new LabelledComponent(propLabel + ":", new JCheckBox());
            lc.setClientData(propName);
        } else if (propType.equals("java.lang.String")) {
            lc = new LabelledComponent(propLabel + ":", new JTextField(15));
            lc.setClientData(propName);
        } else {
            lc = new LabelledComponent(propLabel + ":", new JTextField(15));
            lc.setClientData(propName);
        }
        return lc;
    }

    protected void setOtherValues(AdministeredObject tempObj, boolean setDisabledItemsOnly) {
        Object propType = null;
        Object propDefault = null;
        Object connType = null;
    }
}

