/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.apps.console;

import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.Queue;
import com.tongtech.tmqi.Topic;
import com.tongtech.tmqi.admin.apps.console.ObjStoreDestCObj;
import com.tongtech.tmqi.admin.apps.console.ObjStoreDestDialog;
import com.tongtech.tmqi.admin.apps.console.event.ObjAdminEvent;
import com.tongtech.tmqi.admin.objstore.ObjStore;
import com.tongtech.tmqi.admin.resources.AdminConsoleResources;
import com.tongtech.tmqi.admin.util.Globals;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;

public class ObjStoreDestPropsDialog
extends ObjStoreDestDialog {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private static String[] okcancel;
    private ObjStoreDestCObj osDestCObj;

    public ObjStoreDestPropsDialog(Frame parent) {
        super(parent, acr.getString("A1300"), 81);
        this.setHelpId("destination_obj_properties");
    }

    @Override
    public void doOK() {
        this.osDestCObj = this.osDestCObj;
        Object object = this.osDestCObj.getObject();
        if (object instanceof AdministeredObject) {
            AdministeredObject adminObj = (AdministeredObject)object;
            String curVersion = adminObj.getVERSION();
            String objVersion = adminObj.getStoredVersion();
            if (!adminObj.isStoredVersionCompatible()) {
                int response = JOptionPane.showOptionDialog(this, acr.getString("A2003", objVersion, curVersion), acr.getString("A1300") + ": " + acr.getString("A1516", "A2003"), 0, 2, null, okcancel, okcancel[1]);
                if (response == 1) {
                    return;
                }
            }
        }
        String lookupName = this.lookupLabel.getText();
        if ((lookupName = lookupName.trim()) == null || lookupName.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3000"), acr.getString("A1300") + ": " + acr.getString("A1218", "A3000"), 0, 0, null, close, close[0]);
            return;
        }
        int type = 1;
        Destination tempObj = null;
        if (this.destLabel.getText().equals(acr.getString("A1201"))) {
            type = 1;
            tempObj = new Queue();
        } else if (this.destLabel.getText().equals(acr.getString("A1202"))) {
            type = 2;
            tempObj = new Topic();
        }
        int i = 0;
        Properties props = tempObj.getConfiguration();
        Enumeration e = tempObj.enumeratePropertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = this.textItems[i].getText();
            if (!(value = value.trim()).trim().equals("")) {
                props.put(propName, value);
            }
            ++i;
        }
        ObjAdminEvent oae = new ObjAdminEvent(this, 5);
        ObjStore os = this.osDestCObj.getObjStore();
        oae.setLookupName(lookupName);
        oae.setObjStore(os);
        oae.setDestinationType(type);
        oae.setObjProperties(props);
        if (this.checkBox.isSelected()) {
            oae.setReadOnly(true);
        } else {
            oae.setReadOnly(false);
        }
        oae.setOKAction(true);
        this.fireAdminEventDispatched(oae);
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
        this.hide();
    }

    @Override
    public void doClose() {
        this.hide();
    }

    @Override
    public void doClear() {
    }

    @Override
    public void show() {
    }

    public void show(ObjStoreDestCObj osDestCObj) {
        this.osDestCObj = osDestCObj;
        ObjStore os = osDestCObj.getObjStore();
        this.lookupLabel.setText(osDestCObj.getLookupName());
        Object object = osDestCObj.getObject();
        if (object instanceof Queue) {
            this.destLabel.setText(acr.getString("A1201"));
        } else {
            this.destLabel.setText(acr.getString("A1202"));
        }
        AdministeredObject adminObj = (AdministeredObject)object;
        Properties props = adminObj.getConfiguration();
        int i = 0;
        Enumeration e = adminObj.enumeratePropertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            try {
                this.textItems[i].setText(adminObj.getProperty(propName));
            }
            catch (Exception ex) {
                this.textItems[i].setText("");
            }
            ++i;
        }
        if (adminObj.isReadOnly()) {
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
        }
        if (props.size() > 0) {
            this.textItems[0].requestFocus();
        }
        super.show();
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        okcancel = new String[]{"OK", "Cancel"};
    }
}

